/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.StudioGeminiBundle;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.designer.compose.preview.BaseComposePreviewAction;
import com.android.studio.ml.designer.compose.preview.agents.AgentInvoker;
import com.android.studio.ml.designer.compose.preview.agents.AgentInvokerImpl;
import com.android.studio.ml.designer.compose.preview.agents.actions.FixWithAIButton;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueNode;
import com.android.tools.idea.studiobot.StudioBot;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.Project;
import icons.SmlIcons;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J#\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R \u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/actions/FixRenderIssuesAction;", "Lcom/android/studio/ml/designer/compose/preview/BaseComposePreviewAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "agentInvokerForTests", "Lcom/android/studio/ml/designer/compose/preview/agents/AgentInvoker;", "getAgentInvokerForTests$aiplugin_android", "()Lcom/android/studio/ml/designer/compose/preview/agents/AgentInvoker;", "setAgentInvokerForTests$aiplugin_android", "(Lcom/android/studio/ml/designer/compose/preview/agents/AgentInvoker;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isStudioBotReady", "", "project", "Lcom/intellij/openapi/project/Project;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performAiAction", "runAgent", "issues", "", "Lcom/android/tools/idea/common/error/Issue;", "runAgent$aiplugin_android", "getUiRenderIssues", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "component", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class FixRenderIssuesAction
extends BaseComposePreviewAction
implements CustomComponentAction {
    @TestOnly
    @Nullable
    private AgentInvoker agentInvokerForTests;
    public static final int $stable = 8;

    public FixRenderIssuesAction() {
        super(StudioGeminiBundle.Companion.message("designer.action.fix.with.ai.button", new Object[0]), null, SmlIcons.AiAction);
    }

    @Nullable
    public final AgentInvoker getAgentInvokerForTests$aiplugin_android() {
        return this.agentInvokerForTests;
    }

    public final void setAgentInvokerForTests$aiplugin_android(@Nullable AgentInvoker agentInvoker) {
        this.agentInvokerForTests = agentInvoker;
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final boolean isStudioBotReady(Project project2) {
        return StudioBot.Companion.getInstance().chat(project2).isReadyToReceiveQuery(ResponseMode.Agent);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (!e.getPresentation().isEnabledAndVisible()) {
            return;
        }
        Project project2 = e.getProject();
        e.getPresentation().setEnabled(project2 != null && this.isStudioBotReady(project2));
    }

    @Override
    public void performAiAction(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        this.runAgent$aiplugin_android(project3, this.getUiRenderIssues(e));
    }

    public final void runAgent$aiplugin_android(@NotNull Project project2, @NotNull List<? extends Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        AgentInvoker agentInvoker = this.agentInvokerForTests;
        if (agentInvoker == null) {
            agentInvoker = new AgentInvokerImpl(project2, null);
        }
        agentInvoker.invokeFixRenderIssuesAgent(issues);
    }

    private final List<Issue> getUiRenderIssues(AnActionEvent e) {
        Object selectedItem = e.getData(PlatformDataKeys.SELECTED_ITEM);
        Issue issue = selectedItem instanceof Issue ? (Issue)selectedItem : (selectedItem instanceof IssueNode ? ((IssueNode)selectedItem).getIssue() : null);
        return CollectionsKt.listOfNotNull((Object)issue);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        FixWithAIButton fixWithAIButton;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        FixWithAIButton button = fixWithAIButton = new FixWithAIButton(presentation, this);
        boolean bl = false;
        this.updateCustomComponent(button, presentation);
        return fixWithAIButton;
    }

    public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        FixWithAIButton fixWithAIButton = component2 instanceof FixWithAIButton ? (FixWithAIButton)component2 : null;
        if (fixWithAIButton == null) {
            return;
        }
        FixWithAIButton button = fixWithAIButton;
        button.updateComponent(presentation);
    }
}

