/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.designer.compose.preview.AnAiAction;
import com.android.studio.ml.designer.compose.preview.ComposePreviewGenerator;
import com.android.studio.ml.designer.compose.preview.TargetComposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0004J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\rH%J\b\u0010\u0014\u001a\u00020\u000bH$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/designer/compose/preview/GenerateComposePreviewBaseAction;", "Lcom/android/studio/ml/designer/compose/preview/AnAiAction;", "text", "", "previewGenerator", "Lcom/android/studio/ml/designer/compose/preview/ComposePreviewGenerator;", "<init>", "(Ljava/lang/String;Lcom/android/studio/ml/designer/compose/preview/ComposePreviewGenerator;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "generateComposePreviews", "", "composableFunctions", "", "Lcom/android/studio/ml/designer/compose/preview/TargetComposable;", "getTargetComposableFunctions", "isActionFlagEnabled", "aiplugin.android"})
@StabilityInferred(parameters=0)
public abstract class GenerateComposePreviewBaseAction
extends AnAiAction {
    @NotNull
    private final ComposePreviewGenerator previewGenerator;
    public static final int $stable = 8;

    public GenerateComposePreviewBaseAction(@NotNull String text2, @NotNull ComposePreviewGenerator previewGenerator) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)previewGenerator, (String)"previewGenerator");
        super(text2, null, null, 6, null);
        this.previewGenerator = previewGenerator;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    protected boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isActionFlagEnabled()) {
            return false;
        }
        if (!super.isEnabledAndVisible(e)) {
            return false;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        VirtualFile virtualFile2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (ProjectFileIndex.getInstance((Project)project3).isInLibrary(virtualFile3)) {
            return false;
        }
        if (!this.previewGenerator.canGeneratePreviews(project3)) {
            return false;
        }
        return !((Collection)this.getTargetComposableFunctions(e)).isEmpty();
    }

    protected final void generateComposePreviews(@NotNull AnActionEvent e, @NotNull List<TargetComposable> composableFunctions) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(composableFunctions, (String)"composableFunctions");
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        this.previewGenerator.generatePreviews(dataContext2, composableFunctions);
    }

    @RequiresReadLock
    @NotNull
    protected abstract List<TargetComposable> getTargetComposableFunctions(@NotNull AnActionEvent var1);

    protected abstract boolean isActionFlagEnabled();
}

