/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.flags.Flag;
import com.android.flags.FlagsUtilKt;
import com.android.studio.ml.ActiveModelProvider;
import com.android.studio.ml.ModelProvider;
import com.android.studio.ml.TransformService;
import com.android.studio.ml.designer.compose.preview.agents.actions.ComposePreviewAgentActionGroup;
import com.android.studio.ml.designer.compose.preview.agents.actions.ComposePreviewAgentsDropdownAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.FixRenderIssuesAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.FixVisualLintIssuesPanelAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.GenerateSingleComposePreviewForFileAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.ScreenshotToCodeAction;
import com.android.studio.ml.designer.compose.preview.agents.actions.TransformPreviewAction;
import com.android.studio.ml.designer.compose.preview.transform.GenerateComposePreviewsForFileAction;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.compose.preview.ComposeStudioBotActionFactory;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/designer/compose/preview/GeminiStudioBotActionFactory;", "Lcom/android/tools/idea/compose/preview/ComposeStudioBotActionFactory;", "<init>", "()V", "createPreviewGenerator", "Lcom/intellij/openapi/actionSystem/AnAction;", "transformPreviewAction", "fixVisualLintIssuesAction", "methodFqn", "", "fixComposeRenderIssueAction", "previewAgentsDropDownAction", "Lcom/android/tools/adtui/actions/DropDownAction;", "previewAgentsActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "screenshotToCodeAction", "isFeatureSupported", "", "feature", "Lcom/android/studio/ml/TransformService$Feature;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class GeminiStudioBotActionFactory
implements ComposeStudioBotActionFactory {
    public static final int $stable;

    @Nullable
    public AnAction createPreviewGenerator() {
        if (((Boolean)StudioFlags.COMPOSE_PREVIEW_GENERATE_PREVIEW_AGENTIC.get()).booleanValue()) {
            return new GenerateSingleComposePreviewForFileAction();
        }
        if (this.isFeatureSupported(TransformService.Feature.GENERATE_COMPOSE_PREVIEW)) {
            return new GenerateComposePreviewsForFileAction(null, null, 3, null);
        }
        return null;
    }

    @Nullable
    public AnAction transformPreviewAction() {
        if (((Boolean)StudioFlags.COMPOSE_PREVIEW_TRANSFORM_UI_WITH_AI_AGENTIC.get()).booleanValue()) {
            return new TransformPreviewAction(null, 1, null);
        }
        if (this.isFeatureSupported(TransformService.Feature.MULTIMODAL_PREVIEW_TRANSFORM)) {
            return new com.android.studio.ml.designer.compose.preview.transform.TransformPreviewAction(null, 1, null);
        }
        return null;
    }

    @Nullable
    public AnAction fixVisualLintIssuesAction(@NotNull String methodFqn) {
        Intrinsics.checkNotNullParameter((Object)methodFqn, (String)"methodFqn");
        Flag flag = StudioFlags.COMPOSE_UI_CHECK_FIX_WITH_AI;
        Intrinsics.checkNotNullExpressionValue((Object)flag, (String)"COMPOSE_UI_CHECK_FIX_WITH_AI");
        return (AnAction)FlagsUtilKt.ifEnabled((Flag)flag, () -> GeminiStudioBotActionFactory.fixVisualLintIssuesAction$lambda$0(methodFqn));
    }

    @Nullable
    public AnAction fixComposeRenderIssueAction() {
        Flag flag = StudioFlags.COMPOSE_RENDER_ERROR_FIX_WITH_AI;
        Intrinsics.checkNotNullExpressionValue((Object)flag, (String)"COMPOSE_RENDER_ERROR_FIX_WITH_AI");
        return (AnAction)FlagsUtilKt.ifEnabled((Flag)flag, GeminiStudioBotActionFactory::fixComposeRenderIssueAction$lambda$1);
    }

    @Nullable
    public DropDownAction previewAgentsDropDownAction() {
        if (((Boolean)StudioFlags.COMPOSE_PREVIEW_TRANSFORM_UI_WITH_AI_AGENTIC.get()).booleanValue() || ((Boolean)StudioFlags.COMPOSE_PREVIEW_MATCH_UI_AGENT.get()).booleanValue() || ((Boolean)StudioFlags.COMPOSE_UI_CHECK_FIX_WITH_AI.get()).booleanValue()) {
            return new ComposePreviewAgentsDropdownAction();
        }
        return null;
    }

    @Nullable
    public DefaultActionGroup previewAgentsActionGroup() {
        if (((Boolean)StudioFlags.COMPOSE_PREVIEW_TRANSFORM_UI_WITH_AI_AGENTIC.get()).booleanValue() || ((Boolean)StudioFlags.COMPOSE_PREVIEW_MATCH_UI_AGENT.get()).booleanValue() || ((Boolean)StudioFlags.COMPOSE_UI_CHECK_FIX_WITH_AI.get()).booleanValue()) {
            return new ComposePreviewAgentActionGroup();
        }
        return null;
    }

    @NotNull
    public AnAction screenshotToCodeAction() {
        return new ScreenshotToCodeAction();
    }

    private final boolean isFeatureSupported(TransformService.Feature feature) {
        TransformService transformService;
        ModelProvider modelProvider = (ModelProvider)ActiveModelProvider.Companion.getInstance().getModelProvider().getValue();
        return modelProvider != null && (transformService = modelProvider.getTransformService()) != null ? transformService.supportsFeature(feature) : false;
    }

    private static final FixVisualLintIssuesPanelAction fixVisualLintIssuesAction$lambda$0(String $methodFqn) {
        return new FixVisualLintIssuesPanelAction(StringsKt.substringAfterLast$default((String)$methodFqn, (String)".", null, (int)2, null));
    }

    private static final FixRenderIssuesAction fixComposeRenderIssueAction$lambda$1() {
        return new FixRenderIssuesAction();
    }
}

