/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.parse;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.SmlConversation;
import com.android.studio.ml.bot.parse.Topic;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/bot/parse/TopicRecognizer;", "", "()V", "topics", "", "Lcom/android/studio/ml/bot/parse/Topic;", "addTopics", "", "matches", "", "text", "", "find", "blocks", "Lcom/android/studio/ml/SmlConversation;", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class TopicRecognizer {
    @NotNull
    public static final TopicRecognizer INSTANCE = new TopicRecognizer();
    @NotNull
    private static final List<Topic> topics;
    public static final int $stable;

    private TopicRecognizer() {
    }

    @NotNull
    public final List<Topic> find(@NotNull List<? extends SmlConversation> blocks) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        List matches = new ArrayList();
        for (SmlConversation smlConversation : blocks) {
            if (!(smlConversation instanceof SmlConversation.TextChunk)) continue;
            this.addTopics(matches, ((SmlConversation.TextChunk)smlConversation).getText());
        }
        return matches;
    }

    @NotNull
    public final List<Topic> find(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List matches = new ArrayList();
        this.addTopics(matches, text2);
        return matches;
    }

    private final void addTopics(List<Topic> matches, String text2) {
        int length = text2.length();
        block0: for (Topic topic : topics) {
            if (matches.contains(topic)) continue;
            for (String keyword : topic.getKeywords()) {
                int index;
                int i2 = 0;
                while (i2 < length && (index = StringsKt.indexOf((CharSequence)text2, (String)keyword, (int)i2, (!topic.getCaseSensitive() ? 1 : 0) != 0)) != -1) {
                    if (topic.getWholeWord()) {
                        if (!(index != 0 && Character.isLetterOrDigit(text2.charAt(index - 1)) || index + keyword.length() != length && Character.isLetterOrDigit(text2.charAt(index + keyword.length())))) {
                            matches.add(topic);
                            continue block0;
                        }
                    } else {
                        matches.add(topic);
                        continue block0;
                    }
                    i2 = index + 1;
                }
            }
        }
    }

    static {
        Object[] objectArray = new Topic[4];
        Object[] objectArray2 = new String[]{"baseline profile", "baseline profiles"};
        objectArray[0] = new Topic("Baseline Profile", "https://developer.android.com/topic/performance/baselineprofiles/overview", CollectionsKt.listOf((Object[])objectArray2), false, true);
        objectArray[1] = new Topic("CameraX", "https://developer.android.com/training/camerax", CollectionsKt.listOf((Object)"CameraX"), true, true);
        objectArray2 = new String[]{"background location access", "ACCESS_BACKGROUND_LOCATION"};
        objectArray[2] = new Topic("Background Location Access", "https://developer.android.com/training/location/background", CollectionsKt.listOf((Object[])objectArray2), false, false, 16, null);
        objectArray[3] = new Topic("Advertising ID", "https://developer.android.com/training/articles/ad-id", CollectionsKt.listOf((Object)"advertising id"), false, false, 24, null);
        topics = CollectionsKt.listOf((Object[])objectArray);
        $stable = 8;
    }
}

