/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.history;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ChatSessionEvent;
import com.android.studio.ml.MetricsReporter;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.bot.history.Session;
import com.android.studio.ml.bot.history.SessionInfo;
import com.android.studio.ml.bot.history.SessionManager;
import com.android.studio.ml.bot.history.StoredSessionsInfoStore;
import com.android.studio.ml.bot.history.StoredSessionsMetadataState;
import com.google.common.hash.Hashing;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0011H\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020(0-2\u0006\u0010*\u001a\u00020.2\u0006\u0010+\u001a\u00020\u0011H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020.2\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0018\u00101\u001a\u0002022\u0006\u0010*\u001a\u00020.2\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0011H\u0002J\"\u00104\u001a\u0004\u0018\u0001052\u0006\u0010*\u001a\u00020.2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0010H\u0016J\u0018\u00106\u001a\u0002002\u0006\u0010*\u001a\u00020.2\u0006\u00107\u001a\u00020(H\u0016J\u0010\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020:H\u0002J\u001a\u0010;\u001a\u0004\u0018\u0001052\u0006\u0010*\u001a\u00020.2\u0006\u00107\u001a\u00020(H\u0016J\u001a\u0010;\u001a\u0004\u0018\u0001052\u0006\u0010<\u001a\u0002022\u0006\u00107\u001a\u00020(H\u0002J\u0010\u0010=\u001a\u0002002\u0006\u0010*\u001a\u00020.H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/studio/ml/bot/history/SessionManagerImpl;", "Lcom/android/studio/ml/bot/history/SessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_eventFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/android/studio/ml/bot/history/SessionManager$ModificationEvent;", "cleanedUpKeys", "", "Lkotlin/Pair;", "", "Lcom/android/studio/ml/bot/ResponseMode;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDateFormat$annotations", "()V", "eventFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "getEventFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "value", "", "hasRestoredHistoryManagerSessions", "getHasRestoredHistoryManagerSessions", "()Z", "setHasRestoredHistoryManagerSessions", "(Z)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addSessionInfoToStore", "Lcom/android/studio/ml/bot/history/SessionInfo;", "sessionTitle", "user", "responseMode", "availableSessions", "", "Lcom/android/studio/ml/bot/history/SessionManager$User;", "cleanupHistoryStorage", "", "constructSessionsStoragePath", "Ljava/nio/file/Path;", "userDirectoryName", "createSession", "Lcom/android/studio/ml/bot/history/Session;", "deleteSession", "sessionInfo", "formatTime", "time", "Ljava/time/ZonedDateTime;", "getSession", "storageFilePath", "migrateLegacyHistory", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\ncom/android/studio/ml/bot/history/SessionManagerImpl\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,568:1\n95#2:569\n135#2,2:570\n137#2:579\n95#2:580\n135#2,3:581\n774#3:572\n865#3,2:573\n1563#3:575\n1634#3,3:576\n774#3:584\n865#3,2:585\n1563#3:587\n1634#3,3:588\n1617#3,9:591\n1869#3:600\n1870#3:602\n1626#3:603\n774#3:605\n865#3,2:606\n1208#3,2:608\n1236#3,4:610\n1869#3,2:614\n1#4:601\n1#4:604\n*S KotlinDebug\n*F\n+ 1 SessionManager.kt\ncom/android/studio/ml/bot/history/SessionManagerImpl\n*L\n196#1:569\n196#1:570,2\n196#1:579\n329#1:580\n329#1:581,3\n203#1:572\n203#1:573,2\n204#1:575\n204#1:576,3\n379#1:584\n379#1:585,2\n380#1:587\n380#1:588,3\n381#1:591,9\n381#1:600\n381#1:602\n381#1:603\n406#1:605\n406#1:606,2\n407#1:608,2\n407#1:610,4\n420#1:614,2\n381#1:601\n*E\n"})
public final class SessionManagerImpl
implements SessionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @NotNull
    private final MutableSharedFlow<SessionManager.ModificationEvent> _eventFlow;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<Pair<String, ResponseMode>> cleanedUpKeys;
    @NotNull
    private final SharedFlow<SessionManager.ModificationEvent> eventFlow;
    private final DateTimeFormatter dateFormat;
    public static final int $stable = 8;
    @NotNull
    public static final String HISTORY_STORAGE_ROOT_DIR = "history-storage";
    @NotNull
    public static final String LEGACY_SESSION_RESTORED_KEY = "studio.ml.bot.history.legacySessionRestored";

    public SessionManagerImpl(@NotNull Project project2, @NotNull CoroutineScope coroutineScope, @NotNull CoroutineDispatcher ioDispatcher) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.ioDispatcher = ioDispatcher;
        this._eventFlow = SharedFlowKt.MutableSharedFlow((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        Logger logger = Logger.getInstance(SessionManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.cleanedUpKeys = new LinkedHashSet();
        this.eventFlow = FlowKt.asSharedFlow(this._eventFlow);
        this.dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public SessionManagerImpl(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this(project2, coroutineScope, Dispatchers.getIO());
    }

    private final boolean getHasRestoredHistoryManagerSessions() {
        return PropertiesComponent.getInstance().getBoolean(LEGACY_SESSION_RESTORED_KEY, false);
    }

    private final void setHasRestoredHistoryManagerSessions(boolean value) {
        PropertiesComponent.getInstance().setValue(LEGACY_SESSION_RESTORED_KEY, value);
    }

    @Override
    @NotNull
    public SharedFlow<SessionManager.ModificationEvent> getEventFlow() {
        return this.eventFlow;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SessionInfo> availableSessions(@NotNull SessionManager.User user, @NotNull ResponseMode responseMode2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        StoredSessionsMetadataState.SessionInfoState it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)responseMode2), (String)"responseMode");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.migrateLegacyHistory(user);
        this.cleanupHistoryStorage(user, responseMode2);
        Iterable iterable = ((StoredSessionsMetadataState)StoredSessionsInfoStore.Companion.getInstance(this.project).getState()).getSessions();
        boolean $i$f$filter = false;
        void var12_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (StoredSessionsMetadataState.SessionInfoState)((Object)element$iv$iv);
            boolean bl2 = false;
            if (!(Intrinsics.areEqual((Object)user.getEmail(), (Object)it.getUser()) && it.getResponseMode() == responseMode2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (StoredSessionsMetadataState.SessionInfoState)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getSessionInfo());
        }
        List result$iv$iv = (List)destination$iv$iv;
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        List sessions = (List)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        int n = sessions.size();
        MetricsReporter.Companion.getInstance().logChatSessionEvent(new ChatSessionEvent.List(responseMode2, Duration.box-impl((long)duration), n, null));
        return sessions;
    }

    @Override
    @Nullable
    public Session createSession(@NotNull SessionManager.User user, @NotNull ResponseMode responseMode2, @NotNull String sessionTitle) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)responseMode2), (String)"responseMode");
        Intrinsics.checkNotNullParameter((Object)sessionTitle, (String)"sessionTitle");
        try {
            Path sessionsPath = this.constructSessionsStoragePath(user, responseMode2);
            Files.createDirectories(sessionsPath, new FileAttribute[0]);
            SessionInfo sessionInfo = this.addSessionInfoToStore(sessionTitle, user.getEmail(), responseMode2);
            this._eventFlow.tryEmit((Object)new SessionManager.ModificationEvent.SessionCreated(user, responseMode2, sessionInfo));
            Files.createFile(sessionsPath.resolve(sessionInfo.getId() + ".bin"), new FileAttribute[0]);
            return this.getSession(user, sessionInfo);
        }
        catch (IOException e) {
            this.logger.warn("Failed to create Gemini session storage location.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteSession(@NotNull SessionManager.User user, @NotNull SessionInfo sessionInfo) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        if (sessionInfo.getResponseMode() == null) {
            this.logger.warn("Provided session info has no response mode, cannot delete session.");
            return;
        }
        Path sessionsPath = this.constructSessionsStoragePath(user, sessionInfo.getResponseMode());
        Path sessionFilePath = sessionsPath.resolve(sessionInfo.getId() + ".bin");
        boolean removed2 = ((StoredSessionsMetadataState)StoredSessionsInfoStore.Companion.getInstance(this.project).getState()).getSessions().removeIf(arg_0 -> SessionManagerImpl.deleteSession$lambda$3((Function1)new Function1<StoredSessionsMetadataState.SessionInfoState, Boolean>(sessionInfo){
            final /* synthetic */ SessionInfo $sessionInfo;
            {
                this.$sessionInfo = $sessionInfo;
                super(1);
            }

            public final Boolean invoke(StoredSessionsMetadataState.SessionInfoState it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return Intrinsics.areEqual((Object)it.getId(), (Object)this.$sessionInfo.getId());
            }
        }, arg_0));
        if (!removed2) {
            this.logger.warn("Failed to remove session info, it may have already been removed. Id:" + sessionInfo.getId());
        }
        if (removed2) {
            ResponseMode responseMode2 = sessionInfo.getResponseMode();
            String string = sessionInfo.getId();
            if (string == null) {
                string = "null";
            }
            this._eventFlow.tryEmit((Object)new SessionManager.ModificationEvent.SessionDeleted(user, responseMode2, string));
        }
        Intrinsics.checkNotNull((Object)sessionFilePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(sessionFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                Files.delete(sessionFilePath);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete session file for: " + sessionInfo, (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void getDateFormat$annotations() {
    }

    private final String formatTime(ZonedDateTime time) {
        String string = this.dateFormat.format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final SessionInfo addSessionInfoToStore(String sessionTitle, String user, ResponseMode responseMode2) {
        StoredSessionsMetadataState.SessionInfoState sessionInfoState;
        ZonedDateTime now = ZonedDateTime.now();
        StoredSessionsMetadataState.SessionInfoState $this$addSessionInfoToStore_u24lambda_u244 = sessionInfoState = new StoredSessionsMetadataState.SessionInfoState();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)now);
        $this$addSessionInfoToStore_u24lambda_u244.setId(this.formatTime(now) + "-" + UUID.randomUUID());
        $this$addSessionInfoToStore_u24lambda_u244.setTitle(sessionTitle);
        $this$addSessionInfoToStore_u24lambda_u244.setResponseMode(responseMode2);
        $this$addSessionInfoToStore_u24lambda_u244.setLastUpdateTimestamp(now.toInstant().toEpochMilli());
        $this$addSessionInfoToStore_u24lambda_u244.setUser(user);
        StoredSessionsMetadataState.SessionInfoState newSessionInfoState = sessionInfoState;
        ((StoredSessionsMetadataState)StoredSessionsInfoStore.Companion.getInstance(this.project).getState()).getSessions().add(newSessionInfoState);
        return newSessionInfoState.getSessionInfo();
    }

    @Override
    @Nullable
    public Session getSession(@NotNull SessionManager.User user, @NotNull SessionInfo sessionInfo) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        ResponseMode responseMode2 = sessionInfo.getResponseMode();
        if (responseMode2 == null) {
            return null;
        }
        Path path2 = this.constructSessionsStoragePath(user, responseMode2).resolve(sessionInfo.getId() + ".bin");
        if (path2 == null) {
            return null;
        }
        Path path3 = path2;
        return this.getSession(path3, sessionInfo);
    }

    private final Session getSession(Path storageFilePath, SessionInfo sessionInfo) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.notExists(storageFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            Session result$iv$iv = Session.Companion.createConnection(storageFilePath, sessionInfo, this.coroutineScope, this.ioDispatcher);
            TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            Session session2 = (Session)timedValue.component1();
            long duration = timedValue.component2-UwyO8pc();
            MetricsReporter.Companion.getInstance().logChatSessionEvent(new ChatSessionEvent.Load(sessionInfo.getResponseMode(), Duration.box-impl((long)duration), ((List)session2.getEntries().getValue()).size(), null, 8, null));
            return session2;
        }
        this.logger.warn("Attempt to connect to a non-existent session storage file.");
        MetricsReporter.Companion.getInstance().logChatSessionEvent(new ChatSessionEvent.Load(sessionInfo.getResponseMode(), null, 0, "session_storage_not_found", 6, null));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanupHistoryStorage(SessionManager.User user, ResponseMode responseMode2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object $this$mapNotNullTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        StoredSessionsMetadataState.SessionInfoState it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Pair key = new Pair((Object)user.getEmail(), (Object)responseMode2);
        if (this.cleanedUpKeys.contains(key)) {
            return;
        }
        this.cleanedUpKeys.add((Pair<String, ResponseMode>)key);
        StoredSessionsInfoStore sessionInfoStore = StoredSessionsInfoStore.Companion.getInstance(this.project);
        Iterable iterable = ((StoredSessionsMetadataState)sessionInfoStore.getState()).getSessions();
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv2;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (StoredSessionsMetadataState.SessionInfoState)((Object)element$iv$iv);
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)user.getEmail(), (Object)it.getUser()) && it.getResponseMode() == responseMode2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (StoredSessionsMetadataState.SessionInfoState)((Object)item$iv$iv);
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getSessionInfo());
        }
        List sessionsInStore = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = sessionsInStore;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            SessionInfo it2 = (SessionInfo)element$iv$iv;
            boolean bl3 = false;
            if (it2.getId() == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set idsInStore = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Path historyPath = this.constructSessionsStoragePath(user, responseMode2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(historyPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            ((StoredSessionsMetadataState)sessionInfoStore.getState()).getSessions().removeIf(arg_0 -> SessionManagerImpl.cleanupHistoryStorage$lambda$9((Function1)new Function1<StoredSessionsMetadataState.SessionInfoState, Boolean>(user, responseMode2){
                final /* synthetic */ SessionManager.User $user;
                final /* synthetic */ ResponseMode $responseMode;
                {
                    this.$user = $user;
                    this.$responseMode = $responseMode;
                    super(1);
                }

                public final Boolean invoke(StoredSessionsMetadataState.SessionInfoState it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return Intrinsics.areEqual((Object)it.getUser(), (Object)this.$user.getEmail()) && it.getResponseMode() == this.$responseMode;
                }
            }, arg_0));
            return;
        }
        try {
            Object stream;
            $this$mapNotNullTo$iv$iv = Files.list(historyPath);
            destination$iv$iv2 = null;
            try {
                stream = (Stream)$this$mapNotNullTo$iv$iv;
                boolean bl5 = false;
                stream = stream.toList();
            }
            catch (Throwable bl5) {
                destination$iv$iv2 = bl5;
                throw bl5;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)$this$mapNotNullTo$iv$iv, (Throwable)destination$iv$iv2);
            }
            $this$mapNotNullTo$iv$iv = stream;
        }
        catch (IOException e) {
            this.logger.warn("Failed to list session files in " + historyPath, (Throwable)e);
            return;
        }
        Object sessionFilesOnDisk = $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNull((Object)sessionFilesOnDisk);
        Iterable e = (Iterable)sessionFilesOnDisk;
        boolean $i$f$filter2 = false;
        void bl5 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it3 = (Path)element$iv$iv;
            boolean bl6 = false;
            if (!StringsKt.endsWith$default((String)((Object)it3.getFileName()).toString(), (String)".bin", (boolean)false, (int)2, null)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv3 = $this$associateBy$iv;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it4;
            Path bl6 = (Path)element$iv$iv;
            object = destination$iv$iv4;
            boolean bl7 = false;
            object.put(StringsKt.removeSuffix((String)((Object)it4.getFileName()).toString(), (CharSequence)".bin"), element$iv$iv);
        }
        Map sessionFilesByIdOnDisk = destination$iv$iv4;
        Set idsOnDisk = sessionFilesByIdOnDisk.keySet();
        Set staleIdsInStore = SetsKt.minus((Set)idsInStore, (Iterable)idsOnDisk);
        if (!((Collection)staleIdsInStore).isEmpty()) {
            ((StoredSessionsMetadataState)sessionInfoStore.getState()).getSessions().removeIf(arg_0 -> SessionManagerImpl.cleanupHistoryStorage$lambda$13((Function1)new Function1<StoredSessionsMetadataState.SessionInfoState, Boolean>((Set<String>)staleIdsInStore){
                final /* synthetic */ Set<String> $staleIdsInStore;
                {
                    this.$staleIdsInStore = $staleIdsInStore;
                    super(1);
                }

                public final Boolean invoke(StoredSessionsMetadataState.SessionInfoState it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return CollectionsKt.contains((Iterable)this.$staleIdsInStore, (Object)it.getId());
                }
            }, arg_0));
        }
        Set unmatchedIdsOnDisk = SetsKt.minus(idsOnDisk, (Iterable)idsInStore);
        long fallbackTimestamp = Instant.now().toEpochMilli();
        Map restoredSessionsData = new LinkedHashMap();
        Iterable $this$forEach$iv = unmatchedIdsOnDisk;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            long l2;
            String id = (String)element$iv;
            boolean bl8 = false;
            Path file = (Path)sessionFilesByIdOnDisk.get(id);
            if (file == null) continue;
            try {
                l2 = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
            }
            catch (IOException e2) {
                this.logger.warn("Failed to read last modified time of session file: " + file, (Throwable)e2);
                l2 = fallbackTimestamp;
            }
            long restoredTimestamp = l2;
            try {
                if (Files.size(file) > 0L) {
                    restoredSessionsData.put(id, restoredTimestamp);
                    continue;
                }
                try {
                    Files.delete(file);
                }
                catch (IOException e3) {
                    this.logger.warn("Failed to delete empty, unmatched session file: " + file, (Throwable)e3);
                }
            }
            catch (IOException e4) {
                this.logger.warn("Failed to read size of session file: " + file, (Throwable)e4);
            }
        }
        if (!restoredSessionsData.isEmpty()) {
            sessionInfoStore.addRestoredIds(restoredSessionsData, responseMode2, user);
        }
    }

    private final void migrateLegacyHistory(SessionManager.User user) {
        if (this.getHasRestoredHistoryManagerSessions()) {
            return;
        }
        for (ResponseMode responseMode2 : ResponseMode.getEntries()) {
            Path legacyHistoryPath = Companion.legacyHistoryPathByResponseMode$aiplugin_core_aicore(responseMode2);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(legacyHistoryPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            try {
                byte[] fileContent = Files.readAllBytes(legacyHistoryPath);
                Intrinsics.checkNotNull((Object)fileContent);
                if (!(fileContent.length == 0)) {
                    SessionInfo newSessionInfo = this.addSessionInfoToStore(responseMode2.name() + " Mode thread", user.getEmail(), responseMode2);
                    Path newSessionFilePath = this.constructSessionsStoragePath(user, responseMode2).resolve(newSessionInfo.getId() + ".bin");
                    Files.createDirectories(newSessionFilePath.getParent(), new FileAttribute[0]);
                    Files.write(newSessionFilePath, fileContent, new OpenOption[0]);
                }
                Files.delete(legacyHistoryPath);
            }
            catch (IOException e) {
                this.logger.warn("Failed to migrate legacy history for " + responseMode2.name(), (Throwable)e);
            }
        }
        this.setHasRestoredHistoryManagerSessions(true);
    }

    private final Path constructSessionsStoragePath(SessionManager.User user, ResponseMode responseMode2) {
        return this.constructSessionsStoragePath(SessionManagerImpl.Companion.getStorageDirectoryName(user), responseMode2);
    }

    private final Path constructSessionsStoragePath(String userDirectoryName, ResponseMode responseMode2) {
        Path path2 = ProjectUtil.getProjectDataPath((Project)this.project, (String)HISTORY_STORAGE_ROOT_DIR).resolve(userDirectoryName).resolve(responseMode2.name());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private static final boolean deleteSession$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanupHistoryStorage$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanupHistoryStorage$lambda$13(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\f\u0010\r\u001a\u00020\u0004*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/bot/history/SessionManagerImpl$Companion;", "", "()V", "HISTORY_STORAGE_ROOT_DIR", "", "LEGACY_SESSION_RESTORED_KEY", "legacyHistoryPathByResponseMode", "Ljava/nio/file/Path;", "responseMode", "Lcom/android/studio/ml/bot/ResponseMode;", "legacyHistoryPathByResponseMode$aiplugin_core_aicore", "sanitizeEmail", "email", "getStorageDirectoryName", "Lcom/android/studio/ml/bot/history/SessionManager$User;", "aiplugin.core.aicore"})
    @SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\ncom/android/studio/ml/bot/history/SessionManagerImpl$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,568:1\n434#2:569\n507#2,5:570\n*S KotlinDebug\n*F\n+ 1 SessionManager.kt\ncom/android/studio/ml/bot/history/SessionManagerImpl$Companion\n*L\n539#1:569\n539#1:570,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getStorageDirectoryName(SessionManager.User $this$getStorageDirectoryName) {
            String string;
            SessionManager.User user = $this$getStorageDirectoryName;
            if (user instanceof SessionManager.User.Authenticated) {
                string = this.sanitizeEmail(((SessionManager.User.Authenticated)$this$getStorageDirectoryName).getUserInfo().getEmail());
            } else if (Intrinsics.areEqual((Object)user, (Object)SessionManager.User.Guest.INSTANCE)) {
                string = "guest";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String sanitizeEmail(String email) {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = StringsKt.replace$default((String)email, (String)"@", (String)"at", (boolean)false, (int)4, null);
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!Character.isLetterOrDigit(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            return ((StringBuilder)destination$iv$iv).toString() + Hashing.sha256().hashString((CharSequence)email, StandardCharsets.UTF_8);
        }

        @NotNull
        public final Path legacyHistoryPathByResponseMode$aiplugin_core_aicore(@NotNull ResponseMode responseMode2) {
            Intrinsics.checkNotNullParameter((Object)((Object)responseMode2), (String)"responseMode");
            String string = responseMode2.name();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String responseModeIdentifier = string2;
            Path path2 = PathManager.getSystemDir();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getSystemDir(...)");
            Path path3 = path2;
            Path path4 = path3.resolve("caches");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            path3 = path4;
            Path path5 = path3.resolve("gemini-" + responseModeIdentifier + "-history.bin");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            Path geminiSystemHistoryPath = path5;
            switch (WhenMappings.$EnumSwitchMapping$0[responseMode2.ordinal()]) {
                case 1: {
                    Path path6 = PathManager.getSystemDir();
                    Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"getSystemDir(...)");
                    Path path7 = path6;
                    Path path8 = path7.resolve("caches");
                    Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
                    path7 = path8;
                    Path path9 = path7.resolve("studio-bot-history.bin");
                    Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"resolve(...)");
                    Path preGeminiSystemHistoryPath = path9;
                    return Files.isReadable(preGeminiSystemHistoryPath) ? preGeminiSystemHistoryPath : geminiSystemHistoryPath;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return geminiSystemHistoryPath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ResponseMode.values().length];
                try {
                    nArray[ResponseMode.Chat.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ResponseMode.Agent.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

