/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.commands;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.TextUnit;
import com.android.studio.ml.SmlConversation;
import com.android.studio.ml.bot.agents.tools.build.BuildStateProvider;
import com.android.studio.ml.bot.parse.LanguageRecognizer;
import com.android.studio.ml.bot.ui.UserAvatarService;
import com.android.studio.ml.bot.ui.compose.timeline.Attachment;
import com.android.studio.ml.bot.ui.compose.timeline.ImageAttachment;
import com.android.studio.ml.bot.ui.compose.timeline.LocalFileAttachment;
import com.android.studio.ml.bot.ui.compose.timeline.messages.HighlighterProvider;
import com.android.studio.ml.util.CoroutineScopesKt;
import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.analyze.AnalyzeCurrentFileTool;
import com.google.aiplugin.agents.tools.read.ReadFileTool;
import com.google.aiplugin.agents.tools.read.ReadUrlTool;
import com.google.aiplugin.agents.tools.search.FindFilesTool;
import com.google.aiplugin.agents.tools.search.FindUsagesTool;
import com.google.aiplugin.agents.tools.search.GrepTool;
import com.google.aiplugin.agents.tools.search.ListDeclarationsInDirectoryTool;
import com.google.aiplugin.agents.tools.search.ListFilesTool;
import com.google.aiplugin.agents.tools.search.ResolveSymbolTool;
import com.google.aiplugin.agents.tools.vcs.GitTool;
import com.google.aiplugin.agents.tools.vcs.ListVcsRootsTool;
import com.google.aiplugin.agents.tools.write.ReplaceTextTool;
import com.google.aiplugin.agents.tools.write.WriteFileTool;
import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.ImageUtil;
import icons.SmlIcons;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.code.MimeType;
import org.jetbrains.jewel.foundation.code.highlighting.CodeHighlighter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001aA\u0010\t\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\"\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a6\u0010\u0017\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001aF\u0010\u001f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020#2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010&0%2\b\u0010'\u001a\u0004\u0018\u00010\u0001\u001a>\u0010(\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010&0%2\u0006\u0010)\u001a\u00020\u0001H\u0002\u001a\u001e\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0002\u001a4\u0010-\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010+\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/\u001a$\u00101\u001a\u00020\u00012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010+\u001a\u00020\f2\u0006\u00102\u001a\u00020/\u001a\u0014\u00103\u001a\u00020\u00072\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0002\u001a\b\u00104\u001a\u00020\u0001H\u0002\u001a(\u00105\u001a\u00020\u0001\"\b\b\u0000\u00106*\u00020&2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H60!2\u0006\u0010$\u001a\u00020&H\u0002\u001a\u0010\u00107\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0001H\u0002\u001a\u0010\u00108\u001a\u00020\u0010*\u00060\u0012j\u0002`\u0013H\u0002\u001a\u0018\u00109\u001a\u00020\u0010*\u00060\u0012j\u0002`\u00132\u0006\u0010:\u001a\u00020\u0001H\u0002\u001a\u000e\u0010;\u001a\u00020/*\u0004\u0018\u00010\u0002H\u0002\u001a\u000e\u0010<\u001a\u00020/*\u0004\u0018\u00010\u0002H\u0002\u001a\u000e\u0010=\u001a\u00020/*\u0004\u0018\u00010\u0002H\u0002\u001a\u0016\u0010>\u001a\u00020\u0001*\u00020?H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b@\u0010A\u001a\u0016\u0010B\u001a\u00020\u0001*\u00020CH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bD\u0010A\u001a\u000e\u0010E\u001a\u00020\u0001*\u0004\u0018\u00010&H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006F"}, d2={"textOrNull", "", "Lcom/android/studio/ml/SmlConversation;", "getTextOrNull", "(Lcom/android/studio/ml/SmlConversation;)Ljava/lang/String;", "createAvatarIcon", "icon", "Ljavax/swing/Icon;", "alt", "createIconTag", "cssClass", "width", "", "height", "(Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/String;", "emitAttachments", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "attachments", "", "Lcom/android/studio/ml/bot/ui/compose/timeline/Attachment;", "emitSyntaxHighlightedCode", "code", "language", "Lcom/android/tools/idea/studiobot/MimeType;", "project", "Lcom/intellij/openapi/project/Project;", "emitSyntaxHighlightedCode-zRgPoZQ", "(Ljava/lang/StringBuilder;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "emitToolCall", "tool", "Lcom/google/aiplugin/agents/Tool;", "toolHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "args", "", "", "thoughtSignature", "emitToolCallWithResponse", "response", "findConversationStart", "lastCount", "conversations", "getConversationAsHtml", "skipIcons", "", "skipColors", "getConversationAsText", "markdown", "getIconForTool", "getTimestamp", "getToolDisplayText", "Args", "markdownToHtml", "appendSeparator", "appendText", "string", "isCode", "isUser", "isVerified", "toHtmlColor", "Landroidx/compose/ui/graphics/Color;", "toHtmlColor-8_81llA", "(J)Ljava/lang/String;", "toHtmlFontSize", "Landroidx/compose/ui/unit/TextUnit;", "toHtmlFontSize--R2X_6o", "toTruncatedString", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Export.kt\ncom/android/studio/ml/bot/commands/ExportKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,616:1\n40#2,3:617\n1179#3,2:620\n*S KotlinDebug\n*F\n+ 1 Export.kt\ncom/android/studio/ml/bot/commands/ExportKt\n*L\n132#1:617,3\n240#1:620,2\n*E\n"})
public final class ExportKt {
    @NotNull
    public static final String getConversationAsHtml(@NotNull Project project2, @NotNull List<? extends SmlConversation> conversations, int lastCount, boolean skipIcons, boolean skipColors) {
        String thrown2;
        String $i$f$service22;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(conversations, (String)"conversations");
        StringBuilder sb = new StringBuilder();
        sb.append(StringsKt.trimIndent((String)("\n      <html>\n      <head>\n        <title>Gemini Conversation Log</title>\n        <style>\n          body { font-family: sans-serif; background-color: #f0f4f9; color: #3c4043; }\n          .thought { color: #777777; }\n          .container { max-width: 800px; margin: 0 auto; padding: 20px; }\n          .message-row { display: flex; margin-bottom: 12px; align-items: flex-start; }\n          .avatar { width: 32px; height: 32px; border-radius: 50%; margin-right: 15px; }\n          .message-container { flex-grow: 1; }\n          .message { border-radius: 18px; padding: 12px 16px 12px 16px; }\n          .user .message { }\n          .gemini .message { background-color: #ffffff; border: 1px solid #e0e0e0; display: flex; align-items: flex-start; }\n          .tool-call { border: 1px solid #4285f4; border-radius: 12px; padding: 12px 16px; margin-top: 10px; margin-bottom: 10px; }\n          .tool-call summary { cursor: pointer; font-weight: normal; display: flex; align-items: center; list-style: none; justify-content: space-between; }\n          .tool-call summary::-webkit-details-marker { display: none; }\n          .tool-call-summary-content { display: flex; align-items: center; }\n          .tool-call-summary-content svg { margin-right: 8px; }\n          .tool-call .arrow-up { display: none; }\n          .tool-call .arrow-down { display: block; }\n          .tool-call[open] .arrow-up { display: block; }\n          .tool-call[open] .arrow-down { display: none; }\n          .attachments { margin-top: 10px; }\n          pre { white-space: pre-wrap; word-wrap: break-word; background-color: #f5f5f5; padding: 10px; border-radius: 5px; }\n          h1 { color: #1f1f1f; }\n          p { margin: 0; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <h1>Gemini Conversation Log</h1>\n          <p style=\"margin-bottom: 20px;\">Saved: " + ExportKt.getTimestamp() + "</p>\n      ")));
        int start2 = ExportKt.findConversationStart(lastCount, conversations);
        try {
            boolean $i$f$service22 = false;
            Class<UserAvatarService> serviceClass$iv = UserAvatarService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            $i$f$service22 = ExportKt.createAvatarIcon(((UserAvatarService)object).getUserAvatar(), "User Avatar");
        }
        catch (Throwable thrown2) {
            $i$f$service22 = "";
        }
        String userIcon = $i$f$service22;
        try {
            thrown2 = ExportKt.createAvatarIcon(SmlIcons.BotAvatar, "Bot Avatar");
        }
        catch (Throwable thrown3) {
            thrown2 = "";
        }
        String botIcon = thrown2;
        int i2 = start2;
        while (i2 < conversations.size()) {
            SmlConversation conversation = conversations.get(i2);
            if (ExportKt.isUser(conversation)) {
                sb.append("<div class=\"message-row user\">\n");
                if (!skipIcons) {
                    sb.append(userIcon);
                }
                sb.append("<div class=\"message-container\">\n");
                sb.append("<div class=\"message\">\n");
                String string = ExportKt.getTextOrNull(conversation);
                if (string == null) {
                    string = "";
                }
                String text2 = string;
                sb.append(ExportKt.markdownToHtml(text2));
                if (conversation instanceof SmlConversation.Request && !((Collection)((SmlConversation.Request)conversation).getAttachments()).isEmpty()) {
                    ExportKt.emitAttachments(sb, ((SmlConversation.Request)conversation).getAttachments());
                }
                sb.append("</div>\n</div>\n</div>\n");
                ++i2;
                continue;
            }
            sb.append("<div class=\"message-row gemini\">\n");
            sb.append("<div class=\"message-container\">\n");
            sb.append("<div class=\"message\">\n");
            if (!skipIcons) {
                sb.append(botIcon);
            }
            sb.append("<div>");
            while (i2 < conversations.size() && !ExportKt.isUser(conversations.get(i2))) {
                SmlConversation current2 = conversations.get(i2);
                if (!(current2 instanceof SmlConversation.ThoughtChunk)) {
                    if (current2 instanceof SmlConversation.CodeChunk) {
                        String code;
                        String string = ExportKt.getTextOrNull(current2);
                        if (string == null) {
                            string = "";
                        }
                        if (!StringsKt.isBlank((CharSequence)(code = string))) {
                            String language2 = ((SmlConversation.CodeChunk)current2).getLanguage-_TXXkdE();
                            if (language2 != null && !skipColors) {
                                ExportKt.emitSyntaxHighlightedCode-zRgPoZQ(sb, code, language2, project2);
                            } else {
                                sb.append("<pre>\n");
                                sb.append(code);
                                sb.append("\n</pre>\n");
                            }
                        }
                    } else {
                        Object text3;
                        Object object = ExportKt.getTextOrNull(current2);
                        if (object == null) {
                            object = text3 = "";
                        }
                        if (current2 instanceof SmlConversation.TextChunk) {
                            while (i2 < conversations.size() - 1 && conversations.get(i2 + 1) instanceof SmlConversation.TextChunk) {
                                String string;
                                if ((string = ExportKt.getTextOrNull(conversations.get(++i2))) == null) {
                                    string = "";
                                }
                                text3 = (String)text3 + " " + string;
                            }
                        }
                        if (!StringsKt.isBlank((CharSequence)((CharSequence)text3))) {
                            sb.append(ExportKt.markdownToHtml((String)text3));
                        }
                    }
                }
                if (current2 instanceof SmlConversation.ToolCallChunk) {
                    ExportKt.emitToolCall(sb, ((SmlConversation.ToolCallChunk)current2).getTool(), ((SmlConversation.ToolCallChunk)current2).getToolHandler(), ((SmlConversation.ToolCallChunk)current2).getArgs(), ((SmlConversation.ToolCallChunk)current2).getThoughtSignature());
                } else if (current2 instanceof SmlConversation.ToolCallResponseChunk) {
                    ExportKt.emitToolCallWithResponse(sb, ((SmlConversation.ToolCallResponseChunk)current2).getTool(), ((SmlConversation.ToolCallResponseChunk)current2).getArgs(), ((SmlConversation.ToolCallResponseChunk)current2).getResponse());
                } else if (current2 instanceof SmlConversation.ToolCallWithResponseChunk) {
                    ExportKt.emitToolCallWithResponse(sb, ((SmlConversation.ToolCallWithResponseChunk)current2).getTool(), ((SmlConversation.ToolCallWithResponseChunk)current2).getArgs(), ((SmlConversation.ToolCallWithResponseChunk)current2).getResponse());
                }
                ++i2;
            }
            sb.append("</div>\n</div>\n</div>\n</div>\n");
        }
        sb.append("  </div>\n</body>\n</html>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final void emitToolCall(@NotNull StringBuilder sb, @NotNull Tool<?> tool, @NotNull ToolHandler toolHandler, @NotNull Map<String, ? extends Object> args, @Nullable String thoughtSignature) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter(tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)toolHandler, (String)"toolHandler");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (toolHandler instanceof BuildStateProvider.Active) {
            sb.append("<pre>\n");
            CharSequence $this$forEach$iv = (CharSequence)((BuildStateProvider.Active)((Object)toolHandler)).getConsoleState().getValue();
            boolean $i$f$forEach = false;
            for (int j = 0; j < $this$forEach$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$forEach$iv.charAt(j);
                boolean bl = false;
                ExportKt.appendText(sb, String.valueOf(it));
            }
            sb.append("</pre>\n");
        }
    }

    private static final void appendText(StringBuilder $this$appendText, String string) {
        int n = string.length();
        block4: for (int j = 0; j < n; ++j) {
            char c = string.charAt(j);
            switch (c) {
                case '<': {
                    $this$appendText.append("&lt;");
                    continue block4;
                }
                case '&': {
                    $this$appendText.append("&amp;");
                    continue block4;
                }
                default: {
                    $this$appendText.append(c);
                }
            }
        }
    }

    private static final void emitAttachments(StringBuilder sb, List<? extends Attachment> attachments) {
        sb.append("<div class=\"attachments\">");
        for (Attachment attachment2 : attachments) {
            Attachment attachment3 = attachment2;
            if (attachment3 instanceof ImageAttachment) {
                Path path2 = ((ImageAttachment)attachment2).getPath();
                if (path2 == null) continue;
                ImageIcon image = new ImageIcon(path2.toFile().getPath());
                int width = image.getIconWidth();
                int height = image.getIconHeight();
                if (height > 100) {
                    width = width * 100 / height;
                    height = 100;
                } else if (width > 100) {
                    height = height * 100 / width;
                    width = 100;
                }
                try {
                    image = new ImageIcon(ImageUtil.scaleImage((Image)image.getImage(), (int)width, (int)height));
                    Icon icon2 = image;
                    String string = path2.toFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    sb.append(ExportKt.createIconTag(icon2, string, null, width, height)).append("<br>");
                }
                catch (Exception e) {
                    sb.append("(Image attachment " + path2.toFile() + ")<br>\n");
                }
                continue;
            }
            if (!(attachment3 instanceof LocalFileAttachment)) continue;
            sb.append("File: " + ((LocalFileAttachment)attachment2).getPath() + "<br>");
        }
        sb.append("</div>");
    }

    private static final void emitSyntaxHighlightedCode-zRgPoZQ(StringBuilder sb, String code, String language2, Project project2) {
        String mimeType2 = MimeType.constructor-impl((String)language2);
        CodeHighlighter highlighter2 = HighlighterProvider.Companion.getHighlighter(project2, CoroutineScopesKt.getCoroutineScope(project2));
        Flow highlighted = highlighter2.highlight-zTGadEY(code, mimeType2);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AnnotatedString>, Object>((Flow<AnnotatedString>)highlighted, sb, null){
            int label;
            final /* synthetic */ Flow<AnnotatedString> $highlighted;
            final /* synthetic */ StringBuilder $sb;
            {
                this.$highlighted = $highlighted;
                this.$sb = $sb;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.first(this.$highlighted, (Function2)((Function2)new Function2<AnnotatedString, Continuation<? super Boolean>, Object>(this.$sb, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ StringBuilder $sb;
                            {
                                this.$sb = $sb;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             * Could not resolve type clashes
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        string = (AnnotatedString)this.L$0;
                                        $this$sortedBy$iv = CollectionsKt.toSet((Iterable)string.getSpanStyles());
                                        $i$f$sortedBy = false;
                                        spans = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                            public final int compare(T a, T b) {
                                                AnnotatedString.Range it = (AnnotatedString.Range)a;
                                                boolean bl = false;
                                                Comparable comparable = Integer.valueOf(it.getStart());
                                                it = (AnnotatedString.Range)b;
                                                Comparable comparable2 = comparable;
                                                bl = false;
                                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                                            }
                                        });
                                        $this$groupBy$iv = spans;
                                        $i$f$groupBy = false;
                                        var7_9 = $this$groupBy$iv;
                                        destination$iv$iv = new LinkedHashMap<K, V>();
                                        $i$f$groupByTo = false;
                                        for (T element$iv$iv : $this$groupByTo$iv$iv) {
                                            it = (AnnotatedString.Range)element$iv$iv;
                                            $i$a$-groupBy-ExportKt$emitSyntaxHighlightedCode$1$1$spansStartingAt$1 = false;
                                            key$iv$iv = Boxing.boxInt((int)it.getStart());
                                            $this$getOrPut$iv$iv$iv = destination$iv$iv;
                                            $i$f$getOrPut = false;
                                            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                                            if (value$iv$iv$iv == null) {
                                                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                                                answer$iv$iv$iv = new ArrayList<E>();
                                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                                v0 /* !! */  = answer$iv$iv$iv;
                                            } else {
                                                v0 /* !! */  = value$iv$iv$iv;
                                            }
                                            list$iv$iv = (List)v0 /* !! */ ;
                                            list$iv$iv.add(element$iv$iv);
                                        }
                                        spansStartingAt = destination$iv$iv;
                                        $this$groupBy$iv = spans;
                                        $i$f$groupBy = false;
                                        destination$iv$iv = $this$groupBy$iv;
                                        destination$iv$iv = new LinkedHashMap<K, V>();
                                        $i$f$groupByTo = false;
                                        for (T element$iv$iv : $this$groupByTo$iv$iv) {
                                            it = (AnnotatedString.Range)element$iv$iv;
                                            $i$a$-groupBy-ExportKt$emitSyntaxHighlightedCode$1$1$spansEndingAt$1 = false;
                                            key$iv$iv = Boxing.boxInt((int)it.getEnd());
                                            $this$getOrPut$iv$iv$iv = destination$iv$iv;
                                            $i$f$getOrPut = false;
                                            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                                            if (value$iv$iv$iv == null) {
                                                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                                                answer$iv$iv$iv = new ArrayList<E>();
                                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                                v1 /* !! */  = answer$iv$iv$iv;
                                            } else {
                                                v1 /* !! */  = value$iv$iv$iv;
                                            }
                                            list$iv$iv = (List)v1 /* !! */ ;
                                            list$iv$iv.add(element$iv$iv);
                                        }
                                        spansEndingAt = destination$iv$iv;
                                        v2 = (List)spansStartingAt.get(Boxing.boxInt((int)0));
                                        if (v2 == null) ** GOTO lbl-1000
                                        $this$first$iv = v2;
                                        $i$f$first = false;
                                        for (T element$iv : $this$first$iv) {
                                            it = (AnnotatedString.Range)element$iv;
                                            $i$a$-first-ExportKt$emitSyntaxHighlightedCode$1$1$wholeStyle$1 = false;
                                            if (!(it.getStart() == 0 && it.getEnd() == string.length())) continue;
                                            ** GOTO lbl72
                                        }
                                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl72:
                                        // 1 sources

                                        v2 = (AnnotatedString.Range)element$iv;
                                        if (v2 != null) {
                                            v3 = (SpanStyle)v2.getItem();
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v3 = wholeStyle = null;
                                        }
                                        if (wholeStyle != null) {
                                            this.$sb.append("<pre style=\"");
                                            this.$sb.append("color: " + ExportKt.access$toHtmlColor-8_81llA(wholeStyle.getColor-0d7_KjU()) + ";");
                                            if (!JBColor.isBright()) {
                                                this.$sb.append("background-color: " + ExportKt.access$toHtmlColor-8_81llA(wholeStyle.getBackground-0d7_KjU()) + ";");
                                            }
                                            this.$sb.append("color: " + ExportKt.access$toHtmlColor-8_81llA(wholeStyle.getColor-0d7_KjU()) + ";");
                                            this.$sb.append("<\">\n");
                                        } else {
                                            this.$sb.append("<pre>\n");
                                        }
                                        var8_12 = string.length();
                                        for (offset = 0; offset < var8_12; ++offset) {
                                            v4 = (List)spansEndingAt.get(Boxing.boxInt((int)offset));
                                            if (v4 == null) {
                                                v4 = CollectionsKt.emptyList();
                                            }
                                            spansEnding = v4;
                                            $i$f$first = spansEnding.iterator();
                                            while ($i$f$first.hasNext()) {
                                                (AnnotatedString.Range)$i$f$first.next();
                                                this.$sb.append("</span>");
                                            }
                                            v5 = (List)spansStartingAt.get(Boxing.boxInt((int)offset));
                                            if (v5 == null) {
                                                v5 = CollectionsKt.emptyList();
                                            }
                                            spansStarting = v5;
                                            for (AnnotatedString.Range span : spansStarting) {
                                                this.$sb.append("<span style=\"");
                                                style = (SpanStyle)span.getItem();
                                                color = style.getColor-0d7_KjU();
                                                v6 = wholeStyle;
                                                if (!Color.equals-impl((long)color, (Object)(v6 != null ? Color.box-impl((long)v6.getColor-0d7_KjU()) : null)) && !Color.equals-impl0((long)color, (long)style.getBackground-0d7_KjU())) {
                                                    this.$sb.append("color: " + ExportKt.access$toHtmlColor-8_81llA(color) + ";");
                                                }
                                                background = style.getBackground-0d7_KjU();
                                                v7 = wholeStyle;
                                                if (!Color.equals-impl((long)background, (Object)(v7 != null ? Color.box-impl((long)v7.getBackground-0d7_KjU()) : null))) {
                                                    this.$sb.append("background-color: " + ExportKt.access$toHtmlColor-8_81llA(background) + ";");
                                                }
                                                var18_34 = style.getFontStyle-4Lr2A7w();
                                                var19_38 = FontStyle.Companion.getItalic-_-LCdwA();
                                                v8 = var18_34;
                                                if (v8 == null ? false : FontStyle.equals-impl0((int)v8.unbox-impl(), (int)var19_38)) {
                                                    this.$sb.append("font-style: italic;");
                                                }
                                                if (style.getFontWeight() != null) {
                                                    v9 = style.getFontWeight();
                                                    Intrinsics.checkNotNull((Object)v9);
                                                    this.$sb.append("font-weight: " + v9.getWeight() + ";");
                                                }
                                                if (!TextUnit.equals-impl0((long)style.getFontSize-XSAIIZE(), (long)TextUnit.Companion.getUnspecified-XSAIIZE())) {
                                                    this.$sb.append("font-size: " + ExportKt.access$toHtmlFontSize--R2X_6o(style.getFontSize-XSAIIZE()) + ";");
                                                }
                                                if (Intrinsics.areEqual((Object)style.getTextDecoration(), (Object)TextDecoration.Companion.getUnderline())) {
                                                    this.$sb.append("text-decoration: underline;");
                                                }
                                                this.$sb.append("\">");
                                            }
                                            this.$sb.append(string.charAt(offset));
                                        }
                                        return Boxing.boxBoolean((boolean)true);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(AnnotatedString p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super AnnotatedString> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        sb.append("\n</pre>\n");
    }

    private static final void emitToolCallWithResponse(StringBuilder sb, Tool<?> tool, Map<String, ? extends Object> args, String response2) {
        String string;
        String string2;
        StringBuilder stringBuilder;
        Object object;
        StringBuilder stringBuilder2;
        sb.append("<details class=\"tool-call\">\n");
        String text2 = ExportKt.getToolDisplayText(tool, args);
        StringBuilder stringBuilder3 = sb;
        try {
            stringBuilder2 = stringBuilder3;
            object = ExportKt.createIconTag$default(ExportKt.getIconForTool(tool), "Call", null, null, null, 28, null);
        }
        catch (Throwable throwable) {
            stringBuilder2 = stringBuilder3;
            object = "";
        }
        String string3 = text2;
        String string4 = object;
        stringBuilder3 = stringBuilder2;
        try {
            stringBuilder = stringBuilder3;
            string2 = string4;
            string = string3;
            Icon icon2 = AllIcons.General.ChevronDown;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ChevronDown");
            String string5 = ExportKt.createIconTag$default(icon2, "Expand", "arrow-down", null, null, 24, null);
            Icon icon3 = AllIcons.General.ChevronUp;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"ChevronUp");
            object = string5 + ExportKt.createIconTag$default(icon3, "Collapse", "arrow-up", null, null, 24, null);
        }
        catch (Throwable throwable) {
            stringBuilder = stringBuilder3;
            string2 = string4;
            string = string3;
            object = "";
        }
        stringBuilder.append("<summary><span style=\"display: flex; align-items: center;\">" + string2 + "&nbsp;" + string + "</span><span>" + (String)object + "</span></summary>\n");
        sb.append("<div style=\"padding-top: 12px;\">\n");
        sb.append("<b>Tool Call:</b><pre><code>" + tool.getName() + "(\n");
        for (Map.Entry entry : args.entrySet()) {
            String arg = (String)entry.getKey();
            Object value = entry.getValue();
            sb.append("    " + arg + " = " + value + "\n");
        }
        sb.append(")</code></pre>\n");
        sb.append("<b>Response:</b><pre><code>" + response2 + "</code></pre>\n");
        sb.append("</div>\n");
        sb.append("</details>\n");
    }

    @NotNull
    public static final String getConversationAsText(@NotNull List<? extends SmlConversation> conversations, int lastCount, boolean markdown2) {
        int start2;
        Intrinsics.checkNotNullParameter(conversations, (String)"conversations");
        SmlConversation prev = null;
        StringBuilder sb = new StringBuilder();
        if (markdown2) {
            sb.append("# Gemini Conversation Log\n\n");
            sb.append("Saved: " + ExportKt.getTimestamp() + "\n\n");
        }
        int n = conversations.size();
        for (int i2 = start2 = ExportKt.findConversationStart(lastCount, conversations); i2 < n; ++i2) {
            String string;
            SmlConversation.CodeChunk codeChunk;
            SmlConversation conversation = conversations.get(i2);
            if (ExportKt.isUser(conversation)) {
                ExportKt.appendSeparator(sb);
                StringBuilder stringBuilder = sb.append("You:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                ExportKt.getConversationAsText$nl(stringBuilder, markdown2);
            } else if (ExportKt.isVerified(conversation) && !ExportKt.isVerified(prev)) {
                if (markdown2) {
                    sb.append("\u2713 ");
                }
                StringBuilder stringBuilder = sb.append("Verified Response:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                ExportKt.getConversationAsText$nl(stringBuilder, markdown2);
            } else if (ExportKt.isUser(prev) || ExportKt.isVerified(prev)) {
                StringBuilder stringBuilder = sb.append("Gemini:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                ExportKt.getConversationAsText$nl(stringBuilder, markdown2);
            }
            SmlConversation.CodeChunk codeChunk2 = codeChunk = conversation instanceof SmlConversation.CodeChunk ? (SmlConversation.CodeChunk)conversation : null;
            if (markdown2 && codeChunk != null) {
                String language2;
                sb.append("```");
                String text2 = codeChunk.getText();
                SmlConversation smlConversation = prev;
                SmlConversation.CodeChunk codeChunk3 = smlConversation instanceof SmlConversation.CodeChunk ? (SmlConversation.CodeChunk)smlConversation : null;
                String string2 = codeChunk3 != null ? codeChunk3.getText() : null;
                String string3 = codeChunk.getLanguage-_TXXkdE();
                if (string3 == null) {
                    string3 = new LanguageRecognizer().recognize-iHvyU2E(text2, string2);
                }
                if ((language2 = string3) != null) {
                    String string4 = MimeTypeUtilsKt.displayName-qru2Y28(language2).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    sb.append(string4);
                }
                sb.append("\n");
            } else if (conversation instanceof SmlConversation.ToolCallWithResponseChunk) {
                sb.append("    " + ExportKt.getToolDisplayText(((SmlConversation.ToolCallWithResponseChunk)conversation).getTool(), ((SmlConversation.ToolCallWithResponseChunk)conversation).getArgs()) + "(");
                if (!((SmlConversation.ToolCallWithResponseChunk)conversation).getArgs().isEmpty()) {
                    sb.append("\n");
                    for (Map.Entry entry : ((SmlConversation.ToolCallWithResponseChunk)conversation).getArgs().entrySet()) {
                        String arg = (String)entry.getKey();
                        Object value = entry.getValue();
                        sb.append("        " + arg + ": " + ExportKt.toTruncatedString(value) + "\n");
                    }
                    sb.append("    ");
                }
                sb.append(")\n");
                sb.append("    Response: " + ExportKt.toTruncatedString(((SmlConversation.ToolCallWithResponseChunk)conversation).getResponse()) + "\n");
            }
            if ((string = ExportKt.getTextOrNull(conversation)) == null) {
                string = "";
            }
            String text2 = string;
            for (String line : StringsKt.lines((CharSequence)text2)) {
                int indent = markdown2 ? 0 : (ExportKt.isCode(conversation) ? 4 : 2);
                for (int column = 0; column < indent; ++column) {
                    sb.append(' ');
                }
                sb.append(line).append('\n');
            }
            if (markdown2 && codeChunk != null) {
                sb.append("```\n");
            }
            if (ExportKt.isUser(conversation)) {
                ExportKt.appendSeparator(sb);
            } else if (ExportKt.isVerified(conversation)) {
                ExportKt.getConversationAsText$nl(sb, markdown2);
            }
            prev = conversation;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String toTruncatedString(Object $this$toTruncatedString) {
        CharSequence charSequence = StringsKt.replace$default((String)String.valueOf($this$toTruncatedString), (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
        Regex regex = new Regex("\\s+");
        String string = " ";
        String it = regex.replace(charSequence, string) + "\"";
        boolean bl = false;
        return "\"" + (it.length() > 50 ? StringsKt.take((String)it, (int)47) + "..." : it);
    }

    private static final String getTimestamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss")) + " on " + LocalDate.now().format(DateTimeFormatter.ofPattern("EEEE, MMMM d, yyyy"));
    }

    private static final String toHtmlColor-8_81llA(long $this$toHtmlColor_u2d8_81llA) {
        String string = ColorUtil.toHtmlColor((java.awt.Color)new java.awt.Color(Color.getRed-impl((long)$this$toHtmlColor_u2d8_81llA), Color.getGreen-impl((long)$this$toHtmlColor_u2d8_81llA), Color.getBlue-impl((long)$this$toHtmlColor_u2d8_81llA), Color.getAlpha-impl((long)$this$toHtmlColor_u2d8_81llA)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        return string;
    }

    private static final <Args> String getToolDisplayText(Tool<Args> tool, Object args) {
        Object object;
        try {
            Intrinsics.checkNotNull((Object)args, (String)"null cannot be cast to non-null type Args of com.android.studio.ml.bot.commands.ExportKt.getToolDisplayText");
            object = tool.getRunningDisplayText(args);
        }
        catch (Throwable throwable) {
            object = "Agent called tool: " + tool.getName();
        }
        return object;
    }

    private static final Icon getIconForTool(Tool<?> tool) {
        Icon icon2;
        Tool<?> tool2 = tool;
        if (tool2 instanceof ReadFileTool) {
            Icon icon3 = AllIcons.Actions.Preview;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Preview");
        } else if (tool2 instanceof ReadUrlTool) {
            Icon icon4 = AllIcons.General.Web;
            icon2 = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Web");
        } else if (tool2 instanceof WriteFileTool ? true : tool2 instanceof ReplaceTextTool) {
            Icon icon5 = AllIcons.Actions.Edit;
            icon2 = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Edit");
        } else if (((((tool2 instanceof FindFilesTool ? true : tool2 instanceof GrepTool) ? true : tool2 instanceof ListFilesTool) ? true : tool2 instanceof ResolveSymbolTool) ? true : tool2 instanceof FindUsagesTool) ? true : tool2 instanceof ListDeclarationsInDirectoryTool) {
            Icon icon6 = AllIcons.Actions.Search;
            icon2 = icon6;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Search");
        } else if (tool2 instanceof AnalyzeCurrentFileTool) {
            Icon icon7 = AllIcons.Actions.DependencyAnalyzer;
            icon2 = icon7;
            Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"DependencyAnalyzer");
        } else if (tool2 instanceof GitTool ? true : tool2 instanceof ListVcsRootsTool) {
            Icon icon8 = AllIcons.Vcs.Branch;
            icon2 = icon8;
            Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"Branch");
        } else {
            Icon icon9 = AllIcons.Actions.Compile;
            icon2 = icon9;
            Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"Compile");
        }
        return icon2;
    }

    private static final String toHtmlFontSize--R2X_6o(long $this$toHtmlFontSize_u2d_u2dR2X_6o) {
        return TextUnit.getValue-impl((long)$this$toHtmlFontSize_u2d_u2dR2X_6o) + (TextUnit.isEm-impl((long)$this$toHtmlFontSize_u2d_u2dR2X_6o) ? "em" : (TextUnit.isSp-impl((long)$this$toHtmlFontSize_u2d_u2dR2X_6o) ? "sp" : "px"));
    }

    private static final String markdownToHtml(String markdown2) {
        Parser parser = Parser.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"build(...)");
        Parser parser2 = parser;
        HtmlRenderer htmlRenderer = HtmlRenderer.builder().escapeHtml(true).build();
        Node document2 = parser2.parse(markdown2);
        String render2 = htmlRenderer.render(document2);
        Intrinsics.checkNotNull((Object)render2);
        return StringsKt.removePrefix((String)StringsKt.removeSuffix((String)render2, (CharSequence)"</p>\n"), (CharSequence)"<p>");
    }

    private static final int findConversationStart(int lastCount, List<? extends SmlConversation> conversations) {
        int start2 = 0;
        if (lastCount < Integer.MAX_VALUE) {
            int count = 0;
            for (int i2 = conversations.size() - 1; -1 < i2; --i2) {
                if (!ExportKt.isUser(conversations.get(i2)) || ++count != lastCount) continue;
                start2 = i2;
                break;
            }
        } else {
            int n = conversations.size();
            for (int i3 = start2 = Math.max(0, conversations.size() - lastCount); i3 < n; ++i3) {
                if (!ExportKt.isUser(conversations.get(i3))) continue;
                start2 = i3;
                break;
            }
        }
        return start2;
    }

    private static final boolean isUser(SmlConversation $this$isUser) {
        return $this$isUser instanceof SmlConversation.Request;
    }

    private static final boolean isCode(SmlConversation $this$isCode) {
        return $this$isCode instanceof SmlConversation.CodeChunk;
    }

    private static final boolean isVerified(SmlConversation $this$isVerified) {
        return $this$isVerified instanceof SmlConversation.TextChunk && ((SmlConversation.TextChunk)$this$isVerified).getVerified();
    }

    private static final void appendSeparator(StringBuilder $this$appendSeparator) {
        $this$appendSeparator.append(StringsKt.repeat((CharSequence)"-", (int)80)).append('\n');
    }

    private static final String getTextOrNull(SmlConversation $this$textOrNull) {
        Object object = $this$textOrNull instanceof SmlConversation.ResponseChunk ? (SmlConversation.ResponseChunk)$this$textOrNull : null;
        if (object == null || (object = object.getText()) == null) {
            SmlConversation.Request request2 = $this$textOrNull instanceof SmlConversation.Request ? (SmlConversation.Request)$this$textOrNull : null;
            object = request2 != null ? request2.getText() : null;
        }
        return object;
    }

    private static final String createAvatarIcon(Icon icon2, String alt) {
        return ExportKt.createIconTag$default(icon2, alt, "avatar", null, null, 24, null);
    }

    private static final String createIconTag(Icon icon2, String alt, String cssClass, Integer width, Integer height) {
        StringBuilder stringBuilder;
        BufferedImage bufferedImage = new BufferedImage(icon2.getIconWidth(), icon2.getIconHeight(), 2);
        icon2.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        String base64 = Base64.getEncoder().encodeToString(bytes);
        StringBuilder $this$createIconTag_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createIconTag_u24lambda_u242.append("<img src=\"data:image/png;base64," + base64 + "\" alt=\"" + alt + "\"");
        if (cssClass != null) {
            $this$createIconTag_u24lambda_u242.append(" class=\"" + cssClass + "\"");
        }
        if (width != null) {
            $this$createIconTag_u24lambda_u242.append(" width=\"" + width + "\"");
        }
        if (height != null) {
            $this$createIconTag_u24lambda_u242.append(" height=\"" + height + "\"");
        }
        $this$createIconTag_u24lambda_u242.append("/>");
        return stringBuilder.toString();
    }

    static /* synthetic */ String createIconTag$default(Icon icon2, String string, String string2, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string2 = null;
        }
        if ((n3 & 8) != 0) {
            n = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        return ExportKt.createIconTag(icon2, string, string2, n, n2);
    }

    private static final void getConversationAsText$nl(StringBuilder $this$getConversationAsText_u24nl, boolean $markdown) {
        if ($markdown) {
            $this$getConversationAsText_u24nl.append("  ");
        }
        $this$getConversationAsText_u24nl.append("\n");
    }

    public static final /* synthetic */ String access$toHtmlColor-8_81llA(long $receiver) {
        return ExportKt.toHtmlColor-8_81llA($receiver);
    }

    public static final /* synthetic */ String access$toHtmlFontSize--R2X_6o(long $receiver) {
        return ExportKt.toHtmlFontSize--R2X_6o($receiver);
    }
}

