/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.commands;

import com.android.studio.ml.bot.commands.ToolOutputOptions;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0007\u001a \u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002\u001a$\u0010\f\u001a\u00020\r*\u00060\u000ej\u0002`\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0012\u001a\u00020\u0003\u001a>\u0010\u0013\u001a\u00020\r*\u00060\u000ej\u0002`\u000f2\u001a\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00150\t2\u0006\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\u0003H\u0002\u00a8\u0006\u0018"}, d2={"getOutputFile", "Ljava/nio/file/Path;", "userPath", "", "defaultNamePrefix", "extension", "parseToolOutputOptions", "Lcom/android/studio/ml/bot/commands/ToolOutputOptions;", "arguments", "", "supportSchema", "", "appendWithHighlights", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "filters", "Lkotlin/text/Regex;", "s", "describeTools", "namesAndDescriptions", "Lkotlin/Pair;", "options", "indent", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nBotCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotCommands.kt\ncom/android/studio/ml/bot/commands/BotCommandsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1063:1\n1563#2:1064\n1634#2,3:1065\n1056#2:1068\n1563#2:1069\n1634#2,3:1070\n*S KotlinDebug\n*F\n+ 1 BotCommands.kt\ncom/android/studio/ml/bot/commands/BotCommandsKt\n*L\n913#1:1064\n913#1:1065,3\n913#1:1068\n917#1:1069\n917#1:1070,3\n*E\n"})
public final class BotCommandsKt {
    @VisibleForTesting
    @NotNull
    public static final Path getOutputFile(@Nullable String userPath, @NotNull String defaultNamePrefix, @NotNull String extension) {
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)defaultNamePrefix, (String)"defaultNamePrefix");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String string = userPath;
        if (string == null) {
            string = "";
        }
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = path2;
        if (!path3.isAbsolute()) {
            String string2 = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            object3 = string2;
            object2 = new String[]{"Desktop", ((Object)path3).toString()};
            Path path4 = Paths.get((String)object3, Arrays.copyOf(object2, ((String[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
            path3 = path4;
        }
        if (!Files.isWritable(path3)) {
            Path path5 = path3.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"getParent(...)");
            if (!Files.isWritable(path5)) {
                String tmpDir = System.getProperty("java.io.tmpdir");
                new File(tmpDir).mkdirs();
                Intrinsics.checkNotNull((Object)tmpDir);
                object2 = tmpDir;
                String[] stringArray = new String[]{((Object)path3.getFileName()).toString()};
                Path path6 = Paths.get((String)object2, Arrays.copyOf(stringArray, stringArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"get(...)");
                path3 = path6;
            }
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path path7 = path3.resolve(defaultNamePrefix + extension);
            for (int i2 = 1; i2 < 100; ++i2) {
                Path path8 = path7;
                Intrinsics.checkNotNull((Object)path8);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.notExists(path8, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break;
                path7 = path3.resolve(defaultNamePrefix + i2 + extension);
            }
            object3 = path7;
            Intrinsics.checkNotNull((Object)object3);
            object = object3;
        } else if (StringsKt.isBlank((CharSequence)PathsKt.getExtension((Path)path3))) {
            Path path9 = Paths.get(path3 + extension, new String[0]);
            object = path9;
            Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"get(...)");
        } else {
            object = path3;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendWithHighlights(@NotNull StringBuilder $this$appendWithHighlights, @NotNull List<Regex> filters, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)$this$appendWithHighlights, (String)"<this>");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (filters.isEmpty()) {
            $this$appendWithHighlights.append(s);
        } else {
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = filters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Regex regex = (Regex)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SequencesKt.toList((Sequence)Regex.findAll$default((Regex)it, (CharSequence)s, (int)0, (int)2, null)));
            }
            Iterable $this$sortedBy$iv = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
            boolean $i$f$sortedBy = false;
            List matches = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    MatchResult it = (MatchResult)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRange().getFirst());
                    it = (MatchResult)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRange().getFirst()));
                }
            });
            if (matches.isEmpty()) {
                $this$appendWithHighlights.append(s);
            } else {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = matches;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    MatchResult bl = (MatchResult)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getRange());
                }
                List matchRanges = (List)destination$iv$iv2;
                List mergedRanges = new ArrayList();
                if (!((Collection)matchRanges).isEmpty()) {
                    IntRange currentRange = (IntRange)CollectionsKt.first((List)matchRanges);
                    int n = matchRanges.size();
                    for (int i2 = 1; i2 < n; ++i2) {
                        IntRange nextRange = (IntRange)matchRanges.get(i2);
                        if (nextRange.getFirst() <= currentRange.getLast() + 1) {
                            currentRange = new IntRange(currentRange.getFirst(), Math.max(currentRange.getLast(), nextRange.getLast()));
                            continue;
                        }
                        mergedRanges.add(currentRange);
                        currentRange = nextRange;
                    }
                    mergedRanges.add(currentRange);
                }
                boolean inQuote = false;
                int lastIndex = 0;
                for (IntRange range : mergedRanges) {
                    int i3 = lastIndex;
                    while (i3 < range.getFirst()) {
                        char c;
                        if ((c = s.charAt(i3++)) == '\\' && i3 < range.getFirst()) {
                            $this$appendWithHighlights.append("\\");
                            $this$appendWithHighlights.append(s.charAt(i3++));
                            continue;
                        }
                        if (c == '`') {
                            inQuote = !inQuote;
                        }
                        $this$appendWithHighlights.append(c);
                    }
                    if (inQuote) {
                        if (StringsKt.endsWith$default((CharSequence)$this$appendWithHighlights, (CharSequence)"`", (boolean)false, (int)2, null)) {
                            $this$appendWithHighlights.setLength($this$appendWithHighlights.length() - 1);
                        } else {
                            $this$appendWithHighlights.append("`");
                        }
                    }
                    $this$appendWithHighlights.append("**");
                    $this$appendWithHighlights.append(s, range.getFirst(), range.getLast() + 1);
                    $this$appendWithHighlights.append("**");
                    if (inQuote) {
                        if (s.charAt(range.getLast() + 1) == '`') {
                            lastIndex = range.getLast() + 2;
                            continue;
                        }
                        $this$appendWithHighlights.append("`");
                    }
                    lastIndex = range.getLast() + 1;
                }
                if (lastIndex < s.length()) {
                    $this$appendWithHighlights.append(s, lastIndex, s.length());
                }
            }
        }
    }

    private static final void describeTools(StringBuilder $this$describeTools, List<Pair<String, String>> namesAndDescriptions, ToolOutputOptions options, String indent) {
        for (Pair<String, String> pair : namesAndDescriptions) {
            String toolName = (String)pair.component1();
            String toolDescription = (String)pair.component2();
            if (options.getNoDescriptions() || toolDescription == null && !options.getFullDescriptions()) {
                BotCommandsKt.describeTools$appendWithHighlights($this$describeTools, options, indent + "* `" + toolName + "`\n");
                continue;
            }
            if (options.getFullDescriptions()) {
                BotCommandsKt.describeTools$appendWithHighlights($this$describeTools, options, "### `" + toolName + "`\n");
                if (toolDescription != null) {
                    BotCommandsKt.describeTools$appendWithHighlights($this$describeTools, options, StringsKt.trimIndent((String)toolDescription));
                    $this$describeTools.append("\n");
                }
                $this$describeTools.append("\n");
                continue;
            }
            String string = toolDescription;
            Intrinsics.checkNotNull((Object)string);
            String summary = StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)string, (String)".", null, (int)2, null), (String)"\n", null, (int)2, null);
            BotCommandsKt.describeTools$appendWithHighlights($this$describeTools, options, indent + "* `" + toolName + "`: ");
            BotCommandsKt.describeTools$appendWithHighlights($this$describeTools, options, summary);
            $this$describeTools.append("\n");
        }
    }

    static /* synthetic */ void describeTools$default(StringBuilder stringBuilder, List list, ToolOutputOptions toolOutputOptions, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        BotCommandsKt.describeTools(stringBuilder, list, toolOutputOptions, string);
    }

    private static final ToolOutputOptions parseToolOutputOptions(List<String> arguments, boolean supportSchema) {
        boolean fullDescriptions = false;
        boolean noDescriptions = false;
        boolean includeSchema = false;
        List filters = new ArrayList();
        block14: for (String argument : arguments) {
            Regex regex;
            block20: {
                if (!filters.isEmpty()) break block20;
                switch (argument) {
                    case "nodesc": 
                    case "nodescriptions": {
                        noDescriptions = true;
                        continue block14;
                    }
                    case "descriptions": 
                    case "desc": {
                        fullDescriptions = true;
                        continue block14;
                    }
                    case "schema": {
                        if (!supportSchema) break;
                        includeSchema = true;
                        continue block14;
                    }
                }
            }
            try {
                regex = new Regex(argument, RegexOption.IGNORE_CASE);
            }
            catch (Throwable throwable) {
                regex = new Regex(Regex.Companion.escape(argument), RegexOption.IGNORE_CASE);
            }
            Regex regex2 = regex;
            filters.add(regex2);
        }
        return new ToolOutputOptions(fullDescriptions, noDescriptions, includeSchema, filters);
    }

    static /* synthetic */ ToolOutputOptions parseToolOutputOptions$default(List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return BotCommandsKt.parseToolOutputOptions(list, bl);
    }

    private static final void describeTools$appendWithHighlights(StringBuilder $this$describeTools_u24appendWithHighlights, ToolOutputOptions $options, String s) {
        BotCommandsKt.appendWithHighlights($this$describeTools_u24appendWithHighlights, $options.getFilters(), s);
    }

    public static final /* synthetic */ ToolOutputOptions access$parseToolOutputOptions(List arguments, boolean supportSchema) {
        return BotCommandsKt.parseToolOutputOptions(arguments, supportSchema);
    }

    public static final /* synthetic */ void access$describeTools(StringBuilder $receiver, List namesAndDescriptions, ToolOutputOptions options, String indent) {
        BotCommandsKt.describeTools($receiver, namesAndDescriptions, options, indent);
    }
}

