/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ:\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/bot/AdtUiImageUtils;", "", "()V", "readImageAtScale", "Ljava/awt/image/BufferedImage;", "inputStream", "Ljava/io/InputStream;", "dimension", "Ljava/awt/Dimension;", "onlyDownscale", "", "scale", "source", "xScale", "", "yScale", "rightMargin", "", "bottomMargin", "clip", "Ljava/awt/Shape;", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
public final class AdtUiImageUtils {
    @NotNull
    public static final AdtUiImageUtils INSTANCE = new AdtUiImageUtils();
    public static final int $stable;

    private AdtUiImageUtils() {
    }

    @Nullable
    public final BufferedImage readImageAtScale(@NotNull InputStream inputStream, @NotNull Dimension dimension, boolean onlyDownscale) {
        double scale;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        ImageInputStream imageStream = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> readerIterator = ImageIO.getImageReaders(imageStream);
        if (!readerIterator.hasNext()) {
            return null;
        }
        ImageReader reader = readerIterator.next();
        reader.setInput(imageStream);
        ImageReadParam readParams = reader.getDefaultReadParam();
        double srcW = reader.getWidth(0);
        double srcH = reader.getHeight(0);
        double d = scale = srcW > srcH ? (double)dimension.width / srcW : (double)dimension.height / srcH;
        if (onlyDownscale) {
            scale = RangesKt.coerceAtMost((double)scale, (double)1.0);
        }
        if (scale < 0.5) {
            double xStep = Math.floor(1.0 / (scale *= 2.0));
            double yStep = Math.floor(1.0 / scale);
            readParams.setSourceSubsampling((int)xStep, (int)yStep, 0, 0);
        }
        BufferedImage intermediateImage = reader.read(0, readParams);
        imageStream.close();
        inputStream.close();
        double d2 = scale = srcW > srcH ? (double)dimension.width / (double)intermediateImage.getWidth() : (double)dimension.height / (double)intermediateImage.getHeight();
        if (scale >= 1.0 && onlyDownscale) {
            return intermediateImage;
        }
        Intrinsics.checkNotNull((Object)intermediateImage);
        return this.scale(intermediateImage, scale, scale, 0, 0, null);
    }

    public static /* synthetic */ BufferedImage readImageAtScale$default(AdtUiImageUtils adtUiImageUtils, InputStream inputStream, Dimension dimension, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return adtUiImageUtils.readImageAtScale(inputStream, dimension, bl);
    }

    private final BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin, Shape clip) {
        BufferedImage source2 = source;
        int sourceWidth = source2.getWidth();
        int sourceHeight = source2.getHeight();
        int destWidth = (int)Math.max(1.0, (double)((int)(xScale * (double)sourceWidth)));
        int destHeight = (int)Math.max(1.0, (double)((int)(yScale * (double)sourceHeight)));
        int imageType = source2.getType();
        switch (imageType) {
            case 0: 
            case 12: 
            case 13: {
                imageType = 2;
            }
        }
        if (xScale > 0.5 && yScale > 0.5) {
            BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
            Graphics2D g2 = scaled.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setColor(new Color(0, true));
            g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
            if (clip != null) {
                g2.setClip(clip);
            }
            if (xScale == 1.0 && yScale == 1.0) {
                g2.drawImage((Image)source2, 0, 0, null);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage(source2, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
            }
            g2.dispose();
            return scaled;
        }
        int iterations = 0;
        int nearestWidth = destWidth;
        int nearestHeight = destHeight;
        while (nearestWidth < sourceWidth / 2) {
            nearestWidth *= 2;
            nearestHeight *= 2;
            ++iterations;
        }
        if (iterations == 0) {
            nearestWidth += rightMargin;
            nearestHeight += bottomMargin;
        }
        BufferedImage scaled = new BufferedImage(nearestWidth, nearestHeight, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(source2, 0, 0, nearestWidth, nearestHeight, 0, 0, sourceWidth, sourceHeight, null);
        g2.dispose();
        sourceWidth = nearestWidth;
        sourceHeight = nearestHeight;
        source2 = scaled;
        for (int iteration = iterations - 1; -1 < iteration; --iteration) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            if (iteration == 0) {
                scaled = new BufferedImage(halfWidth + rightMargin, halfHeight + bottomMargin, imageType);
                g2 = scaled.createGraphics();
                if (clip != null) {
                    g2.setClip(clip);
                }
            } else {
                scaled = new BufferedImage(halfWidth, halfHeight, imageType);
                g2 = scaled.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(source2, 0, 0, halfWidth, halfHeight, 0, 0, sourceWidth, sourceHeight, null);
            g2.dispose();
            sourceWidth = halfWidth;
            sourceHeight = halfHeight;
            source2 = scaled;
            --iterations;
        }
        return scaled;
    }
}

