/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.backends.openai;

import com.android.tools.idea.studiobot.prompts.Prompt;
import com.google.gson.Gson;
import com.openai.core.JsonArray;
import com.openai.core.JsonBoolean;
import com.openai.core.JsonField;
import com.openai.core.JsonMissing;
import com.openai.core.JsonNull;
import com.openai.core.JsonNumber;
import com.openai.core.JsonObject;
import com.openai.core.JsonString;
import com.openai.core.JsonValue;
import com.openai.models.FunctionDefinition;
import com.openai.models.FunctionParameters;
import com.openai.models.chat.completions.ChatCompletionFunctionTool;
import com.openai.models.chat.completions.ChatCompletionTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u000e\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"convertJsonValue", "", "value", "Lcom/openai/core/JsonValue;", "toOpenAiTool", "Lcom/openai/models/chat/completions/ChatCompletionTool;", "function", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Function;", "addSchema", "", "forceRequireAllParameters", "addToolParametersEvenIfEmpty", "propertyDescriptor", "", "", "type", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionParameterType;", "description", "sanitizeMultilineString", "rawArguments", "gson", "Lcom/google/gson/Gson;", "aiplugin.backends.third-party"})
@SourceDebugExtension(value={"SMAP\nOpenAITools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAITools.kt\ncom/android/studio/ml/backends/openai/OpenAIToolsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,153:1\n1563#2:154\n1634#2,3:155\n1252#2,4:162\n216#3,2:158\n463#4:160\n413#4:161\n*S KotlinDebug\n*F\n+ 1 OpenAITools.kt\ncom/android/studio/ml/backends/openai/OpenAIToolsKt\n*L\n42#1:154\n42#1:155,3\n115#1:162,4\n46#1:158,2\n115#1:160\n115#1:161\n*E\n"})
public final class OpenAIToolsKt {
    /*
     * WARNING - void declaration
     */
    private static final Object convertJsonValue(JsonValue value) {
        JsonValue jsonValue = value;
        if (jsonValue instanceof JsonMissing || jsonValue instanceof JsonNull) {
            return null;
        }
        if (jsonValue instanceof JsonBoolean) {
            return value.asBoolean().get();
        }
        if (jsonValue instanceof JsonNumber) {
            return value.asNumber().get();
        }
        if (jsonValue instanceof JsonString) {
            return value.asString().get();
        }
        if (jsonValue instanceof JsonArray) {
            void $this$mapTo$iv$iv;
            Object t = value.asArray().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Iterable $this$map$iv = (Iterable)t;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonValue jsonValue2 = (JsonValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(OpenAIToolsKt.convertJsonValue((JsonValue)it));
            }
            return (List)destination$iv$iv;
        }
        if (jsonValue instanceof JsonObject) {
            Map result2 = new LinkedHashMap();
            Object t = value.asObject().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Map $this$forEach$iv = (Map)t;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                JsonValue value2 = (JsonValue)entry.getValue();
                result2.put(key, OpenAIToolsKt.convertJsonValue(value2));
            }
            return result2;
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final ChatCompletionTool toOpenAiTool(@NotNull Prompt.Function function, boolean addSchema, boolean forceRequireAllParameters, boolean addToolParametersEvenIfEmpty) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        FunctionDefinition.Builder openAiFunction = FunctionDefinition.Companion.builder().name(function.getName()).description(function.getDescription()).strict(true);
        if (!((Collection)function.getParameters()).isEmpty()) {
            FunctionParameters.Builder toolParameters = FunctionParameters.Companion.builder();
            if (addSchema) {
                toolParameters.putAdditionalProperty("$schema", JsonValue.Companion.from((Object)"https://json-schema.org/draft/2020-12/schema"));
            }
            List requiredProperties = new ArrayList();
            Map properties = new LinkedHashMap();
            for (Prompt.FunctionParameter p : function.getParameters()) {
                if (p.getRequired() || forceRequireAllParameters) {
                    requiredProperties.add(p.getName());
                }
                properties.put(p.getName(), OpenAIToolsKt.propertyDescriptor(p.getType(), p.getDescription()));
            }
            toolParameters.putAdditionalProperty("type", JsonValue.Companion.from((Object)"object")).putAdditionalProperty("properties", JsonValue.Companion.from((Object)properties)).putAdditionalProperty("required", JsonValue.Companion.from((Object)requiredProperties)).putAdditionalProperty("additionalProperties", JsonValue.Companion.from((Object)false));
            openAiFunction.parameters((JsonField)JsonValue.Companion.from((Object)toolParameters.build()));
        } else if (addToolParametersEvenIfEmpty) {
            FunctionParameters.Builder toolParameters = FunctionParameters.Companion.builder();
            toolParameters.putAdditionalProperty("type", JsonValue.Companion.from((Object)"object")).putAdditionalProperty("properties", JsonValue.Companion.from((Object)MapsKt.emptyMap())).putAdditionalProperty("additionalProperties", JsonValue.Companion.from((Object)false));
            openAiFunction.parameters((JsonField)JsonValue.Companion.from((Object)toolParameters.build()));
        }
        return ChatCompletionTool.Companion.ofFunction(ChatCompletionFunctionTool.Companion.builder().function(openAiFunction.build()).build());
    }

    public static /* synthetic */ ChatCompletionTool toOpenAiTool$default(Prompt.Function function, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return OpenAIToolsKt.toOpenAiTool(function, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Object> propertyDescriptor(@NotNull Prompt.FunctionParameterType type2, @NotNull String description) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Prompt.FunctionParameterType functionParameterType = type2;
        if (Intrinsics.areEqual((Object)functionParameterType, (Object)Prompt.FunctionParameterType.Boolean.INSTANCE) || Intrinsics.areEqual((Object)functionParameterType, (Object)Prompt.FunctionParameterType.Integer.INSTANCE) || Intrinsics.areEqual((Object)functionParameterType, (Object)Prompt.FunctionParameterType.Number.INSTANCE) || Intrinsics.areEqual((Object)functionParameterType, (Object)Prompt.FunctionParameterType.String.INSTANCE)) {
            void var3_5;
            Object object = new Pair[]{TuplesKt.to((Object)"type", (Object)type2.getName())};
            Map descriptor = MapsKt.mutableMapOf((Pair[])object);
            if (((CharSequence)description).length() > 0) {
                object = descriptor;
                Pair pair = TuplesKt.to((Object)"description", (Object)description);
                object.put(pair.getFirst(), pair.getSecond());
            }
            map2 = var3_5;
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.Enum) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)((Prompt.FunctionParameterType.Enum)type2).getEnumType().getName()), TuplesKt.to((Object)"enum", (Object)JsonValue.Companion.from(((Prompt.FunctionParameterType.Enum)type2).getValues()))};
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.List) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)JsonValue.Companion.from((Object)"array")), TuplesKt.to((Object)"items", (Object)OpenAIToolsKt.propertyDescriptor$default(((Prompt.FunctionParameterType.List)type2).getElementType(), null, 2, null))};
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.Object) {
            Map map3;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Pair[] pairArray = new Pair[4];
            pairArray[0] = TuplesKt.to((Object)"type", (Object)"object");
            Map<String, Prompt.FunctionParameterType> map4 = ((Prompt.FunctionParameterType.Object)type2).getFields();
            JsonValue.Companion companion = JsonValue.Companion;
            String string = "properties";
            int n = 1;
            Pair[] pairArray2 = pairArray;
            boolean $i$f$mapValues = false;
            void var6_15 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map5 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map3 = map5;
                boolean bl2 = false;
                Map map6 = OpenAIToolsKt.propertyDescriptor$default((Prompt.FunctionParameterType)it.getValue(), null, 2, null);
                map3.put(k, map6);
            }
            map3 = destination$iv$iv;
            pairArray2[n] = TuplesKt.to((Object)string, (Object)companion.from((Object)map3));
            pairArray[2] = TuplesKt.to((Object)"required", (Object)JsonValue.Companion.from(((Prompt.FunctionParameterType.Object)type2).getRequiredFields()));
            pairArray[3] = TuplesKt.to((Object)"additionalProperties", (Object)JsonValue.Companion.from((Object)false));
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map2;
    }

    public static /* synthetic */ Map propertyDescriptor$default(Prompt.FunctionParameterType functionParameterType, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return OpenAIToolsKt.propertyDescriptor(functionParameterType, string);
    }

    @Nullable
    public static final String sanitizeMultilineString(@NotNull String rawArguments, @NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)rawArguments, (String)"rawArguments");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        Regex startRegex = new Regex("\"\\s*:\\s*(\"\"\")");
        Regex endRegex = new Regex("(\"\"\")\\s*}");
        Object result2 = null;
        while (true) {
            String after;
            String before;
            IntRange endIndex;
            IntRange startIndex;
            String currentArgs;
            MatchResult matchResult;
            String string;
            if ((string = result2) == null) {
                string = rawArguments;
            }
            IntRange intRange = (matchResult = Regex.find$default((Regex)startRegex, (CharSequence)(currentArgs = string), (int)0, (int)2, null)) != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getRange() : (startIndex = null);
            if (startIndex == null) {
                return result2;
            }
            MatchResult matchResult2 = endRegex.find((CharSequence)currentArgs, startIndex.getLast());
            IntRange intRange2 = matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null && (matchResult2 = matchResult2.get(1)) != null ? matchResult2.getRange() : (endIndex = null);
            if (endIndex == null || endIndex.getFirst() < startIndex.getLast()) {
                return result2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)currentArgs.substring(0, startIndex.getFirst()), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)currentArgs.substring(endIndex.getLast() + 1), (String)"substring(...)");
            String string2 = currentArgs.substring(startIndex.getLast() + 1, endIndex.getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String multilineValue = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            result2 = before + gson.toJson((Object)multilineValue) + after;
        }
    }
}

