/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.agentsmd;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"getRelativePath", "", "basePath", "absolutePath", "getContentRootForFile", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDirectoryPath", "aiplugin.core.aicore"})
public final class PathUtilsKt {
    @VisibleForTesting
    @Nullable
    public static final String getRelativePath(@NotNull String basePath2, @NotNull String absolutePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)basePath2, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        Path absolute = Paths.get(absolutePath, new String[0]);
        Path base = Paths.get(basePath2, new String[0]);
        try {
            string = ((Object)base.relativize(absolute)).toString();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }

    @VisibleForTesting
    @Nullable
    public static final String getContentRootForFile(@NotNull Project $this$getContentRootForFile, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$getContentRootForFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile2 = ProjectFileIndex.getInstance((Project)$this$getContentRootForFile).getContentRootForFile(file);
        return virtualFile2 != null ? virtualFile2.getPath() : null;
    }

    @VisibleForTesting
    @NotNull
    public static final String getDirectoryPath(@NotNull VirtualFile $this$getDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectoryPath, (String)"<this>");
        if ($this$getDirectoryPath.isDirectory()) {
            String string = $this$getDirectoryPath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }
        VirtualFile virtualFile2 = $this$getDirectoryPath.getParent();
        String string = virtualFile2 != null ? virtualFile2.getPath() : null;
        if (string == null) {
            String string2 = $this$getDirectoryPath.getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        }
        return string;
    }
}

