/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.Handler;

public class ClassPathURLStreamHandler
extends Handler {
    private final String fileUri;
    private final JarFile jarFile;

    public ClassPathURLStreamHandler(String jarFileName) throws IOException {
        this(jarFileName, true);
    }

    public ClassPathURLStreamHandler(String jarFileName, boolean enableZipPathValidator) throws IOException {
        this.jarFile = new JarFile(jarFileName, enableZipPathValidator, true);
        this.fileUri = new File(jarFileName).toURI().toString();
    }

    public URL getEntryUrlOrNull(String entryName) {
        if (this.jarFile.getEntry(entryName) != null) {
            try {
                String encodedName = ParseUtil.encodePath(entryName, false);
                return new URL("jar", null, -1, this.fileUri + "!/" + encodedName, this);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid entry name", e);
            }
        }
        return null;
    }

    public boolean isEntryStored(String entryName) {
        ZipEntry entry = this.jarFile.getEntry(entryName);
        return entry != null && entry.getMethod() == 0;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new ClassPathURLConnection(url);
    }

    public void close() throws IOException {
        this.jarFile.close();
    }

    private class ClassPathURLConnection
    extends JarURLConnection {
        private JarFile connectionJarFile;
        private ZipEntry jarEntry;
        private InputStream jarInput;
        private boolean closed;
        private boolean useCachedJarFile;

        public ClassPathURLConnection(URL url) throws MalformedURLException {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                this.jarEntry = ClassPathURLStreamHandler.this.jarFile.getEntry(this.getEntryName());
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("URL does not correspond to an entry in the zip file. URL=" + this.url + ", zipfile=" + ClassPathURLStreamHandler.this.jarFile.getName());
                }
                this.useCachedJarFile = this.getUseCaches();
                this.connected = true;
            }
        }

        @Override
        public JarFile getJarFile() throws IOException {
            this.connect();
            this.connectionJarFile = this.useCachedJarFile ? ClassPathURLStreamHandler.this.jarFile : new JarFile(ClassPathURLStreamHandler.this.jarFile.getName());
            return this.connectionJarFile;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("JarURLConnection InputStream has been closed");
            }
            this.connect();
            if (this.jarInput != null) {
                return this.jarInput;
            }
            this.jarInput = new FilterInputStream(ClassPathURLStreamHandler.this.jarFile.getInputStream(this.jarEntry)){

                @Override
                public void close() throws IOException {
                    super.close();
                    if (ClassPathURLConnection.this.connectionJarFile != null && !ClassPathURLConnection.this.useCachedJarFile) {
                        ClassPathURLConnection.this.connectionJarFile.close();
                        ClassPathURLConnection.this.closed = true;
                    }
                }
            };
            return this.jarInput;
        }

        @Override
        public String getContentType() {
            String cType = ClassPathURLConnection.guessContentTypeFromName(this.getEntryName());
            if (cType == null) {
                cType = "content/unknown";
            }
            return cType;
        }

        @Override
        public int getContentLength() {
            try {
                this.connect();
                return (int)this.getJarEntry().getSize();
            }
            catch (IOException iOException) {
                return -1;
            }
        }
    }
}

