/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.icu.text.DecimalFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NumberFormat;
import android.icu.text.NumberingSystem;
import android.icu.util.ULocale;
import com.android.icu.text.ExtendedDecimalFormatSymbols;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import libcore.icu.LocaleData;

public class DecimalFormatData {
    private static final ConcurrentHashMap<String, DecimalFormatData> CACHE = new ConcurrentHashMap(3);
    private final char zeroDigit;
    private final char decimalSeparator;
    private final char groupingSeparator;
    private final char patternSeparator;
    private final String percent;
    private final String perMill;
    private final String monetaryDecimalSeparator;
    private final String monetaryGroupSeparator;
    private final String minusSign;
    private final String exponentSeparator;
    private final String infinity;
    private final String NaN;
    private final String numberPattern;
    private final String currencyPattern;
    private final String percentPattern;

    private DecimalFormatData(Locale locale) {
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(locale);
        this.decimalSeparator = dfs.getDecimalSeparator();
        this.groupingSeparator = dfs.getGroupingSeparator();
        this.percent = dfs.getPercentString();
        this.perMill = dfs.getPerMillString();
        this.monetaryDecimalSeparator = dfs.getMonetaryDecimalSeparatorString();
        this.monetaryGroupSeparator = dfs.getMonetaryGroupingSeparatorString();
        this.minusSign = dfs.getMinusSignString();
        this.exponentSeparator = dfs.getExponentSeparator();
        this.infinity = dfs.getInfinity();
        this.NaN = dfs.getNaN();
        this.zeroDigit = dfs.getZeroDigit();
        this.patternSeparator = DecimalFormatData.loadPatternSeparator(locale);
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(locale, 0);
        this.numberPattern = df.toPattern();
        df = (DecimalFormat)NumberFormat.getInstance(locale, 1);
        this.currencyPattern = df.toPattern();
        df = (DecimalFormat)NumberFormat.getInstance(locale, 2);
        this.percentPattern = df.toPattern();
    }

    public static DecimalFormatData getInstance(Locale locale) {
        Objects.requireNonNull(locale, "locale can't be null");
        locale = LocaleData.getCompatibleLocaleForBug159514442(locale);
        String languageTag = locale.toLanguageTag();
        DecimalFormatData data = CACHE.get(languageTag);
        if (data != null) {
            return data;
        }
        data = new DecimalFormatData(locale);
        DecimalFormatData prev = CACHE.putIfAbsent(languageTag, data);
        if (prev != null) {
            return prev;
        }
        return data;
    }

    public static void initializeCacheInZygote() {
        DecimalFormatData.getInstance(Locale.ROOT);
        DecimalFormatData.getInstance(Locale.US);
        DecimalFormatData.getInstance(AndroidLocale.getDefault());
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public String getPercent() {
        return this.percent;
    }

    public String getPerMill() {
        return this.perMill;
    }

    public String getMonetaryDecimalSeparator() {
        return this.monetaryDecimalSeparator;
    }

    public String getMonetaryGroupSeparator() {
        return this.monetaryGroupSeparator;
    }

    public String getMinusSign() {
        return this.minusSign;
    }

    public String getExponentSeparator() {
        return this.exponentSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public String getNaN() {
        return this.NaN;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public String getCurrencyPattern() {
        return this.currencyPattern;
    }

    public String getPercentPattern() {
        return this.percentPattern;
    }

    private static char loadPatternSeparator(Locale locale) {
        String patternSeparator;
        ULocale uLocale = ULocale.forLocale(locale);
        NumberingSystem ns = NumberingSystem.getInstance(uLocale);
        if (ns == null || ns.getRadix() != 10 || ns.isAlgorithmic()) {
            ns = NumberingSystem.LATIN;
        }
        if ((patternSeparator = ExtendedDecimalFormatSymbols.getInstance(uLocale, ns).getLocalizedPatternSeparator()) == null || patternSeparator.isEmpty()) {
            patternSeparator = ";";
        }
        return patternSeparator.charAt(0);
    }
}

