/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os._Original_Build;
import android.util.Size;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Checkable;
import android.widget.Switch;
import android.widget.TextView;
import com.android.layoutlib.androidx.annotation.ChecksSdkIntAtLeast;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import com.google.android.apps.common.testing.accessibility.framework.replacements.LayoutParams;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableStringAndroid;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableStringBuilder;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityNodeInfoExtraDataExtractor;
import com.google.android.apps.common.testing.accessibility.framework.uielement.CustomViewBuilderAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyActionAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementOrigin;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElementAndroid;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class ViewHierarchyElementAndroid
extends ViewHierarchyElement {
    @ChecksSdkIntAtLeast(api=30)
    private static final boolean AT_30 = _Original_Build.VERSION.SDK_INT >= 30;
    @ChecksSdkIntAtLeast(api=29)
    private static final boolean AT_29 = _Original_Build.VERSION.SDK_INT >= 29;
    @ChecksSdkIntAtLeast(api=28)
    private static final boolean AT_28 = _Original_Build.VERSION.SDK_INT >= 28;
    @ChecksSdkIntAtLeast(api=26)
    private static final boolean AT_26 = _Original_Build.VERSION.SDK_INT >= 26;
    @ChecksSdkIntAtLeast(api=24)
    private static final boolean AT_24 = _Original_Build.VERSION.SDK_INT >= 24;
    @ChecksSdkIntAtLeast(api=23)
    private static final boolean AT_23 = _Original_Build.VERSION.SDK_INT >= 23;
    @ChecksSdkIntAtLeast(api=21)
    private static final boolean AT_21 = _Original_Build.VERSION.SDK_INT >= 21;
    @ChecksSdkIntAtLeast(api=18)
    private static final boolean AT_18 = _Original_Build.VERSION.SDK_INT >= 18;
    @ChecksSdkIntAtLeast(api=16)
    private static final boolean AT_16 = _Original_Build.VERSION.SDK_INT >= 16;
    private @MonotonicNonNull WindowHierarchyElementAndroid windowElement;

    protected ViewHierarchyElementAndroid(int id2, @Nullable Integer parentId, List<Integer> childIds, @Nullable CharSequence packageName, @Nullable CharSequence className, @Nullable CharSequence accessibilityClassName, ViewHierarchyElementOrigin origin, @Nullable String resourceName, @Nullable CharSequence testTag, @Nullable SpannableString contentDescription, @Nullable SpannableString text, @Nullable SpannableString stateDescription, boolean importantForAccessibility, @Nullable Boolean visibleToUser, boolean clickable, boolean longClickable, boolean focusable, @Nullable Boolean editable, @Nullable Boolean scrollable, @Nullable Boolean canScrollForward, @Nullable Boolean canScrollBackward, @Nullable Boolean checkable, @Nullable Boolean checked, @Nullable Boolean hasTouchDelegate, boolean isScreenReaderFocusable, List<com.google.android.apps.common.testing.accessibility.framework.replacements.Rect> touchDelegateBounds, @Nullable com.google.android.apps.common.testing.accessibility.framework.replacements.Rect boundsInScreen, @Nullable Integer nonclippedHeight, @Nullable Integer nonclippedWidth, @Nullable Float textSize, @Nullable Integer textSizeUnit, @Nullable Integer textColor, @Nullable Integer backgroundDrawableColor, @Nullable Integer typefaceStyle, boolean enabled, @Nullable Long labeledById, @Nullable Long accessibilityTraversalBeforeId, @Nullable Long accessibilityTraversalAfterId, @Nullable Integer drawingOrder, List<Integer> superclassViews, List<ViewHierarchyActionAndroid> actionList, @Nullable LayoutParams layoutParams, @Nullable SpannableString hintText, @Nullable Integer hintTextColor, List<com.google.android.apps.common.testing.accessibility.framework.replacements.Rect> textCharacterLocations) {
        super(id2, parentId, childIds, packageName, className, accessibilityClassName, origin, resourceName, testTag, contentDescription, text, stateDescription, importantForAccessibility, visibleToUser, clickable, longClickable, focusable, editable, scrollable, canScrollForward, canScrollBackward, checkable, checked, hasTouchDelegate, isScreenReaderFocusable, touchDelegateBounds, boundsInScreen, nonclippedHeight, nonclippedWidth, textSize, textSizeUnit, textColor, backgroundDrawableColor, typefaceStyle, enabled, labeledById, accessibilityTraversalBeforeId, accessibilityTraversalAfterId, drawingOrder, superclassViews, actionList, layoutParams, hintText, hintTextColor, textCharacterLocations);
    }

    @Override
    @Pure
    public @Nullable ViewHierarchyElementAndroid getParentView() {
        Integer parentIdTmp = this.parentId;
        return parentIdTmp != null ? this.getWindow().getViewById(parentIdTmp) : null;
    }

    @Override
    public ViewHierarchyElementAndroid getChildView(int atIndex) {
        if (atIndex < 0 || this.childIds == null || atIndex >= this.childIds.size()) {
            throw new NoSuchElementException();
        }
        return this.getWindow().getViewById((Integer)this.childIds.get(atIndex));
    }

    public List<ViewHierarchyElementAndroid> getSelfAndAllDescendants() {
        ArrayList<ViewHierarchyElementAndroid> listToPopulate = new ArrayList<ViewHierarchyElementAndroid>();
        listToPopulate.add(this);
        for (int i = 0; i < this.getChildViewCount(); ++i) {
            listToPopulate.addAll(this.getChildView(i).getSelfAndAllDescendants());
        }
        return Collections.unmodifiableList(listToPopulate);
    }

    @Override
    public WindowHierarchyElementAndroid getWindow() {
        return (WindowHierarchyElementAndroid)Preconditions.checkNotNull((Object)this.windowElement);
    }

    @Override
    @Pure
    public @Nullable ViewHierarchyElementAndroid getLabeledBy() {
        return this.getViewHierarchyElementById(this.labeledById);
    }

    @Override
    public @Nullable ViewHierarchyElementAndroid getAccessibilityTraversalBefore() {
        return this.getViewHierarchyElementById(this.accessibilityTraversalBeforeId);
    }

    @Override
    public @Nullable ViewHierarchyElementAndroid getAccessibilityTraversalAfter() {
        return this.getViewHierarchyElementById(this.accessibilityTraversalAfterId);
    }

    public void getBoundsInScreen(Rect outBounds) {
        if (this.boundsInScreen != null) {
            outBounds.set(new Rect(this.boundsInScreen.getLeft(), this.boundsInScreen.getTop(), this.boundsInScreen.getRight(), this.boundsInScreen.getBottom()));
        } else {
            outBounds.setEmpty();
        }
    }

    void setWindow(WindowHierarchyElementAndroid window) {
        this.windowElement = window;
    }

    void addChild(ViewHierarchyElementAndroid child) {
        if (this.childIds == null) {
            this.childIds = new ArrayList();
        }
        this.childIds.add(child.id);
    }

    void setLabeledBy(ViewHierarchyElementAndroid labelingElement) {
        this.labeledById = labelingElement != null ? Long.valueOf(labelingElement.getCondensedUniqueId()) : null;
    }

    void setAccessibilityTraversalBefore(ViewHierarchyElementAndroid element) {
        this.accessibilityTraversalBeforeId = element.getCondensedUniqueId();
    }

    void setAccessibilityTraversalAfter(ViewHierarchyElementAndroid element) {
        this.accessibilityTraversalAfterId = element.getCondensedUniqueId();
    }

    private @Nullable ViewHierarchyElementAndroid getViewHierarchyElementById(@Nullable Long id2) {
        return id2 != null ? this.getWindow().getAccessibilityHierarchy().getViewById(id2) : null;
    }

    static Builder newBuilder(int id2, @Nullable ViewHierarchyElementAndroid parent, View fromView, CustomViewBuilderAndroid customViewBuilder, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
        return new Builder(id2, parent, fromView, customViewBuilder, extraDataExtractor);
    }

    static Builder newBuilder(int id2, @Nullable ViewHierarchyElementAndroid parent, AccessibilityNodeInfo fromInfo, @Nullable View view, @Nullable AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
        return new Builder(id2, parent, fromInfo, view, extraDataExtractor);
    }

    static class Builder {
        private final int id;
        private final @Nullable Integer parentId;
        private final List<Integer> childIds = new ArrayList<Integer>();
        private final @Nullable CharSequence packageName;
        private final @Nullable CharSequence className;
        private final @Nullable CharSequence accessibilityClassName;
        private final ViewHierarchyElementOrigin origin;
        private final @Nullable String resourceName;
        private final @Nullable CharSequence testTag;
        private final @Nullable SpannableString contentDescription;
        private final @Nullable SpannableString text;
        private final @Nullable SpannableString stateDescription;
        private final boolean importantForAccessibility;
        private final @Nullable Boolean visibleToUser;
        private final boolean clickable;
        private final boolean longClickable;
        private final boolean focusable;
        private final @Nullable Boolean editable;
        private final @Nullable Boolean scrollable;
        private final @Nullable Boolean canScrollForward;
        private final @Nullable Boolean canScrollBackward;
        private final @Nullable Boolean checkable;
        private final @Nullable Boolean checked;
        private final @Nullable Boolean hasTouchDelegate;
        private final boolean isScreenReaderFocusable;
        private final List<com.google.android.apps.common.testing.accessibility.framework.replacements.Rect> touchDelegateBounds;
        private final @Nullable com.google.android.apps.common.testing.accessibility.framework.replacements.Rect boundsInScreen;
        private final @Nullable Integer nonclippedHeight;
        private final @Nullable Integer nonclippedWidth;
        private final @Nullable Float textSize;
        private final @Nullable Integer textSizeUnit;
        private final @Nullable Integer textColor;
        private final @Nullable Integer backgroundDrawableColor;
        private final @Nullable Integer typefaceStyle;
        private final boolean enabled;
        private @Nullable Long labeledById;
        private @Nullable Long accessibilityTraversalBeforeId;
        private @Nullable Long accessibilityTraversalAfterId;
        private final List<Integer> superclassViews = new ArrayList<Integer>();
        private final @Nullable Integer drawingOrder;
        private ImmutableList<ViewHierarchyActionAndroid> actionList;
        private final @Nullable LayoutParams layoutParams;
        private final @Nullable SpannableString hintText;
        private final @Nullable Integer hintTextColor;
        private final List<com.google.android.apps.common.testing.accessibility.framework.replacements.Rect> textCharacterLocations;

        Builder(int id2, @Nullable ViewHierarchyElementAndroid parent, AccessibilityNodeInfo fromInfo, @Nullable View view, @Nullable AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            this.id = id2;
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            AccessibilityNodeInfoExtraDataExtractor.ExtraData extraData = extraDataExtractor != null ? extraDataExtractor.getExtraData(fromInfo) : null;
            this.resourceName = AT_18 ? fromInfo.getViewIdResourceName() : null;
            this.testTag = extraData == null ? null : extraData.getTestTag();
            this.editable = AT_18 ? Boolean.valueOf(fromInfo.isEditable()) : null;
            Boolean bl = this.visibleToUser = AT_16 ? Boolean.valueOf(fromInfo.isVisibleToUser()) : null;
            if (AT_21) {
                ImmutableList.Builder actionBuilder = new ImmutableList.Builder();
                actionBuilder.addAll((Iterable)Lists.transform(fromInfo.getActionList(), action -> ViewHierarchyActionAndroid.newBuilder(action).build()));
                this.actionList = actionBuilder.build();
            }
            this.drawingOrder = AT_24 ? Integer.valueOf(fromInfo.getDrawingOrder()) : null;
            this.importantForAccessibility = AT_24 ? fromInfo.isImportantForAccessibility() : true;
            this.isScreenReaderFocusable = AT_28 && fromInfo.isScreenReaderFocusable();
            this.stateDescription = AT_30 ? SpannableStringAndroid.valueOf(fromInfo.getStateDescription()) : null;
            this.packageName = fromInfo.getPackageName();
            this.contentDescription = SpannableStringAndroid.valueOf(fromInfo.getContentDescription());
            this.clickable = fromInfo.isClickable();
            this.longClickable = fromInfo.isLongClickable();
            this.focusable = fromInfo.isFocusable();
            this.scrollable = fromInfo.isScrollable();
            this.canScrollForward = AT_21 ? fromInfo.getActionList().contains(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD) : (fromInfo.getActions() & 0x1000) != 0;
            this.canScrollBackward = AT_21 ? fromInfo.getActionList().contains(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD) : (fromInfo.getActions() & 0x2000) != 0;
            this.checkable = fromInfo.isCheckable();
            this.checked = fromInfo.isChecked();
            this.touchDelegateBounds = new ArrayList<com.google.android.apps.common.testing.accessibility.framework.replacements.Rect>();
            Rect tempRect = new Rect();
            fromInfo.getBoundsInScreen(tempRect);
            this.boundsInScreen = view == null ? new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(tempRect.left, tempRect.top, tempRect.right, tempRect.bottom) : Builder.getBoundsInScreen(view);
            this.enabled = fromInfo.isEnabled();
            this.text = AT_26 && fromInfo.isShowingHintText() ? null : SpannableStringAndroid.valueOf(fromInfo.getText());
            this.hintText = AT_26 ? SpannableStringAndroid.valueOf(fromInfo.getHintText()) : null;
            this.hintTextColor = null;
            ImmutableList characterLocations = extraData != null ? extraData.getTextCharacterLocations() : null;
            this.textCharacterLocations = characterLocations != null ? characterLocations : ImmutableList.of();
            this.textSize = extraData != null ? extraData.getTextSize() : null;
            this.textSizeUnit = extraData != null ? extraData.getTextSizeUnit() : null;
            Size layoutSize = extraData != null ? extraData.getLayoutSize() : null;
            LayoutParams layoutParams = this.layoutParams = layoutSize == null ? null : new LayoutParams(layoutSize.getWidth(), layoutSize.getHeight());
            if (view instanceof TextView) {
                TextView textView = (TextView)view;
                this.textColor = textView.getCurrentTextColor();
                this.typefaceStyle = textView.getTypeface() != null ? Integer.valueOf(textView.getTypeface().getStyle()) : null;
            } else {
                this.textColor = null;
                this.typefaceStyle = null;
            }
            if (view == null) {
                this.className = fromInfo.getClassName();
                this.accessibilityClassName = fromInfo.getClassName();
                this.nonclippedHeight = null;
                this.nonclippedWidth = null;
                this.backgroundDrawableColor = null;
                this.hasTouchDelegate = AT_29 ? Boolean.valueOf(fromInfo.getTouchDelegateInfo() != null) : null;
            } else {
                this.className = view.getClass().getName();
                this.accessibilityClassName = AT_23 ? view.getAccessibilityClassName() : null;
                this.nonclippedHeight = view.getHeight();
                this.nonclippedWidth = view.getWidth();
                this.backgroundDrawableColor = Builder.getBackgroundDrawableColor(view);
                this.hasTouchDelegate = view.getTouchDelegate() != null;
            }
            this.origin = ViewHierarchyElement.computeOrigin(this.className, parent);
        }

        private Builder(int id2, @Nullable ViewHierarchyElementAndroid parent, View fromView, CustomViewBuilderAndroid customViewBuilder, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            this.id = id2;
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            this.drawingOrder = null;
            this.scrollable = AT_16 ? Boolean.valueOf(fromView.isScrollContainer()) : null;
            this.visibleToUser = ViewAccessibilityUtils.isVisibleToUser(fromView);
            this.className = fromView.getClass().getName();
            this.accessibilityClassName = AT_23 ? fromView.getAccessibilityClassName() : null;
            this.packageName = fromView.getContext().getPackageName();
            this.resourceName = ViewAccessibilityUtils.getResourceNameForView(fromView);
            this.testTag = null;
            this.contentDescription = SpannableStringAndroid.valueOf(fromView.getContentDescription());
            this.stateDescription = AT_30 ? SpannableStringAndroid.valueOf(fromView.getStateDescription()) : null;
            this.enabled = fromView.isEnabled();
            if (fromView instanceof TextView) {
                TextView textView = (TextView)fromView;
                CharSequence text = textView.getText();
                if (fromView instanceof Switch && !AT_30) {
                    Switch swtch = (Switch)fromView;
                    CharSequence switchText = swtch.isChecked() ? swtch.getTextOn() : swtch.getTextOff();
                    this.text = new SpannableStringBuilder().append(SpannableStringAndroid.valueOf(text)).appendWithSeparator(SpannableStringAndroid.valueOf(switchText)).build();
                } else {
                    this.text = SpannableStringAndroid.valueOf(text);
                }
                this.textSize = Float.valueOf(textView.getTextSize());
                this.textSizeUnit = AT_30 ? Integer.valueOf(textView.getTextSizeUnit()) : null;
                this.textColor = textView.getCurrentTextColor();
                this.typefaceStyle = textView.getTypeface() != null ? Integer.valueOf(textView.getTypeface().getStyle()) : null;
                this.hintText = SpannableStringAndroid.valueOf(textView.getHint());
                this.hintTextColor = textView.getCurrentHintTextColor();
                this.textCharacterLocations = extraDataExtractor.getTextCharacterLocations(textView);
            } else {
                this.text = null;
                this.textSize = null;
                this.textSizeUnit = null;
                this.textColor = null;
                this.typefaceStyle = null;
                this.hintText = null;
                this.hintTextColor = null;
                this.textCharacterLocations = ImmutableList.of();
            }
            this.importantForAccessibility = ViewAccessibilityUtils.isImportantForAccessibility(fromView);
            this.backgroundDrawableColor = Builder.getBackgroundDrawableColor(fromView);
            this.clickable = fromView.isClickable();
            this.longClickable = fromView.isLongClickable();
            this.focusable = fromView.isFocusable();
            this.editable = ViewAccessibilityUtils.isViewEditable(fromView);
            this.canScrollForward = fromView.canScrollVertically(1) || fromView.canScrollHorizontally(1);
            this.canScrollBackward = fromView.canScrollVertically(-1) || fromView.canScrollHorizontally(-1);
            this.checkable = customViewBuilder.isCheckable(fromView);
            this.checked = fromView instanceof Checkable ? Boolean.valueOf(((Checkable)((Object)fromView)).isChecked()) : null;
            this.hasTouchDelegate = fromView.getTouchDelegate() != null;
            this.isScreenReaderFocusable = AT_28 && fromView.isScreenReaderFocusable();
            this.touchDelegateBounds = ImmutableList.of();
            this.boundsInScreen = Builder.getBoundsInScreen(fromView);
            this.nonclippedHeight = fromView.getHeight();
            this.nonclippedWidth = fromView.getWidth();
            this.actionList = ImmutableList.of();
            ViewGroup.LayoutParams layoutParams = fromView.getLayoutParams();
            this.layoutParams = layoutParams == null ? null : new LayoutParams(layoutParams.width, layoutParams.height);
            this.origin = ViewHierarchyElement.computeOrigin(this.className, parent);
        }

        public ViewHierarchyElementAndroid build() {
            return new ViewHierarchyElementAndroid(this.id, this.parentId, this.childIds, this.packageName, this.className, this.accessibilityClassName, this.origin, this.resourceName, this.testTag, this.contentDescription, this.text, this.stateDescription, this.importantForAccessibility, this.visibleToUser, this.clickable, this.longClickable, this.focusable, this.editable, this.scrollable, this.canScrollForward, this.canScrollBackward, this.checkable, this.checked, this.hasTouchDelegate, this.isScreenReaderFocusable, this.touchDelegateBounds, this.boundsInScreen, this.nonclippedHeight, this.nonclippedWidth, this.textSize, this.textSizeUnit, this.textColor, this.backgroundDrawableColor, this.typefaceStyle, this.enabled, this.labeledById, this.accessibilityTraversalBeforeId, this.accessibilityTraversalAfterId, this.drawingOrder, this.superclassViews, (List<ViewHierarchyActionAndroid>)this.actionList, this.layoutParams, this.hintText, this.hintTextColor, this.textCharacterLocations);
        }

        private static @Nullable Integer getBackgroundDrawableColor(View fromView) {
            Drawable background = fromView.getBackground();
            return background instanceof ColorDrawable ? Integer.valueOf(((ColorDrawable)background).getColor()) : null;
        }

        private static @Nullable com.google.android.apps.common.testing.accessibility.framework.replacements.Rect getBoundsInScreen(View fromView) {
            Rect tempRect = new Rect();
            if (!fromView.getGlobalVisibleRect(tempRect)) {
                return null;
            }
            int[] locationOnScreen = new int[2];
            int[] locationInWindow = new int[2];
            fromView.getLocationOnScreen(locationOnScreen);
            fromView.getLocationInWindow(locationInWindow);
            int xOffset = locationOnScreen[0] - locationInWindow[0];
            int yOffset = locationOnScreen[1] - locationInWindow[1];
            tempRect.offset(xOffset, yOffset);
            return new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(tempRect.left, tempRect.top, tempRect.right, tempRect.bottom);
        }
    }
}

