/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.monet;

import android.util.Pair;
import com.android.systemui.monet.CustomDynamicColors;
import com.android.systemui.monet.TonalPalette;
import com.google.ux.material.libmonet.dynamiccolor.DynamicColor;
import com.google.ux.material.libmonet.dynamiccolor.DynamicScheme;
import com.google.ux.material.libmonet.dynamiccolor.MaterialDynamicColors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DynamicColors {
    public static List<Pair<String, DynamicColor>> getAllNeutralPalette() {
        List<Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>> neutralPaletteMap = Arrays.asList(new Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>("neutral1", s -> s.neutralPalette), new Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>("neutral2", s -> s.neutralVariantPalette));
        return DynamicColors.generatePaletteColors(neutralPaletteMap);
    }

    public static List<Pair<String, DynamicColor>> getAllAccentPalette() {
        List<Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>> accentPaletteMap = Arrays.asList(new Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>("accent1", s -> s.primaryPalette), new Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>("accent2", s -> s.secondaryPalette), new Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>("accent3", s -> s.tertiaryPalette));
        return DynamicColors.generatePaletteColors(accentPaletteMap);
    }

    public static List<Pair<String, DynamicColor>> getAllErrorPalette() {
        List<Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>> errorPaletteMap = Arrays.asList(new Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>("error", s -> s.errorPalette));
        return DynamicColors.generatePaletteColors(errorPaletteMap);
    }

    public static List<Pair<String, DynamicColor>> getAllDynamicColorsMapped() {
        MaterialDynamicColors mdc = new MaterialDynamicColors();
        return DynamicColors.generateSysUINames(mdc.allDynamicColors().stream().filter(dc -> !((DynamicColor)dc.get()).name.contains("fixed")).toList());
    }

    public static List<Pair<String, DynamicColor>> getFixedColorsMapped() {
        MaterialDynamicColors mdc = new MaterialDynamicColors();
        return DynamicColors.generateSysUINames(mdc.allDynamicColors().stream().filter(dc -> ((DynamicColor)dc.get()).name.contains("fixed")).toList());
    }

    public static List<Pair<String, DynamicColor>> getCustomColorsMapped() {
        CustomDynamicColors customMdc = new CustomDynamicColors();
        return DynamicColors.generateSysUINames(customMdc.allColors);
    }

    private static List<Pair<String, DynamicColor>> generateSysUINames(List<Supplier<DynamicColor>> allColors) {
        ArrayList<Pair<String, DynamicColor>> list = new ArrayList<Pair<String, DynamicColor>>();
        for (Supplier<DynamicColor> supplier : allColors) {
            DynamicColor dynamicColor = supplier.get();
            String name = dynamicColor.name;
            String paletteMark = "palette_key_color";
            if (name.contains("_" + paletteMark)) {
                name = paletteMark + "_" + name.replace("_" + paletteMark, "");
            }
            list.add(new Pair<String, DynamicColor>(name, dynamicColor));
        }
        list.sort(Comparator.comparing(pair -> (String)pair.first));
        return list;
    }

    private static List<Pair<String, DynamicColor>> generatePaletteColors(List<Pair<String, Function<DynamicScheme, com.google.ux.material.libmonet.palettes.TonalPalette>>> paletteMap) {
        return paletteMap.stream().flatMap(palettePair -> {
            String paletteName = (String)palettePair.first;
            Function paletteExtractor = (Function)palettePair.second;
            return TonalPalette.SHADE_KEYS.stream().map(shade -> {
                String tokenName = paletteName + "_" + shade;
                DynamicColor token = new DynamicColor(tokenName, paletteExtractor, s -> (1000.0f - (float)shade.intValue()) / 10.0f, true, null, null, null, null);
                return new Pair<String, DynamicColor>(tokenName, token);
            });
        }).collect(Collectors.toList());
    }
}

