/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.jsoup.parser;

import com.android.layoutlib.jsoup.helper.Validate;
import com.android.layoutlib.jsoup.nodes.Comment;
import com.android.layoutlib.jsoup.nodes.DocumentType;
import com.android.layoutlib.jsoup.nodes.Element;
import com.android.layoutlib.jsoup.nodes.Node;
import com.android.layoutlib.jsoup.nodes.TextNode;
import com.android.layoutlib.jsoup.parser.ParseErrorList;
import com.android.layoutlib.jsoup.parser.Tag;
import com.android.layoutlib.jsoup.parser.Token;
import com.android.layoutlib.jsoup.parser.TreeBuilder;
import java.util.Iterator;

public class XmlTreeBuilder
extends TreeBuilder {
    protected void initialiseParse(String input, String baseUri, ParseErrorList errors) {
        super.initialiseParse(input, baseUri, errors);
        this.stack.add(this.doc);
    }

    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name());
        Element el = new Element(tag, this.baseUri, startTag.attributes);
        this.insertNode(el);
        if (startTag.isSelfClosing()) {
            this.tokeniser.acknowledgeSelfClosingFlag();
            if (!tag.isKnownTag()) {
                tag.setSelfClosing();
            }
        } else {
            this.stack.add(el);
        }
        return el;
    }

    void insert(Token.Comment commentToken) {
        Comment comment = new Comment(commentToken.getData(), this.baseUri);
        this.insertNode(comment);
    }

    void insert(Token.Character characterToken) {
        TextNode node = new TextNode(characterToken.getData(), this.baseUri);
        this.insertNode(node);
    }

    void insert(Token.Doctype d) {
        DocumentType doctypeNode = new DocumentType(d.getName(), d.getPublicIdentifier(), d.getSystemIdentifier(), this.baseUri);
        this.insertNode(doctypeNode);
    }

    private void popStackToClose(Token.EndTag endTag) {
        Element next;
        String elName = endTag.name();
        Element firstFound = null;
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            next = (Element)it.next();
            if (!next.nodeName().equals(elName)) continue;
            firstFound = next;
            break;
        }
        if (firstFound == null) {
            return;
        }
        it = this.stack.descendingIterator();
        while (it.hasNext()) {
            next = (Element)it.next();
            if (next == firstFound) {
                it.remove();
                break;
            }
            it.remove();
        }
    }
}

