/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.annotation.NonNull;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.AttachInfo_Accessor;
import android.view.View;
import android.widget.FrameLayout;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RenderDrawable
extends RenderAction<DrawableParams> {
    public RenderDrawable(@NonNull DrawableParams params) {
        super(new DrawableParams(params));
    }

    @NonNull
    public Result render() {
        this.checkLock();
        DrawableParams params = (DrawableParams)this.getParams();
        HardwareConfig hardwareConfig = params.getHardwareConfig();
        ResourceValue drawableResource = params.getDrawable();
        BridgeContext context = this.getContext();
        drawableResource = context.getRenderResources().resolveResValue(drawableResource);
        if (drawableResource == null) {
            return Result.Status.ERROR_NOT_A_DRAWABLE.createResult();
        }
        ResourceType resourceType = drawableResource.getResourceType();
        if (resourceType != ResourceType.DRAWABLE && resourceType != ResourceType.MIPMAP) {
            return Result.Status.ERROR_NOT_A_DRAWABLE.createResult();
        }
        Drawable d = ResourceHelper.getDrawable(drawableResource, context, context.getTheme());
        if (d == null) {
            return Result.Status.ERROR_NOT_A_DRAWABLE.createResult();
        }
        Boolean allStates = (Boolean)params.getFlag(RenderParamsFlags.FLAG_KEY_RENDER_ALL_DRAWABLE_STATES);
        if (Objects.equals(allStates, Boolean.TRUE)) {
            List<Object> result;
            if (d instanceof StateListDrawable) {
                StateListDrawable stateList = (StateListDrawable)d;
                result = new ArrayList();
                for (int i = 0; i < stateList.getStateCount(); ++i) {
                    Drawable stateDrawable = stateList.getStateDrawable(i);
                    result.add(this.renderImage(hardwareConfig, stateDrawable, context));
                }
            } else {
                result = Collections.singletonList(this.renderImage(hardwareConfig, d, context));
            }
            return Result.Status.SUCCESS.createResult(result);
        }
        BufferedImage image = this.renderImage(hardwareConfig, d, context);
        return Result.Status.SUCCESS.createResult((Object)image);
    }

    @NonNull
    private BufferedImage renderImage(@NonNull HardwareConfig hardwareConfig, @NonNull Drawable d, @NonNull BridgeContext context) {
        FrameLayout content = new FrameLayout(context);
        content.setBackground(d);
        AttachInfo_Accessor.setAttachInfo(content);
        int w = d.getIntrinsicWidth();
        int h = d.getIntrinsicHeight();
        int screenWidth = hardwareConfig.getScreenWidth();
        int screenHeight = hardwareConfig.getScreenHeight();
        if (w == -1 || h == -1) {
            w = screenWidth;
            h = screenHeight;
        }
        int w_spec = View.MeasureSpec.makeMeasureSpec(w, 0x40000000);
        int h_spec = View.MeasureSpec.makeMeasureSpec(h, 0x40000000);
        content.measure(w_spec, h_spec);
        content.layout(0, 0, w, h);
        AttachInfo_Accessor.dispatchOnPreDraw(content);
        Bitmap bitmap = Bitmap.createBitmap(w, h, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.setDensity(hardwareConfig.getDensity().getDpiValue());
        content.draw(canvas);
        if (w > screenWidth || h > screenHeight) {
            double scale = Math.min((double)screenWidth / (double)w, (double)screenHeight / (double)h);
            bitmap = Bitmap.createScaledBitmap(bitmap, (int)((double)w * scale), (int)((double)h * scale), true);
        }
        BufferedImage image = new BufferedImage(bitmap.getWidth(), bitmap.getHeight(), 2);
        int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        bitmap.getPixels(imageData, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        AttachInfo_Accessor.detachFromWindow(content);
        return image;
    }
}

