/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutParserWrapper
implements XmlPullParser {
    private static final String TAG_LAYOUT = "layout";
    private static final String TAG_DATA = "data";
    private static final String DEFAULT = "default=";
    private final XmlPullParser mDelegate;
    private boolean mPeeked;
    private int mEventType;
    private int mDepth;
    private int mNext;
    private List<Attribute> mAttributes;
    private String mText;
    private String mName;
    private boolean mIsWhitespace;
    private int mFinalDepth = -1;
    private boolean mEndNow;

    public LayoutParserWrapper(XmlPullParser delegate) {
        this.mDelegate = delegate;
    }

    public LayoutParserWrapper peekTillLayoutStart() throws IOException, XmlPullParserException {
        boolean STATE_LAYOUT_NOT_STARTED = false;
        boolean STATE_ROOT_NOT_STARTED = true;
        int STATE_INSIDE_DATA = 2;
        int state = 0;
        int dataDepth = -1;
        while (true) {
            int peekNext = this.peekNext();
            switch (peekNext) {
                case 2: {
                    if (state == 0) {
                        if (this.mName.equals(TAG_LAYOUT)) {
                            state = 1;
                            break;
                        }
                        return this;
                    }
                    if (state != 1) break;
                    if (this.mName.equals(TAG_DATA)) {
                        state = 2;
                        dataDepth = this.mDepth;
                        break;
                    }
                    this.mFinalDepth = this.mDepth;
                    return this;
                }
                case 3: {
                    if (state != 2 || this.mDepth > dataDepth) break;
                    state = 1;
                    break;
                }
                case 1: {
                    return this;
                }
            }
            this.next();
        }
    }

    private int peekNext() throws IOException, XmlPullParserException {
        if (this.mPeeked) {
            return this.mNext;
        }
        this.mEventType = this.mDelegate.getEventType();
        this.mNext = this.mDelegate.next();
        if (this.mEventType == 2) {
            int count = this.mDelegate.getAttributeCount();
            this.mAttributes = count > 0 ? new ArrayList(count) : Collections.emptyList();
            for (int i = 0; i < count; ++i) {
                this.mAttributes.add(new Attribute(this.mDelegate.getAttributeNamespace(i), this.mDelegate.getAttributeName(i), this.mDelegate.getAttributeValue(i)));
            }
        }
        this.mDepth = this.mDelegate.getDepth();
        this.mText = this.mDelegate.getText();
        this.mName = this.mDelegate.getName();
        this.mIsWhitespace = this.mNext == 4 && this.mDelegate.isWhitespace();
        this.mPeeked = true;
        return this.mNext;
    }

    private void reset() {
        this.mAttributes = null;
        this.mText = null;
        this.mName = null;
        this.mPeeked = false;
    }

    public int next() throws XmlPullParserException, IOException {
        int depth;
        int returnValue;
        if (this.mPeeked) {
            returnValue = this.mNext;
            depth = this.mDepth;
            this.reset();
        } else {
            if (this.mEndNow) {
                return 1;
            }
            returnValue = this.mDelegate.next();
            depth = this.getDepth();
        }
        if (returnValue == 3 && depth <= this.mFinalDepth) {
            this.mEndNow = true;
        }
        return returnValue;
    }

    public int getEventType() throws XmlPullParserException {
        return this.mPeeked ? this.mEventType : this.mDelegate.getEventType();
    }

    public int getDepth() {
        return this.mPeeked ? this.mDepth : this.mDelegate.getDepth();
    }

    public String getName() {
        return this.mPeeked ? this.mName : this.mDelegate.getName();
    }

    public String getText() {
        return this.mPeeked ? this.mText : this.mDelegate.getText();
    }

    public String getAttributeValue(@Nullable String namespace, String name) {
        String returnValue = null;
        if (this.mPeeked) {
            if (this.mAttributes == null) {
                if (this.mEventType != 2) {
                    throw new IndexOutOfBoundsException("getAttributeValue() called when not at START_TAG.");
                }
                return null;
            }
            for (Attribute attribute : this.mAttributes) {
                if (!attribute.name.equals(name) || !Objects.equals(attribute.namespace, namespace)) continue;
                returnValue = attribute.value;
                break;
            }
        } else {
            returnValue = this.mDelegate.getAttributeValue(namespace, name);
        }
        if (returnValue != null && this.mFinalDepth >= 0 && returnValue.startsWith("@{")) {
            int i = returnValue.lastIndexOf(DEFAULT);
            return i > 0 ? returnValue.substring(i + DEFAULT.length(), returnValue.length() - 1) : null;
        }
        return returnValue;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        return this.mPeeked ? this.mIsWhitespace : this.mDelegate.isWhitespace();
    }

    public void setFeature(String s, boolean b) throws XmlPullParserException {
        this.mDelegate.setFeature(s, b);
    }

    public void setProperty(String s, Object o) throws XmlPullParserException {
        this.mDelegate.setProperty(s, o);
    }

    public void setInput(InputStream inputStream, String s) throws XmlPullParserException {
        this.mDelegate.setInput(inputStream, s);
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        this.mDelegate.setInput(reader);
    }

    public String getInputEncoding() {
        return this.mDelegate.getInputEncoding();
    }

    public String getNamespace(String s) {
        return this.mDelegate.getNamespace(s);
    }

    public String getPositionDescription() {
        return this.mDelegate.getPositionDescription();
    }

    public int getLineNumber() {
        return this.mDelegate.getLineNumber();
    }

    public String getNamespace() {
        return this.mDelegate.getNamespace();
    }

    public int getColumnNumber() {
        return this.mDelegate.getColumnNumber();
    }

    public void require(int i, String s, String s1) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public boolean getFeature(String s) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public void defineEntityReplacementText(String s, String s1) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public Object getProperty(String s) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public int nextToken() {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public int getNamespaceCount(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String getNamespacePrefix(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String getNamespaceUri(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public char[] getTextCharacters(int[] ints) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String getPrefix() {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public boolean isEmptyElementTag() {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public int getAttributeCount() {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String getAttributeNamespace(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String getAttributeName(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String getAttributePrefix(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String getAttributeType(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public boolean isAttributeDefault(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String getAttributeValue(int i) {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public String nextText() {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    public int nextTag() {
        throw new UnsupportedOperationException("Only few parser methods are supported.");
    }

    private static class Attribute {
        @Nullable
        private final String namespace;
        private final String name;
        private final String value;

        private Attribute(@Nullable String namespace, String name, String value) {
            this.namespace = namespace;
            this.name = name;
            this.value = value;
        }
    }
}

