/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.res.XmlResourceParser;
import android.util.BridgeXmlPullAttributes;
import android.util.ResolvingAttributeSet;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.NopAttributeSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BridgeXmlBlockParser
implements XmlResourceParser,
ResolvingAttributeSet {
    @NonNull
    private final XmlPullParser mParser;
    @NonNull
    private final ResolvingAttributeSet mAttrib;
    @Nullable
    private final BridgeContext mContext;
    @NonNull
    private final ResourceNamespace mFileResourceNamespace;
    private boolean mStarted = false;
    private int mEventType = 0;
    private boolean mPopped = true;

    public BridgeXmlBlockParser(@NonNull XmlPullParser parser, @Nullable BridgeContext context, @NonNull ResourceNamespace fileNamespace) {
        this.mParser = parser;
        this.mContext = context;
        this.mFileResourceNamespace = fileNamespace;
        if (this.mContext != null) {
            this.mAttrib = new BridgeXmlPullAttributes(parser, context, this.mFileResourceNamespace);
            this.mContext.pushParser(this);
            this.mPopped = false;
        } else {
            this.mAttrib = new NopAttributeSet();
        }
    }

    public XmlPullParser getParser() {
        return this.mParser;
    }

    @NonNull
    public ResourceNamespace getFileResourceNamespace() {
        return this.mFileResourceNamespace;
    }

    public Object getViewCookie() {
        if (this.mParser instanceof ILayoutPullParser) {
            return ((ILayoutPullParser)this.mParser).getViewCookie();
        }
        return null;
    }

    public void ensurePopped() {
        if (this.mContext != null && !this.mPopped) {
            this.mContext.popParser();
            this.mPopped = true;
        }
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name) && state) {
            return;
        }
        if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name) && state) {
            return;
        }
        throw new XmlPullParserException("Unsupported feature: " + name);
    }

    public boolean getFeature(String name) {
        return "http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name) || "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name);
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        throw new XmlPullParserException("setProperty() not supported");
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setInput(Reader in) throws XmlPullParserException {
        this.mParser.setInput(in);
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        this.mParser.setInput(inputStream, inputEncoding);
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
        throw new XmlPullParserException("defineEntityReplacementText() not supported");
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespacePrefix() not supported");
    }

    public String getInputEncoding() {
        return null;
    }

    public String getNamespace(String prefix) {
        return this.mParser.getNamespace(prefix);
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespaceCount() not supported");
    }

    @Override
    public String getPositionDescription() {
        return "Binary XML file line #" + this.getLineNumber();
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        throw new XmlPullParserException("getNamespaceUri() not supported");
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getDepth() {
        return this.mParser.getDepth();
    }

    public String getText() {
        return this.mParser.getText();
    }

    public int getLineNumber() {
        return this.mParser.getLineNumber();
    }

    public int getEventType() {
        return this.mEventType;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        return this.mParser.isWhitespace();
    }

    public String getPrefix() {
        throw new RuntimeException("getPrefix not supported");
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        String txt = this.getText();
        char[] chars = null;
        if (txt != null) {
            holderForStartAndLength[0] = 0;
            holderForStartAndLength[1] = txt.length();
            chars = new char[txt.length()];
            txt.getChars(0, txt.length(), chars, 0);
        }
        return chars;
    }

    public String getNamespace() {
        return this.mParser.getNamespace();
    }

    public String getName() {
        return this.mParser.getName();
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.mParser.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeName(int index) {
        return this.mParser.getAttributeName(index);
    }

    public String getAttributePrefix(int index) {
        throw new RuntimeException("getAttributePrefix not supported");
    }

    public boolean isEmptyElementTag() {
        return false;
    }

    @Override
    public int getAttributeCount() {
        return this.mParser.getAttributeCount();
    }

    @Override
    public String getAttributeValue(int index) {
        return this.mParser.getAttributeValue(index);
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        return this.mParser.getAttributeValue(namespace, name);
    }

    public int next() throws XmlPullParserException, IOException {
        if (!this.mStarted) {
            this.mStarted = true;
            return 0;
        }
        int ev = this.mParser.next();
        while (ev == 4 && this.mParser.isWhitespace()) {
            ev = this.mParser.next();
        }
        if (ev == 3 && this.mParser.getDepth() == 1) {
            this.ensurePopped();
        }
        this.mEventType = ev;
        return ev;
    }

    private static String eventTypeToString(int eventType) {
        return switch (eventType) {
            case 0 -> "START_DOC";
            case 1 -> "END_DOC";
            case 2 -> "START_TAG";
            case 3 -> "END_TAG";
            case 4 -> "TEXT";
            case 5 -> "CDSECT";
            case 6 -> "ENTITY_REF";
            case 7 -> "IGNORABLE_WHITESPACE";
            case 8 -> "PROCESSING_INSTRUCTION";
            case 9 -> "COMMENT";
            case 10 -> "DOCDECL";
            default -> "????";
        };
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException("expected " + TYPES[type] + this.getPositionDescription());
        }
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG to read next text", (XmlPullParser)this, null);
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException(this.getPositionDescription() + ": event TEXT it must be immediately followed by END_TAG", (XmlPullParser)this, null);
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG or TEXT to read text", (XmlPullParser)this, null);
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException(this.getPositionDescription() + ": expected start or end tag", (XmlPullParser)this, null);
        }
        return eventType;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean getAttributeBooleanValue(int index, boolean defaultValue) {
        return this.mAttrib.getAttributeBooleanValue(index, defaultValue);
    }

    @Override
    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        return this.mAttrib.getAttributeBooleanValue(namespace, attribute, defaultValue);
    }

    @Override
    public float getAttributeFloatValue(int index, float defaultValue) {
        return this.mAttrib.getAttributeFloatValue(index, defaultValue);
    }

    @Override
    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        return this.mAttrib.getAttributeFloatValue(namespace, attribute, defaultValue);
    }

    @Override
    public int getAttributeIntValue(int index, int defaultValue) {
        return this.mAttrib.getAttributeIntValue(index, defaultValue);
    }

    @Override
    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        return this.mAttrib.getAttributeIntValue(namespace, attribute, defaultValue);
    }

    @Override
    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        return this.mAttrib.getAttributeListValue(index, options, defaultValue);
    }

    @Override
    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        return this.mAttrib.getAttributeListValue(namespace, attribute, options, defaultValue);
    }

    @Override
    public int getAttributeNameResource(int index) {
        return this.mAttrib.getAttributeNameResource(index);
    }

    @Override
    public int getAttributeResourceValue(int index, int defaultValue) {
        return this.mAttrib.getAttributeResourceValue(index, defaultValue);
    }

    @Override
    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        return this.mAttrib.getAttributeResourceValue(namespace, attribute, defaultValue);
    }

    @Override
    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        return this.mAttrib.getAttributeUnsignedIntValue(index, defaultValue);
    }

    @Override
    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        return this.mAttrib.getAttributeUnsignedIntValue(namespace, attribute, defaultValue);
    }

    @Override
    public String getClassAttribute() {
        return this.mAttrib.getClassAttribute();
    }

    @Override
    public String getIdAttribute() {
        return this.mAttrib.getIdAttribute();
    }

    @Override
    public int getIdAttributeResourceValue(int defaultValue) {
        return this.mAttrib.getIdAttributeResourceValue(defaultValue);
    }

    @Override
    public int getStyleAttribute() {
        return this.mAttrib.getStyleAttribute();
    }

    @Override
    @Nullable
    public ResourceValue getResolvedAttributeValue(@Nullable String namespace, @NonNull String name) {
        return this.mAttrib.getResolvedAttributeValue(namespace, name);
    }
}

