/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntMap;

public class IntegerExpressionEvaluator {
    @NonNull
    static IntMap<String> sNames = new IntMap();
    public static final int OFFSET = 65536;
    public static final int I_ADD = 65537;
    public static final int I_SUB = 65538;
    public static final int I_MUL = 65539;
    public static final int I_DIV = 65540;
    public static final int I_MOD = 65541;
    public static final int I_SHL = 65542;
    public static final int I_SHR = 65543;
    public static final int I_USHR = 65544;
    public static final int I_OR = 65545;
    public static final int I_AND = 65546;
    public static final int I_XOR = 65547;
    public static final int I_COPY_SIGN = 65548;
    public static final int I_MIN = 65549;
    public static final int I_MAX = 65550;
    public static final int I_NEG = 65551;
    public static final int I_ABS = 65552;
    public static final int I_INCR = 65553;
    public static final int I_DECR = 65554;
    public static final int I_NOT = 65555;
    public static final int I_SIGN = 65556;
    public static final int I_CLAMP = 65557;
    public static final int I_IFELSE = 65558;
    public static final int I_MAD = 65559;
    public static final float LAST_OP = 25.0f;
    public static final int I_VAR1 = 65560;
    public static final int I_VAR2 = 65561;
    @NonNull
    int[] mStack = new int[0];
    @NonNull
    int[] mLocalStack = new int[128];
    @NonNull
    int[] mVar = new int[0];
    private static final int OP_ADD = 65537;
    private static final int OP_SUB = 65538;
    private static final int OP_MUL = 65539;
    private static final int OP_DIV = 65540;
    private static final int OP_MOD = 65541;
    private static final int OP_SHL = 65542;
    private static final int OP_SHR = 65543;
    private static final int OP_USHR = 65544;
    private static final int OP_OR = 65545;
    private static final int OP_AND = 65546;
    private static final int OP_XOR = 65547;
    private static final int OP_COPY_SIGN = 65548;
    private static final int OP_MIN = 65549;
    private static final int OP_MAX = 65550;
    private static final int OP_NEG = 65551;
    private static final int OP_ABS = 65552;
    private static final int OP_INCR = 65553;
    private static final int OP_DECR = 65554;
    private static final int OP_NOT = 65555;
    private static final int OP_SIGN = 65556;
    private static final int OP_CLAMP = 65557;
    private static final int OP_TERNARY_CONDITIONAL = 65558;
    private static final int OP_MAD = 65559;
    private static final int OP_FIRST_VAR = 65560;
    private static final int OP_SECOND_VAR = 65561;
    private static final int OP_THIRD_VAR = 65562;
    static final int[] NO_OF_OPS;

    public int eval(int mask, @NonNull int[] exp, int ... var) {
        this.mStack = exp;
        this.mVar = var;
        int sp = -1;
        for (int i = 0; i < this.mStack.length; ++i) {
            int v = this.mStack[i];
            if ((1 << i & mask) != 0) {
                sp = this.opEval(sp, v);
                continue;
            }
            this.mStack[++sp] = v;
        }
        return this.mStack[sp];
    }

    public int eval(int mask, @NonNull int[] exp, int len, int ... var) {
        System.arraycopy(exp, 0, this.mLocalStack, 0, len);
        this.mStack = this.mLocalStack;
        this.mVar = var;
        int sp = -1;
        for (int i = 0; i < len; ++i) {
            int v = this.mStack[i];
            if ((1 << i & mask) != 0) {
                sp = this.opEval(sp, v);
                continue;
            }
            this.mStack[++sp] = v;
        }
        return this.mStack[sp];
    }

    public int evalDB(int opMask, @NonNull int[] exp, int ... var) {
        this.mStack = exp;
        this.mVar = var;
        int sp = -1;
        for (int i = 0; i < exp.length; ++i) {
            int v = this.mStack[i];
            if ((1 << i & opMask) != 0) {
                sp = this.opEval(sp, v);
                continue;
            }
            this.mStack[++sp] = v;
        }
        return this.mStack[sp];
    }

    int opEval(int sp, int id2) {
        switch (id2) {
            case 65537: {
                this.mStack[sp - 1] = this.mStack[sp - 1] + this.mStack[sp];
                return sp - 1;
            }
            case 65538: {
                this.mStack[sp - 1] = this.mStack[sp - 1] - this.mStack[sp];
                return sp - 1;
            }
            case 65539: {
                this.mStack[sp - 1] = this.mStack[sp - 1] * this.mStack[sp];
                return sp - 1;
            }
            case 65540: {
                this.mStack[sp - 1] = this.mStack[sp - 1] / this.mStack[sp];
                return sp - 1;
            }
            case 65541: {
                this.mStack[sp - 1] = this.mStack[sp - 1] % this.mStack[sp];
                return sp - 1;
            }
            case 65542: {
                this.mStack[sp - 1] = this.mStack[sp - 1] << this.mStack[sp];
                return sp - 1;
            }
            case 65543: {
                this.mStack[sp - 1] = this.mStack[sp - 1] >> this.mStack[sp];
                return sp - 1;
            }
            case 65544: {
                this.mStack[sp - 1] = this.mStack[sp - 1] >>> this.mStack[sp];
                return sp - 1;
            }
            case 65545: {
                this.mStack[sp - 1] = this.mStack[sp - 1] | this.mStack[sp];
                return sp - 1;
            }
            case 65546: {
                this.mStack[sp - 1] = this.mStack[sp - 1] & this.mStack[sp];
                return sp - 1;
            }
            case 65547: {
                this.mStack[sp - 1] = this.mStack[sp - 1] ^ this.mStack[sp];
                return sp - 1;
            }
            case 65548: {
                this.mStack[sp - 1] = (this.mStack[sp - 1] ^ this.mStack[sp] >> 31) - (this.mStack[sp] >> 31);
                return sp - 1;
            }
            case 65549: {
                this.mStack[sp - 1] = Math.min(this.mStack[sp - 1], this.mStack[sp]);
                return sp - 1;
            }
            case 65550: {
                this.mStack[sp - 1] = Math.max(this.mStack[sp - 1], this.mStack[sp]);
                return sp - 1;
            }
            case 65551: {
                this.mStack[sp] = -this.mStack[sp];
                return sp;
            }
            case 65552: {
                this.mStack[sp] = Math.abs(this.mStack[sp]);
                return sp;
            }
            case 65553: {
                this.mStack[sp] = this.mStack[sp] + 1;
                return sp;
            }
            case 65554: {
                this.mStack[sp] = this.mStack[sp] - 1;
                return sp;
            }
            case 65555: {
                this.mStack[sp] = ~this.mStack[sp];
                return sp;
            }
            case 65556: {
                this.mStack[sp] = this.mStack[sp] >> 31 | -this.mStack[sp] >>> 31;
                return sp;
            }
            case 65557: {
                this.mStack[sp - 2] = Math.min(Math.max(this.mStack[sp - 2], this.mStack[sp]), this.mStack[sp - 1]);
                return sp - 2;
            }
            case 65558: {
                this.mStack[sp - 2] = this.mStack[sp] > 0 ? this.mStack[sp - 1] : this.mStack[sp - 2];
                return sp - 2;
            }
            case 65559: {
                this.mStack[sp - 2] = this.mStack[sp] + this.mStack[sp - 1] * this.mStack[sp - 2];
                return sp - 2;
            }
            case 65560: {
                this.mStack[sp] = this.mVar[0];
                return sp;
            }
            case 65561: {
                this.mStack[sp] = this.mVar[1];
                return sp;
            }
            case 65562: {
                this.mStack[sp] = this.mVar[2];
                return sp;
            }
        }
        return 0;
    }

    @Nullable
    public static String toMathName(int f) {
        int id2 = f - 65536;
        return sNames.get(id2);
    }

    @NonNull
    public static String toString(int opMask, @NonNull int[] exp, @NonNull String[] labels) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < exp.length; ++i) {
            int v = exp[i];
            if ((1 << i & opMask) != 0) {
                if (v < 65536) {
                    s.append(IntegerExpressionEvaluator.toMathName(v));
                } else {
                    s.append("[");
                    s.append(v);
                    s.append("]");
                }
            } else {
                if (labels[i] != null) {
                    s.append(labels[i]);
                }
                s.append(v);
            }
            s.append(" ");
        }
        return s.toString();
    }

    @NonNull
    public static String toString(int opMask, @NonNull int[] exp) {
        StringBuilder s = new StringBuilder();
        s.append(Integer.toBinaryString(opMask));
        s.append(" : ");
        for (int i = 0; i < exp.length; ++i) {
            int v = exp[i];
            if ((1 << i & opMask) != 0) {
                if (v > 65536) {
                    s.append(" ");
                    s.append(IntegerExpressionEvaluator.toMathName(v));
                    s.append(" ");
                } else {
                    s.append("[");
                    s.append(v);
                    s.append("]");
                }
            }
            s.append(" " + v);
        }
        return s.toString();
    }

    @NonNull
    public static String toStringInfix(int opMask, @NonNull int[] exp) {
        return IntegerExpressionEvaluator.toString(opMask, exp, exp.length - 1);
    }

    @NonNull
    static String toString(int mask, int[] exp, int sp) {
        if ((1 << sp & mask) != 0) {
            int id2 = exp[sp] - 65536;
            switch (NO_OF_OPS[id2]) {
                case -1: {
                    return "nop";
                }
                case 1: {
                    return sNames.get(id2) + "(" + IntegerExpressionEvaluator.toString(mask, exp, sp - 1) + ") ";
                }
                case 2: {
                    if (IntegerExpressionEvaluator.infix(id2)) {
                        return "(" + IntegerExpressionEvaluator.toString(mask, exp, sp - 2) + " " + sNames.get(id2) + " " + IntegerExpressionEvaluator.toString(mask, exp, sp - 1) + ") ";
                    }
                    return sNames.get(id2) + "(" + IntegerExpressionEvaluator.toString(mask, exp, sp - 2) + ", " + IntegerExpressionEvaluator.toString(mask, exp, sp - 1) + ")";
                }
                case 3: {
                    if (IntegerExpressionEvaluator.infix(id2)) {
                        return "((" + IntegerExpressionEvaluator.toString(mask, exp, sp + 3) + ") ? " + IntegerExpressionEvaluator.toString(mask, exp, sp - 2) + ":" + IntegerExpressionEvaluator.toString(mask, exp, sp - 1) + ")";
                    }
                    return sNames.get(id2) + "(" + IntegerExpressionEvaluator.toString(mask, exp, sp - 3) + ", " + IntegerExpressionEvaluator.toString(mask, exp, sp - 2) + ", " + IntegerExpressionEvaluator.toString(mask, exp, sp - 1) + ")";
                }
            }
        }
        return Integer.toString(exp[sp]);
    }

    static boolean infix(int n) {
        return n < 12;
    }

    public static boolean isOperation(int opMask, int i) {
        return (1 << i & opMask) != 0;
    }

    static {
        int k = 0;
        sNames.put(k++, "NOP");
        sNames.put(k++, "+");
        sNames.put(k++, "-");
        sNames.put(k++, "*");
        sNames.put(k++, "/");
        sNames.put(k++, "%");
        sNames.put(k++, "<<");
        sNames.put(k++, ">>");
        sNames.put(k++, ">>>");
        sNames.put(k++, "|");
        sNames.put(k++, "&");
        sNames.put(k++, "^");
        sNames.put(k++, "copySign");
        sNames.put(k++, "min");
        sNames.put(k++, "max");
        sNames.put(k++, "neg");
        sNames.put(k++, "abs");
        sNames.put(k++, "incr");
        sNames.put(k++, "decr");
        sNames.put(k++, "not");
        sNames.put(k++, "sign");
        sNames.put(k++, "clamp");
        sNames.put(k++, "ifElse");
        sNames.put(k++, "mad");
        sNames.put(k++, "ceil");
        sNames.put(k++, "a[0]");
        sNames.put(k++, "a[1]");
        sNames.put(k++, "a[2]");
        NO_OF_OPS = new int[]{-1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 3, 3, 3, 0, 0, 0};
    }

    static interface Op {
        public int eval(int var1);
    }
}

