/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.TouchExpression;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.DecoratorComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.ListActionsOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.RootLayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.ScrollDelegate;
import com.android.internal.widget.remotecompose.core.operations.layout.TouchHandler;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.semantics.ScrollableComponent;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class ScrollModifierOperation
extends ListActionsOperation
implements TouchHandler,
DecoratorComponent,
ScrollDelegate,
VariableSupport,
ScrollableComponent {
    private static final int OP_CODE = 226;
    public static final String CLASS_NAME = "ScrollModifierOperation";
    private final float mPositionExpression;
    private final float mMax;
    private final float mNotchMax;
    int mDirection;
    float mTouchDownX;
    float mTouchDownY;
    float mInitialScrollX;
    float mInitialScrollY;
    float mScrollX;
    float mScrollY;
    float mMaxScrollX;
    float mMaxScrollY;
    float mHostDimension;
    float mContentDimension;
    private TouchExpression mTouchExpression;

    public ScrollModifierOperation(int direction, float position, float max, float notchMax) {
        super("SCROLL_MODIFIER");
        this.mDirection = direction;
        this.mPositionExpression = position;
        this.mMax = max;
        this.mNotchMax = notchMax;
    }

    public void inflate(Component component) {
        for (Operation op : this.mList) {
            if (!(op instanceof TouchExpression)) continue;
            this.mTouchExpression = (TouchExpression)op;
            this.mTouchExpression.setComponent(component);
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (this.mTouchExpression != null) {
            this.mTouchExpression.registerListening(context);
        }
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (this.mTouchExpression != null) {
            this.mTouchExpression.updateVariables(context);
        }
    }

    public boolean isVerticalScroll() {
        return this.mDirection == 0;
    }

    public boolean isHorizontalScroll() {
        return this.mDirection != 0;
    }

    public float getScrollX() {
        return this.mScrollX;
    }

    public float getScrollY() {
        return this.mScrollY;
    }

    @Override
    public void apply(RemoteContext context) {
        RootLayoutComponent root = context.getDocument().getRootLayoutComponent();
        if (root != null) {
            root.setHasTouchListeners(true);
        }
        super.apply(context);
    }

    @Override
    public void write(WireBuffer buffer) {
        ScrollModifierOperation.apply(buffer, this.mDirection, this.mPositionExpression, this.mMax, this.mNotchMax);
    }

    @Override
    public void serializeToString(int indent, StringSerializer serializer) {
        serializer.append(indent, "SCROLL = [" + this.mDirection + "]");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(PaintContext context) {
        for (Operation op : this.mList) {
            op.apply(context.getContext());
        }
        if (this.mTouchExpression == null) {
            return;
        }
        float position = context.getContext().mRemoteComposeState.getFloat(Utils.idFromNan(this.mPositionExpression));
        if (this.mDirection == 0) {
            this.mScrollY = -position;
        } else {
            this.mScrollX = -position;
        }
    }

    @Override
    public String toString() {
        return "ScrollModifierOperation(" + this.mDirection + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 226;
    }

    public static void apply(WireBuffer buffer, int direction, float position, float max, float notchMax) {
        buffer.start(226);
        buffer.writeInt(direction);
        buffer.writeFloat(position);
        buffer.writeFloat(max);
        buffer.writeFloat(notchMax);
    }

    public static void read(WireBuffer buffer, List<Operation> operations) {
        int direction = buffer.readInt();
        float position = buffer.readFloat();
        float max = buffer.readFloat();
        float notchMax = buffer.readFloat();
        operations.add(new ScrollModifierOperation(direction, position, max, notchMax));
    }

    public static void documentation(DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 226, CLASS_NAME).description("define a Scroll Modifier").field(0, "direction", "");
    }

    private float getMaxScrollPosition(Component component, int direction) {
        LayoutComponent layoutComponent;
        int numChildren;
        if (component instanceof LayoutComponent && (numChildren = (layoutComponent = (LayoutComponent)component).getChildrenComponents().size()) > 0) {
            Component lastChild = layoutComponent.getChildrenComponents().get(numChildren - 1);
            if (direction == 0) {
                return lastChild.getY();
            }
            return lastChild.getX();
        }
        return 0.0f;
    }

    @Override
    public void layout(RemoteContext context, Component component, float width, float height) {
        float maxScrollPosition;
        this.mWidth = width;
        this.mHeight = height;
        float max = this.mMaxScrollY;
        if (this.mDirection != 0) {
            max = this.mMaxScrollX;
        }
        if (this.mTouchExpression != null && (maxScrollPosition = this.getMaxScrollPosition(component, this.mDirection)) > 0.0f) {
            max = maxScrollPosition;
        }
        context.loadFloat(Utils.idFromNan(this.mMax), max);
        context.loadFloat(Utils.idFromNan(this.mNotchMax), this.mContentDimension);
    }

    @Override
    public void onTouchDown(RemoteContext context, CoreDocument document, Component component, float x, float y) {
        this.mTouchDownX = x;
        this.mTouchDownY = y;
        this.mInitialScrollX = this.mScrollX;
        this.mInitialScrollY = this.mScrollY;
        if (this.mTouchExpression != null) {
            this.mTouchExpression.updateVariables(context);
            this.mTouchExpression.touchDown(context, x + this.mScrollX, y + this.mScrollY);
        }
        document.appliedTouchOperation(component);
    }

    @Override
    public void onTouchUp(RemoteContext context, CoreDocument document, Component component, float x, float y, float dx, float dy) {
        if (this.mTouchExpression != null) {
            this.mTouchExpression.updateVariables(context);
            this.mTouchExpression.touchUp(context, x + this.mScrollX, y + this.mScrollY, dx, dy);
        }
    }

    @Override
    public void onTouchDrag(RemoteContext context, CoreDocument document, Component component, float x, float y) {
        if (this.mTouchExpression != null) {
            this.mTouchExpression.updateVariables(context);
            this.mTouchExpression.touchDrag(context, x + this.mScrollX, y + this.mScrollY);
        }
        float dx = x - this.mTouchDownX;
        float dy = y - this.mTouchDownY;
        if (!Utils.isVariable(this.mPositionExpression)) {
            if (this.mDirection == 0) {
                this.mScrollY = Math.max(-this.mMaxScrollY, Math.min(0.0f, this.mInitialScrollY + dy));
            } else {
                this.mScrollX = Math.max(-this.mMaxScrollX, Math.min(0.0f, this.mInitialScrollX + dx));
            }
        }
    }

    @Override
    public void onTouchCancel(RemoteContext context, CoreDocument document, Component component, float x, float y) {
    }

    public void setHorizontalScrollDimension(float hostDimension, float contentDimension) {
        this.mHostDimension = hostDimension;
        this.mContentDimension = contentDimension;
        this.mMaxScrollX = contentDimension - hostDimension;
    }

    public void setVerticalScrollDimension(float hostDimension, float contentDimension) {
        this.mHostDimension = hostDimension;
        this.mContentDimension = contentDimension;
        this.mMaxScrollY = contentDimension - hostDimension;
    }

    public float getContentDimension() {
        return this.mContentDimension;
    }

    @Override
    public float getScrollX(float currentValue) {
        if (this.mDirection == 1) {
            return this.mScrollX;
        }
        return 0.0f;
    }

    @Override
    public float getScrollY(float currentValue) {
        if (this.mDirection == 0) {
            return this.mScrollY;
        }
        return 0.0f;
    }

    @Override
    public boolean handlesHorizontalScroll() {
        return this.mDirection == 1;
    }

    @Override
    public boolean handlesVerticalScroll() {
        return this.mDirection == 0;
    }

    @Override
    public void reset() {
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("direction", this.mDirection).add("max", Float.valueOf(this.mMax)).add("notchMax", Float.valueOf(this.mNotchMax)).add("scrollValue", Float.valueOf(this.isVerticalScroll() ? this.mScrollY : this.mScrollX)).add("maxScrollValue", Float.valueOf(this.isVerticalScroll() ? this.mMaxScrollY : this.mMaxScrollX)).add("contentDimension", Float.valueOf(this.mContentDimension)).add("hostDimension", Float.valueOf(this.mHostDimension));
    }

    @Override
    public int scrollDirection() {
        if (this.handlesVerticalScroll()) {
            return 2;
        }
        return 1;
    }

    @Override
    public int scrollByOffset(RemoteContext context, int offset) {
        this.mTouchExpression = null;
        if (this.handlesVerticalScroll()) {
            this.mScrollY = Math.max(-this.mMaxScrollY, Math.min(0.0f, this.mScrollY + (float)offset));
        } else {
            this.mScrollX = Math.max(-this.mMaxScrollX, Math.min(0.0f, this.mScrollX + (float)offset));
        }
        return offset;
    }

    @Override
    public boolean scrollDirection(RemoteContext context, ScrollableComponent.ScrollDirection direction) {
        float offset = this.mHostDimension * 0.7f;
        if (direction == ScrollableComponent.ScrollDirection.FORWARD || direction == ScrollableComponent.ScrollDirection.DOWN || direction == ScrollableComponent.ScrollDirection.RIGHT) {
            offset *= -1.0f;
        }
        return this.scrollByOffset(context, (int)offset) != 0;
    }

    @Override
    public boolean showOnScreen(RemoteContext context, Component child) {
        float[] locationInWindow = new float[2];
        child.getLocationInWindow(locationInWindow);
        int offset = 0;
        offset = this.handlesVerticalScroll() ? (int)(-locationInWindow[1]) : (int)(-locationInWindow[0]);
        if (offset == 0) {
            return true;
        }
        return this.scrollByOffset(context, offset) != 0;
    }

    @Override
    @Nullable
    public ScrollableComponent.ScrollAxisRange getScrollAxisRange() {
        if (this.handlesVerticalScroll()) {
            return new ScrollableComponent.ScrollAxisRange(this.mScrollY, this.mMaxScrollY, true, true);
        }
        return new ScrollableComponent.ScrollAxisRange(this.mScrollX, this.mMaxScrollX, true, true);
    }
}

