/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class PaddingModifierOperation
extends Operation
implements ModifierOperation {
    private static final int OP_CODE = 58;
    public static final String CLASS_NAME = "PaddingModifierOperation";
    float mLeft;
    float mTop;
    float mRight;
    float mBottom;

    public PaddingModifierOperation(float left, float top, float right, float bottom) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
    }

    public float getLeft() {
        return this.mLeft;
    }

    public float getTop() {
        return this.mTop;
    }

    public float getRight() {
        return this.mRight;
    }

    public float getBottom() {
        return this.mBottom;
    }

    public void setLeft(float left) {
        this.mLeft = left;
    }

    public void setTop(float top) {
        this.mTop = top;
    }

    public void setRight(float right) {
        this.mRight = right;
    }

    public void setBottom(float bottom) {
        this.mBottom = bottom;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        PaddingModifierOperation.apply(buffer, this.mLeft, this.mTop, this.mRight, this.mBottom);
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "PADDING = [" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "]");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @NonNull
    public String toString() {
        return "PaddingModifierOperation(" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 58;
    }

    public static void apply(@NonNull WireBuffer buffer, float left, float top, float right, float bottom) {
        buffer.start(58);
        buffer.writeFloat(left);
        buffer.writeFloat(top);
        buffer.writeFloat(right);
        buffer.writeFloat(bottom);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        float left = buffer.readFloat();
        float top = buffer.readFloat();
        float right = buffer.readFloat();
        float bottom = buffer.readFloat();
        operations.add(new PaddingModifierOperation(left, top, right, bottom));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 58, CLASS_NAME).description("define the Padding Modifier").field(1, "left", "").field(1, "top", "").field(1, "right", "").field(1, "bottom", "");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("left", Float.valueOf(this.mLeft)).add("top", Float.valueOf(this.mTop)).add("right", Float.valueOf(this.mRight)).add("bottom", Float.valueOf(this.mBottom));
    }
}

