/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.Platform;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.LayoutManager;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Size;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class TextLayout
extends LayoutManager
implements VariableSupport,
AccessibleComponent {
    public static final int TEXT_ALIGN_LEFT = 1;
    public static final int TEXT_ALIGN_RIGHT = 2;
    public static final int TEXT_ALIGN_CENTER = 3;
    public static final int TEXT_ALIGN_JUSTIFY = 4;
    public static final int TEXT_ALIGN_START = 5;
    public static final int TEXT_ALIGN_END = 6;
    public static final int OVERFLOW_CLIP = 1;
    public static final int OVERFLOW_VISIBLE = 2;
    public static final int OVERFLOW_ELLIPSIS = 3;
    public static final int OVERFLOW_START_ELLIPSIS = 4;
    public static final int OVERFLOW_MIDDLE_ELLIPSIS = 5;
    private static final boolean DEBUG = false;
    private int mTextId = -1;
    private int mColor = 0;
    private float mFontSize = 16.0f;
    private int mFontStyle = 0;
    private float mFontWeight = 400.0f;
    private int mFontFamilyId = -1;
    private int mTextAlign = -1;
    private int mOverflow = 1;
    private int mMaxLines = Integer.MAX_VALUE;
    private int mType = -1;
    private float mTextX;
    private float mTextY;
    private float mTextW = -1.0f;
    private float mTextH = -1.0f;
    private final Size mCachedSize = new Size(0.0f, 0.0f);
    @Nullable
    private String mCachedString = "";
    @Nullable
    private String mNewString;
    Platform.ComputedTextLayout mComputedTextLayout;
    @NonNull
    public PaintBundle mPaint = new PaintBundle();

    @Override
    @Nullable
    public Integer getTextId() {
        return this.mTextId;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (this.mTextId != -1) {
            context.listensTo(this.mTextId, this);
        }
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        String cachedString = context.getText(this.mTextId);
        if (cachedString != null && cachedString.equalsIgnoreCase(this.mCachedString)) {
            return;
        }
        this.mNewString = cachedString;
        if (this.mType == -1) {
            if (this.mFontFamilyId != -1) {
                String fontFamily = context.getText(this.mFontFamilyId);
                if (fontFamily != null) {
                    this.mType = 0;
                    if (fontFamily.equalsIgnoreCase("default")) {
                        this.mType = 0;
                    } else if (fontFamily.equalsIgnoreCase("sans-serif")) {
                        this.mType = 1;
                    } else if (fontFamily.equalsIgnoreCase("serif")) {
                        this.mType = 2;
                    } else if (fontFamily.equalsIgnoreCase("monospace")) {
                        this.mType = 3;
                    }
                }
            } else {
                this.mType = 0;
            }
        }
        if (this.mHorizontalScrollDelegate != null) {
            this.mHorizontalScrollDelegate.reset();
        }
        if (this.mVerticalScrollDelegate != null) {
            this.mVerticalScrollDelegate.reset();
        }
        this.invalidateMeasure();
    }

    public TextLayout(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height, int textId, int color2, float fontSize, int fontStyle, float fontWeight, int fontFamilyId, int textAlign, int overflow, int maxLines) {
        super(parent, componentId, animationId, x, y, width, height);
        this.mTextId = textId;
        this.mColor = color2;
        this.mFontSize = fontSize;
        this.mFontStyle = fontStyle;
        this.mFontWeight = fontWeight;
        this.mFontFamilyId = fontFamilyId;
        this.mTextAlign = textAlign;
        this.mOverflow = overflow;
        this.mMaxLines = maxLines;
    }

    public TextLayout(@Nullable Component parent, int componentId, int animationId, int textId, int color2, float fontSize, int fontStyle, float fontWeight, int fontFamilyId, int textAlign, int overflow, int maxLines) {
        this(parent, componentId, animationId, 0.0f, 0.0f, 0.0f, 0.0f, textId, color2, fontSize, fontStyle, fontWeight, fontFamilyId, textAlign, overflow, maxLines);
    }

    @Override
    public void paintingComponent(@NonNull PaintContext context) {
        Component prev = context.getContext().mLastComponent;
        RemoteContext remoteContext = context.getContext();
        remoteContext.mLastComponent = this;
        context.save();
        context.translate(this.mX, this.mY);
        if (this.mGraphicsLayerModifier != null) {
            context.startGraphicsLayer((int)this.getWidth(), (int)this.getHeight());
            this.mCachedAttributes.clear();
            this.mGraphicsLayerModifier.fillInAttributes(this.mCachedAttributes);
            context.setGraphicsLayer(this.mCachedAttributes);
        }
        this.mComponentModifiers.paint(context);
        float tx = this.mPaddingLeft;
        float ty = this.mPaddingTop;
        context.translate(tx, ty);
        context.savePaint();
        this.mPaint.reset();
        this.mPaint.setStyle(0);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setTextSize(this.mFontSize);
        this.mPaint.setTextStyle(this.mType, (int)this.mFontWeight, this.mFontStyle == 1);
        context.replacePaint(this.mPaint);
        if (this.mCachedString == null) {
            return;
        }
        int length = this.mCachedString.length();
        if (this.mComputedTextLayout != null) {
            context.drawComplexText(this.mComputedTextLayout);
        } else {
            float px = this.mTextX;
            switch (this.mTextAlign) {
                case 3: {
                    px = (this.mWidth - this.mPaddingLeft - this.mPaddingRight - this.mTextW) / 2.0f;
                    break;
                }
                case 2: 
                case 6: {
                    px = this.mWidth - this.mPaddingLeft - this.mPaddingRight - this.mTextW;
                    break;
                }
            }
            if (this.mTextW > this.mWidth - this.mPaddingLeft - this.mPaddingRight) {
                context.save();
                context.clipRect(0.0f, 0.0f, this.mWidth - this.mPaddingLeft - this.mPaddingRight, this.mHeight - this.mPaddingTop - this.mPaddingBottom);
                context.translate(this.getScrollX(), this.getScrollY());
                context.drawTextRun(this.mTextId, 0, length, 0, 0, px, this.mTextY, false);
                context.restore();
            } else {
                context.drawTextRun(this.mTextId, 0, length, 0, 0, px, this.mTextY, false);
            }
        }
        context.restorePaint();
        if (this.mGraphicsLayerModifier != null) {
            context.endGraphicsLayer();
        }
        context.translate(-tx, -ty);
        context.restore();
        context.getContext().mLastComponent = prev;
    }

    @Override
    @NonNull
    public String toString() {
        return "TEXT_LAYOUT [" + this.mComponentId + ":" + this.mAnimationId + "] (" + this.mX + ", " + this.mY + " - " + this.mWidth + " x " + this.mHeight + ") " + Component.Visibility.toString(this.mVisibility);
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "TEXT_LAYOUT";
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, this.getSerializedName() + " [" + this.mComponentId + ":" + this.mAnimationId + "] = [" + this.mX + ", " + this.mY + ", " + this.mWidth + ", " + this.mHeight + "] " + Component.Visibility.toString(this.mVisibility) + " (" + this.mTextId + ":\"" + this.mCachedString + "\")");
    }

    @Override
    public void computeSize(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        super.computeSize(context, minWidth, maxWidth, minHeight, maxHeight, measure);
        this.computeWrapSize(context, maxWidth, maxHeight, true, true, measure, this.mCachedSize);
        ComponentMeasure m = measure.get(this);
        m.setW(this.mCachedSize.getWidth());
        m.setH(this.mCachedSize.getHeight());
    }

    @Override
    public void computeWrapSize(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @NonNull Size size) {
        context.savePaint();
        this.mPaint.reset();
        this.mPaint.setTextSize(this.mFontSize);
        this.mPaint.setTextStyle(this.mType, (int)this.mFontWeight, this.mFontStyle == 1);
        this.mPaint.setColor(this.mColor);
        context.replacePaint(this.mPaint);
        float[] bounds = new float[4];
        if (this.mNewString != null && !this.mNewString.equals(this.mCachedString)) {
            this.mCachedString = this.mNewString;
        }
        if (this.mCachedString == null) {
            return;
        }
        boolean forceComplex = false;
        int flags = 6;
        if (this.mMaxLines == 1 && (this.mOverflow == 4 || this.mOverflow == 5 || this.mOverflow == 3)) {
            flags |= 8;
        }
        if ((flags & 8) != 8) {
            for (int i = 0; i < this.mCachedString.length(); ++i) {
                char c = this.mCachedString.charAt(i);
                if (c != '\n' && c != '\t') continue;
                flags |= 8;
                forceComplex = true;
                break;
            }
        }
        if (!forceComplex) {
            context.getTextBounds(this.mTextId, 0, this.mCachedString.length(), flags, bounds);
        }
        if (forceComplex || bounds[2] - bounds[1] > maxWidth && this.mMaxLines > 1 && maxWidth > 0.0f) {
            this.mComputedTextLayout = context.layoutComplexText(this.mTextId, 0, this.mCachedString.length(), this.mTextAlign, this.mOverflow, this.mMaxLines, maxWidth, flags);
            if (this.mComputedTextLayout != null) {
                bounds[0] = 0.0f;
                bounds[1] = 0.0f;
                bounds[2] = this.mComputedTextLayout.getWidth();
                bounds[3] = this.mComputedTextLayout.getHeight();
            }
        } else {
            this.mComputedTextLayout = null;
        }
        context.restorePaint();
        float w = bounds[2] - bounds[0];
        float h = bounds[3] - bounds[1];
        size.setWidth(Math.min(maxWidth, w));
        this.mTextX = -bounds[0];
        size.setHeight(Math.min(maxHeight, h));
        this.mTextY = -bounds[1];
        this.mTextW = w;
        this.mTextH = h;
    }

    @Override
    public float minIntrinsicHeight(@Nullable RemoteContext context) {
        return this.mTextH;
    }

    @Override
    public float minIntrinsicWidth(@Nullable RemoteContext context) {
        return this.mTextW;
    }

    @NonNull
    public static String name() {
        return "TextLayout";
    }

    public static int id() {
        return 208;
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId, int animationId, int textId, int color2, float fontSize, int fontStyle, float fontWeight, int fontFamilyId, int textAlign, int overflow, int maxLines) {
        buffer.start(TextLayout.id());
        buffer.writeInt(componentId);
        buffer.writeInt(animationId);
        buffer.writeInt(textId);
        buffer.writeInt(color2);
        buffer.writeFloat(fontSize);
        buffer.writeInt(fontStyle);
        buffer.writeFloat(fontWeight);
        buffer.writeInt(fontFamilyId);
        buffer.writeInt(textAlign);
        buffer.writeInt(overflow);
        buffer.writeInt(maxLines);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        int animationId = buffer.readInt();
        int textId = buffer.readInt();
        int color2 = buffer.readInt();
        float fontSize = buffer.readFloat();
        int fontStyle = buffer.readInt();
        float fontWeight = buffer.readFloat();
        int fontFamilyId = buffer.readInt();
        int textAlign = buffer.readInt();
        int overflow = buffer.readInt();
        int maxLines = buffer.readInt();
        operations.add(new TextLayout(null, componentId, animationId, textId, color2, fontSize, fontStyle, fontWeight, fontFamilyId, textAlign, overflow, maxLines));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", TextLayout.id(), TextLayout.name()).description("Text layout implementation.\n\n").field(0, "COMPONENT_ID", "unique id for this component").field(0, "ANIMATION_ID", "id used to match components, for animation purposes").field(0, "COLOR", "text color").field(1, "FONT_SIZE", "font size").field(0, "FONT_STYLE", "font style (0 = normal, 1 = italic)").field(1, "FONT_WEIGHT", "font weight (1-1000, normal = 400)").field(0, "FONT_FAMILY_ID", "font family id");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextLayout.apply(buffer, this.mComponentId, this.mAnimationId, this.mTextId, this.mColor, this.mFontSize, this.mFontStyle, this.mFontWeight, this.mFontFamilyId, this.mTextAlign, this.mOverflow, this.mMaxLines);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        super.serialize(serializer);
        serializer.add("textId", this.mTextId);
        serializer.add("color", Utils.colorInt(this.mColor));
        serializer.add("fontSize", Float.valueOf(this.mFontSize));
        serializer.add("fontStyle", this.mFontStyle);
        serializer.add("fontWeight", Float.valueOf(this.mFontWeight));
        serializer.add("fontFamilyId", this.mFontFamilyId);
        serializer.add("textAlign", this.mTextAlign);
    }
}

