/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.LayoutManager;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Size;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.HeightInModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ScrollModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.utils.DebugLog;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class ColumnLayout
extends LayoutManager {
    public static final int START = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    public static final int SPACE_BETWEEN = 6;
    public static final int SPACE_EVENLY = 7;
    public static final int SPACE_AROUND = 8;
    int mHorizontalPositioning;
    int mVerticalPositioning;
    float mSpacedBy = 0.0f;

    public ColumnLayout(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        super(parent, componentId, animationId, x, y, width, height);
        this.mHorizontalPositioning = horizontalPositioning;
        this.mVerticalPositioning = verticalPositioning;
        this.mSpacedBy = spacedBy;
    }

    public ColumnLayout(@Nullable Component parent, int componentId, int animationId, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        this(parent, componentId, animationId, 0.0f, 0.0f, 0.0f, 0.0f, horizontalPositioning, verticalPositioning, spacedBy);
    }

    @Override
    @NonNull
    public String toString() {
        return this.getSerializedName() + " [" + this.mComponentId + ":" + this.mAnimationId + "] (" + this.mX + ", " + this.mY + " - " + this.mWidth + " x " + this.mHeight + ") " + this.mVisibility;
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "COLUMN";
    }

    @Override
    public boolean isInVerticalFill() {
        return super.isInVerticalFill() || this.childrenHaveVerticalWeights();
    }

    @Override
    public void computeWrapSize(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @NonNull Size size) {
        DebugLog.s(() -> "COMPUTE WRAP SIZE in " + this + " (" + this.mComponentId + ")");
        int visibleChildrens = 0;
        float currentMaxHeight = maxHeight;
        for (Component c : this.mChildrenComponents) {
            c.measure(context, 0.0f, maxWidth, 0.0f, currentMaxHeight, measure);
            ComponentMeasure m = measure.get(c);
            if (m.isGone()) continue;
            size.setWidth(Math.max(size.getWidth(), m.getW()));
            size.setHeight(size.getHeight() + m.getH());
            ++visibleChildrens;
            currentMaxHeight -= m.getH();
        }
        if (!this.mChildrenComponents.isEmpty()) {
            size.setHeight(size.getHeight() + this.mSpacedBy * (float)(visibleChildrens - 1));
        }
        DebugLog.e();
    }

    @Override
    public void computeSize(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        DebugLog.s(() -> "COMPUTE SIZE in " + this + " (" + this.mComponentId + ")");
        float mh = maxHeight;
        for (Component child : this.mChildrenComponents) {
            child.measure(context, minWidth, maxWidth, minHeight, mh, measure);
            ComponentMeasure m = measure.get(child);
            if (m.isGone()) continue;
            mh -= m.getH();
        }
        DebugLog.e();
    }

    @Override
    public float minIntrinsicHeight(@NonNull RemoteContext context) {
        float height = this.computeModifierDefinedHeight(context);
        float componentHeights = 0.0f;
        for (Component c : this.mChildrenComponents) {
            componentHeights += c.minIntrinsicHeight(context);
        }
        return Math.max(height, componentHeights);
    }

    @Override
    public void internalLayoutMeasure(@NonNull PaintContext context, @NonNull MeasurePass measure) {
        ComponentMeasure selfMeasure = measure.get(this);
        DebugLog.s(() -> "INTERNAL LAYOUT " + this + " (" + this.mComponentId + ") children: " + this.mChildrenComponents.size() + " size (" + selfMeasure.getW() + " x " + selfMeasure.getH() + ")");
        if (this.mChildrenComponents.isEmpty()) {
            DebugLog.e();
            return;
        }
        float selfWidth = selfMeasure.getW() - this.mPaddingLeft - this.mPaddingRight;
        float selfHeight = selfMeasure.getH() - this.mPaddingTop - this.mPaddingBottom;
        float childrenWidth = 0.0f;
        float childrenHeight = 0.0f;
        if (this.mComponentModifiers.hasHorizontalScroll()) {
            selfWidth = this.mComponentModifiers.getHorizontalScrollDimension() - this.mPaddingLeft - this.mPaddingRight;
        }
        if (this.mComponentModifiers.hasVerticalScroll()) {
            selfHeight = this.mComponentModifiers.getVerticalScrollDimension() - this.mPaddingTop - this.mPaddingBottom;
        }
        boolean checkWeights = true;
        while (checkWeights) {
            checkWeights = false;
            childrenWidth = 0.0f;
            childrenHeight = 0.0f;
            boolean hasWeights = false;
            float totalWeights = 0.0f;
            for (Object child : this.mChildrenComponents) {
                ComponentMeasure childMeasure = measure.get((Component)child);
                if (childMeasure.isGone()) continue;
                if (child instanceof LayoutComponent && ((LayoutComponent)child).getHeightModifier().hasWeight()) {
                    hasWeights = true;
                    totalWeights += ((LayoutComponent)child).getHeightModifier().getValue();
                    continue;
                }
                childrenHeight += childMeasure.getH();
            }
            if (hasWeights) {
                Object child;
                float availableSpace = selfHeight - childrenHeight;
                child = this.mChildrenComponents.iterator();
                while (child.hasNext()) {
                    ComponentMeasure childMeasure;
                    Component child2 = (Component)child.next();
                    if (!(child2 instanceof LayoutComponent) || !((LayoutComponent)child2).getHeightModifier().hasWeight() || (childMeasure = measure.get(child2)).isGone()) continue;
                    float weight = ((LayoutComponent)child2).getHeightModifier().getValue();
                    float childHeight = weight * availableSpace / totalWeights;
                    HeightInModifierOperation heightInConstraints = ((LayoutComponent)child2).getHeightModifier().getHeightIn();
                    if (heightInConstraints != null) {
                        float min = heightInConstraints.getMin();
                        float max = heightInConstraints.getMax();
                        if (min != -1.0f) {
                            childHeight = Math.max(min, childHeight);
                        }
                        if (max != -1.0f) {
                            childHeight = Math.min(max, childHeight);
                        }
                    }
                    childMeasure.setH(childHeight);
                    child2.measure(context, childMeasure.getW(), childMeasure.getW(), childMeasure.getH(), childMeasure.getH(), measure);
                }
            }
            if (!this.applyVisibility(selfWidth, selfHeight, measure) || !hasWeights) continue;
            checkWeights = true;
        }
        childrenHeight = 0.0f;
        int visibleChildrens = 0;
        for (Component child : this.mChildrenComponents) {
            ComponentMeasure childMeasure = measure.get(child);
            if (childMeasure.isGone()) continue;
            childrenWidth = Math.max(childrenWidth, childMeasure.getW());
            childrenHeight += childMeasure.getH();
            ++visibleChildrens;
        }
        childrenHeight += this.mSpacedBy * (float)(visibleChildrens - 1);
        float tx = 0.0f;
        float ty = 0.0f;
        float verticalGap = 0.0f;
        float total = 0.0f;
        switch (this.mVerticalPositioning) {
            case 4: {
                ty = 0.0f;
                break;
            }
            case 2: {
                ty = (selfHeight - childrenHeight) / 2.0f;
                break;
            }
            case 5: {
                ty = selfHeight - childrenHeight;
                break;
            }
            case 6: {
                for (Component child : this.mChildrenComponents) {
                    ComponentMeasure childMeasure = measure.get(child);
                    if (childMeasure.isGone()) continue;
                    total += childMeasure.getH();
                }
                if (visibleChildrens > 1) {
                    verticalGap = (selfHeight - total) / (float)(visibleChildrens - 1);
                    break;
                }
                ty = (selfHeight - childrenHeight) / 2.0f;
                break;
            }
            case 7: {
                for (Component child : this.mChildrenComponents) {
                    ComponentMeasure childMeasure = measure.get(child);
                    if (childMeasure.isGone()) continue;
                    total += childMeasure.getH();
                }
                ty = verticalGap = (selfHeight - total) / (float)(visibleChildrens + 1);
                break;
            }
            case 8: {
                for (Component child : this.mChildrenComponents) {
                    ComponentMeasure childMeasure = measure.get(child);
                    if (childMeasure.isGone()) continue;
                    total += childMeasure.getH();
                }
                verticalGap = (selfHeight - total) / (float)visibleChildrens;
                ty = verticalGap / 2.0f;
            }
        }
        for (Component child : this.mChildrenComponents) {
            ComponentMeasure childMeasure = measure.get(child);
            switch (this.mHorizontalPositioning) {
                case 1: {
                    tx = 0.0f;
                    break;
                }
                case 2: {
                    tx = (selfWidth - childMeasure.getW()) / 2.0f;
                    break;
                }
                case 3: {
                    tx = selfWidth - childMeasure.getW();
                }
            }
            childMeasure.setX(tx);
            childMeasure.setY(ty);
            if (childMeasure.isGone()) continue;
            ty += childMeasure.getH();
            if (this.mVerticalPositioning == 6 || this.mVerticalPositioning == 8 || this.mVerticalPositioning == 7) {
                ty += verticalGap;
            }
            ty += this.mSpacedBy;
        }
        DebugLog.e();
    }

    @Override
    public void getLocationInWindow(@NonNull float[] value, boolean forSelf) {
        super.getLocationInWindow(value, forSelf);
        if (!forSelf && this.mVerticalScrollDelegate instanceof ScrollModifierOperation) {
            ScrollModifierOperation smo = (ScrollModifierOperation)this.mVerticalScrollDelegate;
            value[1] = value[1] + smo.getScrollY();
        }
    }

    @NonNull
    public static String name() {
        return "ColumnLayout";
    }

    public static int id() {
        return 204;
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId, int animationId, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        buffer.start(ColumnLayout.id());
        buffer.writeInt(componentId);
        buffer.writeInt(animationId);
        buffer.writeInt(horizontalPositioning);
        buffer.writeInt(verticalPositioning);
        buffer.writeFloat(spacedBy);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        int animationId = buffer.readInt();
        int horizontalPositioning = buffer.readInt();
        int verticalPositioning = buffer.readInt();
        float spacedBy = buffer.readFloat();
        operations.add(new ColumnLayout(null, componentId, animationId, horizontalPositioning, verticalPositioning, spacedBy));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", ColumnLayout.id(), ColumnLayout.name()).description("Column layout implementation, positioning components one after the other vertically.\n\nIt supports weight and horizontal/vertical positioning.").examplesDimension(100, 400).exampleImage("Top", "layout-ColumnLayout-start-top.png").exampleImage("Center", "layout-ColumnLayout-start-center.png").exampleImage("Bottom", "layout-ColumnLayout-start-bottom.png").exampleImage("SpaceEvenly", "layout-ColumnLayout-start-space-evenly.png").exampleImage("SpaceAround", "layout-ColumnLayout-start-space-around.png").exampleImage("SpaceBetween", "layout-ColumnLayout-start-space-between.png").field(0, "COMPONENT_ID", "unique id for this component").field(0, "ANIMATION_ID", "id used to match components, for animation purposes").field(0, "HORIZONTAL_POSITIONING", "horizontal positioning value").possibleValues("START", 1).possibleValues("CENTER", 2).possibleValues("END", 3).field(0, "VERTICAL_POSITIONING", "vertical positioning value").possibleValues("TOP", 4).possibleValues("CENTER", 2).possibleValues("BOTTOM", 5).possibleValues("SPACE_BETWEEN", 6).possibleValues("SPACE_EVENLY", 7).possibleValues("SPACE_AROUND", 8).field(1, "SPACED_BY", "Horizontal spacing between components");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ColumnLayout.apply(buffer, this.mComponentId, this.mAnimationId, this.mHorizontalPositioning, this.mVerticalPositioning, this.mSpacedBy);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        super.serialize(serializer);
        serializer.add("verticalPositioning", this.getPositioningString(this.mVerticalPositioning));
        serializer.add("horizontalPositioning", this.getPositioningString(this.mHorizontalPositioning));
        serializer.add("spacedBy", Float.valueOf(this.mSpacedBy));
    }

    private String getPositioningString(int pos) {
        switch (pos) {
            case 1: {
                return "START";
            }
            case 2: {
                return "CENTER";
            }
            case 3: {
                return "END";
            }
            case 4: {
                return "TOP";
            }
            case 5: {
                return "BOTTOM";
            }
            case 6: {
                return "SPACE_BETWEEN";
            }
            case 7: {
                return "SPACE_EVENLY";
            }
            case 8: {
                return "SPACE_AROUND";
            }
        }
        return "NONE";
    }
}

