/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.animation;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.Easing;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class AnimationSpec
extends Operation
implements ModifierOperation {
    public static final AnimationSpec DEFAULT = new AnimationSpec();
    public static final AnimationSpec DISABLED = new AnimationSpec(0);
    int mAnimationId = -1;
    float mMotionDuration = 300.0f;
    int mMotionEasingType = 1;
    float mVisibilityDuration = 300.0f;
    int mVisibilityEasingType = 1;
    @NonNull
    ANIMATION mEnterAnimation = ANIMATION.FADE_IN;
    @NonNull
    ANIMATION mExitAnimation = ANIMATION.FADE_OUT;

    public AnimationSpec(int animationId, float motionDuration, int motionEasingType, float visibilityDuration, int visibilityEasingType, @NonNull ANIMATION enterAnimation, @NonNull ANIMATION exitAnimation) {
        this.mAnimationId = animationId;
        this.mMotionDuration = motionDuration;
        this.mMotionEasingType = motionEasingType;
        this.mVisibilityDuration = visibilityDuration;
        this.mVisibilityEasingType = visibilityEasingType;
        this.mEnterAnimation = enterAnimation;
        this.mExitAnimation = exitAnimation;
    }

    public AnimationSpec() {
        this(-1, 600.0f, 1, 500.0f, 1, ANIMATION.FADE_IN, ANIMATION.FADE_OUT);
    }

    public AnimationSpec(int value) {
        this();
        this.mAnimationId = value;
    }

    public boolean isAnimationEnabled() {
        return this.mAnimationId != 0;
    }

    public int getAnimationId() {
        return this.mAnimationId;
    }

    public float getMotionDuration() {
        return this.mMotionDuration;
    }

    public int getMotionEasingType() {
        return this.mMotionEasingType;
    }

    public float getVisibilityDuration() {
        return this.mVisibilityDuration;
    }

    public int getVisibilityEasingType() {
        return this.mVisibilityEasingType;
    }

    @NonNull
    public ANIMATION getEnterAnimation() {
        return this.mEnterAnimation;
    }

    @NonNull
    public ANIMATION getExitAnimation() {
        return this.mExitAnimation;
    }

    @NonNull
    public String toString() {
        return "ANIMATION_SPEC (" + this.mMotionDuration + " ms)";
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "ANIMATION_SPEC = [" + this.getMotionDuration() + ", " + this.getMotionEasingType() + ", " + this.getVisibilityDuration() + ", " + this.getVisibilityEasingType() + ", " + (Object)((Object)this.getEnterAnimation()) + ", " + (Object)((Object)this.getExitAnimation()) + "]");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType("AnimationSpec").add("animationId", this.mAnimationId).add("motionDuration", Float.valueOf(this.getMotionDuration())).add("motionEasingType", Easing.getString(this.getMotionEasingType())).add("visibilityDuration", Float.valueOf(this.getVisibilityDuration())).add("visibilityEasingType", Easing.getString(this.getVisibilityEasingType())).add("enterAnimation", this.getEnterAnimation()).add("exitAnimation", this.getExitAnimation());
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        AnimationSpec.apply(buffer, this.mAnimationId, this.mMotionDuration, this.mMotionEasingType, this.mVisibilityDuration, this.mVisibilityEasingType, this.mEnterAnimation, this.mExitAnimation);
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @NonNull
    public static String name() {
        return "AnimationSpec";
    }

    public static int id() {
        return 14;
    }

    public static int animationToInt(@NonNull ANIMATION animation) {
        return animation.ordinal();
    }

    @NonNull
    public static ANIMATION intToAnimation(int value) {
        switch (value) {
            case 0: {
                return ANIMATION.FADE_IN;
            }
            case 1: {
                return ANIMATION.FADE_OUT;
            }
            case 2: {
                return ANIMATION.SLIDE_LEFT;
            }
            case 3: {
                return ANIMATION.SLIDE_RIGHT;
            }
            case 4: {
                return ANIMATION.SLIDE_TOP;
            }
            case 5: {
                return ANIMATION.SLIDE_BOTTOM;
            }
            case 6: {
                return ANIMATION.ROTATE;
            }
            case 7: {
                return ANIMATION.PARTICLE;
            }
        }
        return ANIMATION.FADE_IN;
    }

    public static void apply(@NonNull WireBuffer buffer, int animationId, float motionDuration, int motionEasingType, float visibilityDuration, int visibilityEasingType, @NonNull ANIMATION enterAnimation, @NonNull ANIMATION exitAnimation) {
        buffer.start(14);
        buffer.writeInt(animationId);
        buffer.writeFloat(motionDuration);
        buffer.writeInt(motionEasingType);
        buffer.writeFloat(visibilityDuration);
        buffer.writeInt(visibilityEasingType);
        buffer.writeInt(AnimationSpec.animationToInt(enterAnimation));
        buffer.writeInt(AnimationSpec.animationToInt(exitAnimation));
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int animationId = buffer.readInt();
        float motionDuration = buffer.readFloat();
        int motionEasingType = buffer.readInt();
        float visibilityDuration = buffer.readFloat();
        int visibilityEasingType = buffer.readInt();
        ANIMATION enterAnimation = AnimationSpec.intToAnimation(buffer.readInt());
        ANIMATION exitAnimation = AnimationSpec.intToAnimation(buffer.readInt());
        AnimationSpec op = new AnimationSpec(animationId, motionDuration, motionEasingType, visibilityDuration, visibilityEasingType, enterAnimation, exitAnimation);
        operations.add(op);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", AnimationSpec.id(), AnimationSpec.name()).description("define the animation").field(0, "animationId", "").field(0, "motionDuration", "").field(0, "motionEasingType", "").field(0, "visibilityDuration", "").field(0, "visibilityEasingType", "");
    }

    public static enum ANIMATION {
        FADE_IN,
        FADE_OUT,
        SLIDE_LEFT,
        SLIDE_RIGHT,
        SLIDE_TOP,
        SLIDE_BOTTOM,
        ROTATE,
        PARTICLE;

    }
}

