/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.operations.TextData;
import com.android.internal.widget.remotecompose.core.operations.layout.ActionOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.operations.layout.DecoratorComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.ArrayList;
import java.util.Vector;

public abstract class ListActionsOperation
extends PaintOperation
implements Container,
ModifierOperation,
DecoratorComponent {
    String mOperationName;
    protected float mWidth = 0.0f;
    protected float mHeight = 0.0f;
    private final float[] mLocationInWindow = new float[2];
    public ArrayList<Operation> mList = new ArrayList();

    public ListActionsOperation(String operationName) {
        this.mOperationName = operationName;
    }

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }

    public String toString() {
        return this.mOperationName;
    }

    @Override
    public void apply(RemoteContext context) {
        for (Operation op : this.mList) {
            if (!(op instanceof TextData)) continue;
            op.apply(context);
            context.incrementOpCount();
        }
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(PaintContext context) {
    }

    @Override
    public void layout(RemoteContext context, Component component, float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void serializeToString(int indent, StringSerializer serializer) {
        serializer.append(indent, this.mOperationName);
        for (Operation o : this.mList) {
            if (!(o instanceof ActionOperation)) continue;
            ((ActionOperation)((Object)o)).serializeToString(indent + 1, serializer);
        }
    }

    public boolean applyActions(RemoteContext context, CoreDocument document, Component component, float x, float y, boolean force) {
        if (!force && !component.isVisible()) {
            return false;
        }
        if (!force && !component.contains(x, y)) {
            return false;
        }
        this.mLocationInWindow[0] = 0.0f;
        this.mLocationInWindow[1] = 0.0f;
        component.getLocationInWindow(this.mLocationInWindow);
        for (Operation o : this.mList) {
            if (!(o instanceof ActionOperation)) continue;
            ((ActionOperation)((Object)o)).runAction(context, document, component, x, y);
        }
        return true;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.add("actions", new Vector());
    }
}

