/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.operations.layout.ImpulseProcess;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.ArrayList;
import java.util.List;

public class ImpulseOperation
extends PaintOperation
implements VariableSupport,
Container {
    private static final int OP_CODE = 164;
    private static final String CLASS_NAME = "ImpulseOperation";
    private float mDuration;
    private float mStartAt;
    private float mOutDuration;
    private float mOutStartAt;
    private boolean mInitialPass = true;
    @NonNull
    public ArrayList<Operation> mList = new ArrayList();
    int mIndexVariableId;
    private ImpulseProcess mProcess;

    public ImpulseOperation(float duration, float startAt) {
        this.mDuration = duration;
        this.mStartAt = startAt;
        this.mOutStartAt = startAt;
        this.mOutDuration = duration;
    }

    @Override
    public void registerListening(RemoteContext context) {
        if (this.mProcess == null) {
            System.out.println(".....");
            Operation last = this.mList.get(this.mList.size() - 1);
            if (last instanceof ImpulseProcess) {
                this.mProcess = (ImpulseProcess)last;
                this.mList.remove(last);
            }
        }
        if (Float.isNaN(this.mStartAt)) {
            context.listensTo(Utils.idFromNan(this.mStartAt), this);
        }
        if (Float.isNaN(this.mDuration)) {
            context.listensTo(Utils.idFromNan(this.mDuration), this);
        }
        for (Operation operation : this.mList) {
            if (!(operation instanceof VariableSupport)) continue;
            VariableSupport variableSupport = (VariableSupport)((Object)operation);
            variableSupport.registerListening(context);
        }
        if (this.mProcess != null) {
            this.mProcess.registerListening(context);
        }
    }

    @Override
    public void updateVariables(RemoteContext context) {
        this.mOutDuration = Float.isNaN(this.mDuration) ? context.getFloat(Utils.idFromNan(this.mDuration)) : this.mDuration;
        float f = this.mOutStartAt = Float.isNaN(this.mStartAt) ? context.getFloat(Utils.idFromNan(this.mStartAt)) : this.mStartAt;
        if (this.mProcess != null) {
            this.mProcess.updateVariables(context);
        }
    }

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ImpulseOperation.apply(buffer, this.mDuration, this.mStartAt);
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder("ImpulseOperation\n");
        for (Operation operation : this.mList) {
            builder.append("  startAt: ");
            builder.append(this.mStartAt);
            builder.append(" duration: ");
            builder.append(this.mDuration);
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        RemoteContext remoteContext = context.getContext();
        if (remoteContext.getAnimationTime() < this.mOutStartAt + this.mOutDuration) {
            if (this.mInitialPass) {
                for (Operation op : this.mList) {
                    if (op instanceof VariableSupport && op.isDirty()) {
                        ((VariableSupport)((Object)op)).updateVariables(context.getContext());
                    }
                    remoteContext.incrementOpCount();
                    op.apply(context.getContext());
                }
                this.mInitialPass = false;
            } else {
                remoteContext.incrementOpCount();
                if (this.mProcess != null) {
                    this.mProcess.paint(context);
                }
            }
        } else {
            this.mInitialPass = true;
        }
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void apply(@NonNull WireBuffer buffer, float duration, float startAt) {
        buffer.start(164);
        buffer.writeFloat(duration);
        buffer.writeFloat(startAt);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        float duration = buffer.readFloat();
        float startAt = buffer.readFloat();
        operations.add(new ImpulseOperation(duration, startAt));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Operations", 164, ImpulseOperation.name()).description("Impulse Operation. This operation execute a list of action for a fixed duration").field(1, "duration", "How long to last").field(1, "startAt", "value step");
    }

    public int estimateIterations() {
        if (Float.isNaN(this.mDuration)) {
            return 10;
        }
        return (int)(this.mDuration * 60.0f);
    }

    public void setProcess(ImpulseProcess impulseProcess) {
        this.mProcess = impulseProcess;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("duration", this.mDuration, this.mOutDuration).add("startAt", this.mStartAt, this.mOutStartAt);
    }
}

