/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.TouchListener;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.ComponentData;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.RootLayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.utilities.AnimatedFloatExpression;
import com.android.internal.widget.remotecompose.core.operations.utilities.NanMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.touch.VelocityEasing;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.Arrays;
import java.util.List;

public class TouchExpression
extends Operation
implements ComponentData,
VariableSupport,
TouchListener,
Serializable {
    private static final int OP_CODE = 157;
    private static final String CLASS_NAME = "TouchExpression";
    private float mDefValue;
    private float mOutDefValue;
    private int mId;
    public float[] mSrcExp;
    int mMode = 1;
    float mMax = 1.0f;
    float mMin = 1.0f;
    float mOutMax = 1.0f;
    float mOutMin = 1.0f;
    float mValue = 0.0f;
    boolean mUnmodified = true;
    private float[] mPreCalcValue;
    private float mLastChange = Float.NaN;
    private float mLastCalculatedValue = Float.NaN;
    AnimatedFloatExpression mExp = new AnimatedFloatExpression();
    public static final int MAX_EXPRESSION_SIZE = 32;
    private VelocityEasing mEasyTouch = new VelocityEasing();
    private boolean mEasingToStop = false;
    private float mTouchUpTime = 0.0f;
    private float mCurrentValue = Float.NaN;
    private boolean mTouchDown = false;
    float mMaxTime = 1.0f;
    float mMaxAcceleration = 5.0f;
    float mMaxVelocity = 7.0f;
    int mStopMode = 0;
    boolean mWrapMode = false;
    float[] mNotches;
    float[] mStopSpec;
    float[] mOutStopSpec;
    int mTouchEffects;
    float mVelocityId;
    public static final int STOP_GENTLY = 0;
    public static final int STOP_ENDS = 2;
    public static final int STOP_INSTANTLY = 1;
    public static final int STOP_NOTCHES_EVEN = 3;
    public static final int STOP_NOTCHES_PERCENTS = 4;
    public static final int STOP_NOTCHES_ABSOLUTE = 5;
    public static final int STOP_ABSOLUTE_POS = 6;
    float mLastValue = 0.0f;
    float mScrLeft;
    float mScrRight;
    float mScrTop;
    float mScrBottom;
    @Nullable
    Component mComponent;
    float mValueAtDown;
    float mDownTouchValue;

    public TouchExpression(int id2, float[] exp, float defValue, float min, float max, int touchEffects, float velocityId, int stopMode, float[] stopSpec, float[] easingSpec) {
        this.mId = id2;
        this.mSrcExp = exp;
        this.mOutDefValue = this.mDefValue = defValue;
        this.mMode = 6 == stopMode ? 1 : 0;
        this.mOutMax = this.mMax = max;
        if (stopSpec != null) {
            this.mOutStopSpec = Arrays.copyOf(stopSpec, stopSpec.length);
        }
        this.mTouchEffects = touchEffects;
        this.mVelocityId = velocityId;
        if (Float.isNaN(min) && Utils.idFromNan(min) == 0) {
            this.mWrapMode = true;
        } else {
            this.mOutMin = this.mMin = min;
        }
        this.mStopMode = stopMode;
        this.mStopSpec = stopSpec;
        if (easingSpec != null && easingSpec.length >= 4 && Float.floatToRawIntBits(easingSpec[0]) == 0) {
            this.mMaxTime = easingSpec[1];
            this.mMaxAcceleration = easingSpec[2];
            this.mMaxVelocity = easingSpec[3];
        }
    }

    @Override
    public void updateVariables(RemoteContext context) {
        float newValue;
        float v;
        int i;
        if (this.mPreCalcValue == null || this.mPreCalcValue.length != this.mSrcExp.length) {
            this.mPreCalcValue = new float[this.mSrcExp.length];
        }
        if (this.mOutStopSpec == null || this.mOutStopSpec.length != this.mStopSpec.length) {
            this.mOutStopSpec = new float[this.mStopSpec.length];
        }
        if (Float.isNaN(this.mMax)) {
            this.mOutMax = context.getFloat(Utils.idFromNan(this.mMax));
        }
        if (Float.isNaN(this.mMin)) {
            this.mOutMin = context.getFloat(Utils.idFromNan(this.mMin));
        }
        if (Float.isNaN(this.mDefValue)) {
            this.mOutDefValue = context.getFloat(Utils.idFromNan(this.mDefValue));
        }
        boolean value_changed = false;
        for (i = 0; i < this.mSrcExp.length; ++i) {
            v = this.mSrcExp[i];
            this.mPreCalcValue[i] = Float.isNaN(v) && !AnimatedFloatExpression.isMathOperator(v) && !NanMap.isDataVariable(v) ? (newValue = context.getFloat(Utils.idFromNan(v))) : this.mSrcExp[i];
        }
        for (i = 0; i < this.mStopSpec.length; ++i) {
            v = this.mStopSpec[i];
            this.mOutStopSpec[i] = Float.isNaN(v) ? (newValue = context.getFloat(Utils.idFromNan(v))) : v;
        }
        float v2 = this.mLastCalculatedValue;
        if (value_changed) {
            v2 = this.mExp.eval(this.mPreCalcValue, this.mPreCalcValue.length, new float[0]);
            if (v2 != this.mLastCalculatedValue) {
                this.mLastChange = context.getAnimationTime();
                this.mLastCalculatedValue = v2;
            } else {
                value_changed = false;
            }
        }
    }

    @Override
    public void registerListening(RemoteContext context) {
        if (Float.isNaN(this.mMax)) {
            context.listensTo(Utils.idFromNan(this.mMax), this);
        }
        if (Float.isNaN(this.mMin)) {
            context.listensTo(Utils.idFromNan(this.mMin), this);
        }
        if (Float.isNaN(this.mDefValue)) {
            context.listensTo(Utils.idFromNan(this.mDefValue), this);
        }
        if (this.mComponent == null) {
            context.addTouchListener(this);
        }
        for (float v : this.mSrcExp) {
            if (!Float.isNaN(v) || AnimatedFloatExpression.isMathOperator(v) || NanMap.isDataVariable(v)) continue;
            context.listensTo(Utils.idFromNan(v), this);
        }
        for (float v : this.mStopSpec) {
            if (!Float.isNaN(v)) continue;
            context.listensTo(Utils.idFromNan(v), this);
        }
    }

    private float wrap(float pos) {
        if (!this.mWrapMode) {
            return pos;
        }
        if ((pos %= this.mOutMax) < 0.0f) {
            pos += this.mOutMax;
        }
        return pos;
    }

    private float getStopPosition(float pos, float slope) {
        float target = pos + slope / 2.0f;
        if (this.mWrapMode) {
            pos = this.wrap(pos);
            target = pos += slope / 2.0f;
        } else {
            target = Math.max(Math.min(target, this.mOutMax), this.mOutMin);
        }
        float[] positions = new float[this.mStopSpec.length];
        float min = this.mWrapMode ? 0.0f : this.mOutMin;
        switch (this.mStopMode) {
            case 2: {
                return pos + slope > (this.mOutMax + min) / 2.0f ? this.mOutMax : min;
            }
            case 1: {
                return pos;
            }
            case 3: {
                int evenSpacing = (int)this.mOutStopSpec[0];
                float notchMax = this.mOutStopSpec.length > 1 ? this.mOutStopSpec[1] : this.mOutMax;
                float step = (notchMax - min) / (float)evenSpacing;
                float notch = min + step * (float)((int)(0.5f + (target - this.mOutMin) / step));
                if (!this.mWrapMode) {
                    notch = Math.max(Math.min(notch, this.mOutMax), min);
                }
                return notch;
            }
            case 4: {
                positions = new float[this.mStopSpec.length];
                float minPos = min;
                float minPosDist = Math.abs(this.mOutMin - target);
                for (int i = 0; i < positions.length; ++i) {
                    float p = this.mOutMin + this.mStopSpec[i] * (this.mOutMax - this.mOutMin);
                    float dist = Math.abs(p - target);
                    if (!(minPosDist > dist)) continue;
                    minPosDist = dist;
                    minPos = p;
                }
                return minPos;
            }
            case 5: {
                positions = this.mStopSpec;
                float minPos = this.mOutMin;
                float minPosDist = Math.abs(this.mOutMin - target);
                for (int i = 0; i < positions.length; ++i) {
                    float dist = Math.abs(positions[i] - target);
                    if (!(minPosDist > dist)) continue;
                    minPosDist = dist;
                    minPos = positions[i];
                }
                return minPos;
            }
        }
        return target;
    }

    void haptic(RemoteContext context) {
        int touch = this.mTouchEffects & 0xFF;
        if ((this.mTouchEffects & 0x8000) != 0) {
            touch = context.getInteger(this.mTouchEffects & Short.MAX_VALUE);
        }
        context.hapticEffect(touch);
    }

    void crossNotchCheck(RemoteContext context) {
        float next;
        float prev = this.mLastValue;
        this.mLastValue = next = this.mCurrentValue;
        float min = this.mWrapMode ? 0.0f : this.mOutMin;
        float max = this.mOutMax;
        switch (this.mStopMode) {
            case 2: {
                if (!((min - prev) * (max - prev) < 0.0f ^ (min - next) * (max - next) < 0.0f)) break;
                this.haptic(context);
                break;
            }
            case 1: {
                this.haptic(context);
                break;
            }
            case 3: {
                int evenSpacing = (int)this.mStopSpec[0];
                float step = (max - min) / (float)evenSpacing;
                if ((int)((prev - min) / step) == (int)((next - min) / step)) break;
                this.haptic(context);
                break;
            }
            case 4: {
                for (int i = 0; i < this.mStopSpec.length; ++i) {
                    float p = this.mOutMin + this.mStopSpec[i] * (this.mOutMax - this.mOutMin);
                    if (!((prev - p) * (next - p) < 0.0f)) continue;
                    this.haptic(context);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.mStopSpec.length; ++i) {
                    float p = this.mStopSpec[i];
                    if (!((prev - p) * (next - p) < 0.0f)) continue;
                    this.haptic(context);
                }
                break;
            }
        }
    }

    @Override
    public void setComponent(@Nullable Component component) {
        this.mComponent = component;
        if (this.mComponent != null) {
            try {
                RootLayoutComponent root = this.mComponent.getRoot();
                root.setHasTouchListeners(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateBounds() {
        Component comp = this.mComponent;
        if (comp != null) {
            float x = comp.getX();
            float y = comp.getY();
            float w = comp.getWidth();
            float h = comp.getHeight();
            for (comp = comp.getParent(); comp != null; comp = comp.getParent()) {
                x += comp.getX();
                y += comp.getY();
            }
            this.mScrLeft = x;
            this.mScrTop = y;
            this.mScrRight = w + x;
            this.mScrBottom = h + y;
        }
    }

    @Override
    public void apply(RemoteContext context) {
        this.updateBounds();
        if (this.mUnmodified) {
            this.mCurrentValue = this.mOutDefValue;
            context.loadFloat(this.mId, this.wrap(this.mCurrentValue));
            return;
        }
        if (this.mEasingToStop) {
            float value;
            float time = context.getAnimationTime() - this.mTouchUpTime;
            this.mCurrentValue = value = this.mEasyTouch.getPos(time);
            value = this.mWrapMode ? this.wrap(value) : Math.min(Math.max(value, this.mOutMin), this.mOutMax);
            context.loadFloat(this.mId, value);
            if (this.mEasyTouch.getDuration() < time) {
                this.mEasingToStop = false;
            }
            this.crossNotchCheck(context);
            context.needsRepaint();
            return;
        }
        if (this.mTouchDown) {
            float value = this.mExp.eval(context.getCollectionsAccess(), this.mPreCalcValue, this.mPreCalcValue.length);
            if (this.mMode == 0) {
                value = this.mValueAtDown + (value - this.mDownTouchValue);
            }
            value = this.mWrapMode ? this.wrap(value) : Math.min(Math.max(value, this.mOutMin), this.mOutMax);
            this.mCurrentValue = value;
        }
        this.crossNotchCheck(context);
        context.loadFloat(this.mId, this.wrap(this.mCurrentValue));
    }

    @Override
    public void touchDown(RemoteContext context, float x, float y) {
        if (!(x >= this.mScrLeft && x <= this.mScrRight && y >= this.mScrTop && y <= this.mScrBottom)) {
            Utils.log("NOT IN WINDOW " + x + ", " + y + " " + this.mScrLeft + ", " + this.mScrTop);
            return;
        }
        this.mEasingToStop = false;
        this.mTouchDown = true;
        this.mUnmodified = false;
        if (this.mMode == 0) {
            this.mValueAtDown = context.getFloat(this.mId);
            this.mDownTouchValue = this.mExp.eval(context.getCollectionsAccess(), this.mPreCalcValue, this.mPreCalcValue.length);
        }
        context.needsRepaint();
    }

    @Override
    public void touchUp(RemoteContext context, float x, float y, float dx, float dy) {
        if (!this.mTouchDown) {
            return;
        }
        this.mTouchDown = false;
        float dt = 1.0E-4f;
        if (this.mStopMode == 1) {
            return;
        }
        float v = this.mExp.eval(context.getCollectionsAccess(), this.mPreCalcValue, this.mPreCalcValue.length);
        for (int i = 0; i < this.mSrcExp.length; ++i) {
            if (!Float.isNaN(this.mSrcExp[i])) continue;
            int id2 = Utils.idFromNan(this.mSrcExp[i]);
            if (id2 == 13) {
                this.mPreCalcValue[i] = x + dx * dt;
                continue;
            }
            if (id2 != 14) continue;
            this.mPreCalcValue[i] = y + dy * dt;
        }
        float vdt = this.mExp.eval(context.getCollectionsAccess(), this.mPreCalcValue, this.mPreCalcValue.length);
        float slope = (vdt - v) / dt;
        float value = context.getFloat(this.mId);
        this.mTouchUpTime = context.getAnimationTime();
        float dest = this.getStopPosition(value, slope);
        float time = Math.min(2.0f, this.mMaxTime * Math.abs(dest - value) / (2.0f * this.mMaxVelocity));
        this.mEasyTouch.config(value, dest, slope, time, this.mMaxAcceleration, this.mMaxVelocity, null);
        this.mEasingToStop = true;
        context.needsRepaint();
    }

    @Override
    public void touchDrag(RemoteContext context, float x, float y) {
        if (!this.mTouchDown) {
            return;
        }
        this.apply(context);
        context.needsRepaint();
    }

    @Override
    public void write(WireBuffer buffer) {
        TouchExpression.apply(buffer, this.mId, this.mValue, this.mMin, this.mMax, this.mVelocityId, this.mTouchEffects, this.mSrcExp, this.mStopMode, this.mNotches, null);
    }

    public String toString() {
        String[] labels = new String[this.mSrcExp.length];
        for (int i = 0; i < this.mSrcExp.length; ++i) {
            if (!Float.isNaN(this.mSrcExp[i])) continue;
            labels[i] = "[" + Utils.idStringFromNan(this.mSrcExp[i]) + "]";
        }
        if (this.mPreCalcValue == null) {
            return "TouchExpression[" + this.mId + "] = (" + AnimatedFloatExpression.toString(this.mSrcExp, labels) + ")";
        }
        return "TouchExpression[" + this.mId + "] = (" + AnimatedFloatExpression.toString(this.mPreCalcValue, labels) + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 157;
    }

    public static void apply(WireBuffer buffer, int id2, float value, float min, float max, float velocityId, int touchEffects, float[] exp, int touchMode, float[] touchSpec, float[] easingSpec) {
        int i;
        buffer.start(157);
        buffer.writeInt(id2);
        buffer.writeFloat(value);
        buffer.writeFloat(min);
        buffer.writeFloat(max);
        buffer.writeFloat(velocityId);
        buffer.writeInt(touchEffects);
        buffer.writeInt(exp.length);
        for (float v : exp) {
            buffer.writeFloat(v);
        }
        int len = 0;
        if (touchSpec != null) {
            len = touchSpec.length;
        }
        buffer.writeInt(touchMode << 16 | len);
        for (i = 0; i < len; ++i) {
            buffer.writeFloat(touchSpec[i]);
        }
        len = easingSpec != null ? easingSpec.length : 0;
        buffer.writeInt(len);
        for (i = 0; i < len; ++i) {
            buffer.writeFloat(easingSpec[i]);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        float startValue = buffer.readFloat();
        float min = buffer.readFloat();
        float max = buffer.readFloat();
        float velocityId = buffer.readFloat();
        int touchEffects = buffer.readInt();
        int len = buffer.readInt();
        int valueLen = len & 0xFFFF;
        if (valueLen > 32) {
            throw new RuntimeException("Float expression to long");
        }
        float[] exp = new float[valueLen];
        for (int i = 0; i < exp.length; ++i) {
            exp[i] = buffer.readFloat();
        }
        int stopLogic = buffer.readInt();
        int stopLen = stopLogic & 0xFFFF;
        int stopMode = stopLogic >> 16;
        float[] stopsData = new float[stopLen];
        for (int i = 0; i < stopsData.length; ++i) {
            stopsData[i] = buffer.readFloat();
        }
        int easingLen = buffer.readInt();
        float[] easingData = new float[easingLen];
        for (int i = 0; i < easingData.length; ++i) {
            easingData[i] = buffer.readFloat();
        }
        operations.add(new TouchExpression(id2, exp, startValue, min, max, touchEffects, velocityId, stopMode, stopsData, easingData));
    }

    public static void documentation(DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 157, CLASS_NAME).description("A Float expression").field(0, "id", "The id of the Color").field(9, "expression_length", "expression length").field(9, "animation_length", "animation description length").field(10, "expression", "expression_length", "Sequence of Floats representing and expression").field(10, "AnimationSpec", "animation_length", "Sequence of Floats representing animation curve").field(1, "duration", "> time in sec").field(0, "bits", "> WRAP|INITALVALUE | TYPE ").field(10, "spec", "> [SPEC PARAMETERS] ").field(1, "initialValue", "> [Initial value] ").field(1, "wrapValue", "> [Wrap value] ");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("defValue", this.mDefValue, this.mOutDefValue).add("min", this.mMin, this.mOutMin).add("max", this.mMax, this.mOutMax).add("mode", this.mMode).addFloatExpressionSrc("srcExp", this.mSrcExp);
    }
}

