/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.Arrays;
import java.util.List;

public class PathData
extends Operation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 123;
    private static final String CLASS_NAME = "PathData";
    int mInstanceId;
    float[] mFloatPath;
    float[] mOutputPath;
    private boolean mPathChanged = true;
    public static final int MOVE = 10;
    public static final int LINE = 11;
    public static final int QUADRATIC = 12;
    public static final int CONIC = 13;
    public static final int CUBIC = 14;
    public static final int CLOSE = 15;
    public static final int DONE = 16;
    public static final float MOVE_NAN = Utils.asNan(10);
    public static final float LINE_NAN = Utils.asNan(11);
    public static final float QUADRATIC_NAN = Utils.asNan(12);
    public static final float CONIC_NAN = Utils.asNan(13);
    public static final float CUBIC_NAN = Utils.asNan(14);
    public static final float CLOSE_NAN = Utils.asNan(15);
    public static final float DONE_NAN = Utils.asNan(16);

    PathData(int instanceId, float[] floatPath) {
        this.mInstanceId = instanceId;
        this.mFloatPath = floatPath;
        this.mOutputPath = Arrays.copyOf(this.mFloatPath, this.mFloatPath.length);
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        for (int i = 0; i < this.mFloatPath.length; ++i) {
            float v = this.mFloatPath[i];
            if (Utils.isVariable(v)) {
                float tmp = this.mOutputPath[i];
                float f = this.mOutputPath[i] = Float.isNaN(v) ? context.getFloat(Utils.idFromNan(v)) : v;
                if (tmp == this.mOutputPath[i]) continue;
                this.mPathChanged = true;
                continue;
            }
            this.mOutputPath[i] = v;
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        for (float v : this.mFloatPath) {
            if (!Float.isNaN(v)) continue;
            context.listensTo(Utils.idFromNan(v), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        PathData.apply(buffer, this.mInstanceId, this.mOutputPath);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return PathData.pathString(this.mFloatPath);
    }

    @NonNull
    public String toString() {
        return "PathData[" + this.mInstanceId + "] = \"" + this.deepToString(" ") + "\"";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 123;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull float[] data) {
        buffer.start(123);
        buffer.writeInt(id2);
        buffer.writeInt(data.length);
        for (float datum : data) {
            buffer.writeFloat(datum);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int imageId = buffer.readInt();
        int len = buffer.readInt();
        float[] data = new float[len];
        for (int i = 0; i < data.length; ++i) {
            data[i] = buffer.readFloat();
        }
        operations.add(new PathData(imageId, data));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 123, CLASS_NAME).description("Encode a Path ").field(0, "id", "id string").field(0, "length", "id string").field(10, "pathData", "length", "path encoded as floats");
    }

    @NonNull
    public static String pathString(@Nullable float[] path) {
        if (path == null) {
            return "null";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            if (i != 0) {
                str.append(" ");
            }
            if (Float.isNaN(path[i])) {
                int id2 = Utils.idFromNan(path[i]);
                if (id2 <= 16) {
                    switch (id2) {
                        case 10: {
                            str.append("M");
                            break;
                        }
                        case 11: {
                            str.append("L");
                            break;
                        }
                        case 12: {
                            str.append("Q");
                            break;
                        }
                        case 13: {
                            str.append("R");
                            break;
                        }
                        case 14: {
                            str.append("C");
                            break;
                        }
                        case 15: {
                            str.append("Z");
                            break;
                        }
                        case 16: {
                            str.append(".");
                            break;
                        }
                        default: {
                            str.append("[" + id2 + "]");
                            break;
                        }
                    }
                    continue;
                }
                str.append("(" + id2 + ")");
                continue;
            }
            str.append(path[i]);
        }
        return str.toString();
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        if (this.mPathChanged) {
            context.loadPathData(this.mInstanceId, this.mOutputPath);
        }
        this.mPathChanged = false;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mInstanceId).addPath("path", this.mFloatPath);
    }
}

