/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.ComponentData;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class PaintData
extends PaintOperation
implements ComponentData,
VariableSupport,
Serializable {
    private static final int OP_CODE = 40;
    private static final String CLASS_NAME = "PaintData";
    @NonNull
    public PaintBundle mPaintData = new PaintBundle();
    public static final int MAX_STRING_SIZE = 4000;

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mPaintData.updateVariables(context);
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        this.mPaintData.registerVars(context, this);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        PaintData.apply(buffer, this.mPaintData);
    }

    @NonNull
    public String toString() {
        return "PaintData \"" + this.mPaintData + "\"";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 40;
    }

    public static void apply(@NonNull WireBuffer buffer, @NonNull PaintBundle paintBundle) {
        buffer.start(40);
        paintBundle.writeBundle(buffer);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        PaintData data = new PaintData();
        data.mPaintData.readBundle(buffer);
        operations.add(data);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 40, CLASS_NAME).description("Encode a Paint ").field(0, "length", "id string").field(11, "paint", "length", "path encoded as floats");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.applyPaint(this.mPaintData);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("paintBundle", this.mPaintData);
    }
}

