/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase3;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class MatrixRotate
extends DrawBase3 {
    private static final int OP_CODE = 129;
    private static final String CLASS_NAME = "MatrixRotate";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase3.Maker m = new DrawBase3.Maker(){

            @Override
            @NonNull
            public DrawBase3 create(float v1, float v2, float v3) {
                return new MatrixRotate(v1, v2, v3);
            }
        };
        MatrixRotate.read(m, buffer, operations);
    }

    public static int id() {
        return 129;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 129, CLASS_NAME).description("apply rotation to matrix").field(1, "rotate", "Angle to rotate").field(1, "pivotX", "X Pivot point").field(1, "pivotY", "Y Pivot point");
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3) {
        MatrixRotate.apply(buffer, v1, v2, v3);
    }

    public MatrixRotate(float rotate, float pivotX, float pivotY) {
        super(rotate, pivotX, pivotY);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.matrixRotate(this.mV1, this.mV2, this.mV3);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1, float x2) {
        buffer.start(129);
        buffer.writeFloat(x1);
        buffer.writeFloat(y1);
        buffer.writeFloat(x2);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "rotate", "pivotX", "pivotY").addType(CLASS_NAME);
    }
}

