/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.BitmapData;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.Collections;
import java.util.List;

public class ImageAttribute
extends PaintOperation {
    private static final int OP_CODE = 171;
    private static final String CLASS_NAME = "ImageAttribute";
    private final int[] mArgs;
    public int mId;
    int mImageId;
    short mType;
    public static final short IMAGE_WIDTH = 0;
    public static final short IMAGE_HEIGHT = 1;
    @NonNull
    float[] mBounds = new float[4];

    public ImageAttribute(int id2, int imageId, short type, int[] args) {
        this.mId = id2;
        this.mImageId = imageId;
        this.mType = type;
        this.mArgs = args;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ImageAttribute.apply(buffer, this.mId, this.mImageId, this.mType, this.mArgs);
    }

    @NonNull
    public String toString() {
        return "ImageAttribute[" + this.mId + "] = " + this.mImageId + " " + this.mType;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 171;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int imageId, short type, int[] args) {
        buffer.start(171);
        buffer.writeInt(id2);
        buffer.writeInt(imageId);
        buffer.writeShort(type);
        if (args == null) {
            buffer.writeShort(0);
        } else {
            buffer.writeShort((short)args.length);
            for (int i = 0; i < args.length; ++i) {
                buffer.writeInt(args[i]);
            }
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int imageId = buffer.readInt();
        short type = (short)buffer.readShort();
        short len = (short)buffer.readShort();
        int[] args = new int[len];
        for (int i = 0; i < args.length; ++i) {
            args[i] = buffer.readInt();
        }
        operations.add(new ImageAttribute(id2, imageId, type, args));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Image Attributes", 171, CLASS_NAME).description("Measure text").field(0, "id", "id of float result of the measure").field(0, "ImageId", "id of the image").field(9, "type", "type: measure 0=width,1=height").field(9, "len", "number of additional arguments (currently 0)").field(0, "a", "len", "number of arguments");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        BitmapData bitmapData = (BitmapData)context.getContext().getObject(this.mImageId);
        switch (this.mType) {
            case 0: {
                context.getContext().loadFloat(this.mId, bitmapData.getWidth());
                break;
            }
            case 1: {
                context.getContext().loadFloat(this.mId, bitmapData.getHeight());
            }
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("imageId", this.mImageId).add("args", Collections.singletonList(this.mArgs)).addType(this.typeToString());
    }

    private String typeToString() {
        switch (this.mType) {
            case 0: {
                return "IMAGE_WIDTH";
            }
            case 1: {
                return "IMAGE_HEIGHT";
            }
        }
        return "INVALID_TYPE";
    }
}

