/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class HapticFeedback
extends Operation
implements SerializableToString,
Serializable {
    private static final int OP_CODE = 177;
    private static final String CLASS_NAME = "HapticFeedback";
    private int mHapticFeedbackType;

    public HapticFeedback(int hapticFeedbackType) {
        this.mHapticFeedbackType = hapticFeedbackType;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        HapticFeedback.apply(buffer, this.mHapticFeedbackType);
    }

    @NonNull
    public String toString() {
        return "HapticFeedback(" + this.mHapticFeedbackType + ")";
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 177;
    }

    public static void apply(@NonNull WireBuffer buffer, int hapticFeedbackType) {
        buffer.start(177);
        buffer.writeInt(hapticFeedbackType);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int hapticFeedbackType = buffer.readInt();
        operations.add(new HapticFeedback(hapticFeedbackType));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 177, CLASS_NAME).description("Generate an haptic feedback").field(0, "HapticFeedbackType", "Type of haptic feedback");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.hapticEffect(this.mHapticFeedbackType);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, this.getSerializedName() + "<" + this.mHapticFeedbackType + ">");
    }

    @NonNull
    private String getSerializedName() {
        return "HAPTIC_FEEDBACK";
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("hapticFeedbackType", this.mHapticFeedbackType);
    }
}

