/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class DrawTextOnPath
extends PaintOperation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 53;
    private static final String CLASS_NAME = "DrawTextOnPath";
    int mPathId;
    public int mTextId;
    float mVOffset;
    float mHOffset;
    float mOutVOffset;
    float mOutHOffset;

    public DrawTextOnPath(int textId, int pathId, float hOffset, float vOffset) {
        this.mPathId = pathId;
        this.mTextId = textId;
        this.mOutHOffset = this.mHOffset = hOffset;
        this.mOutVOffset = this.mVOffset = vOffset;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutHOffset = Float.isNaN(this.mHOffset) ? context.getFloat(Utils.idFromNan(this.mHOffset)) : this.mHOffset;
        this.mOutVOffset = Float.isNaN(this.mVOffset) ? context.getFloat(Utils.idFromNan(this.mVOffset)) : this.mVOffset;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mHOffset)) {
            context.listensTo(Utils.idFromNan(this.mHOffset), this);
        }
        if (Float.isNaN(this.mVOffset)) {
            context.listensTo(Utils.idFromNan(this.mVOffset), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawTextOnPath.apply(buffer, this.mTextId, this.mPathId, this.mHOffset, this.mVOffset);
    }

    @NonNull
    public String toString() {
        return "DrawTextOnPath [" + this.mTextId + "] [" + this.mPathId + "] " + Utils.floatToString(this.mHOffset, this.mOutHOffset) + ", " + Utils.floatToString(this.mVOffset, this.mOutVOffset);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int textId = buffer.readInt();
        int pathId = buffer.readInt();
        float vOffset = buffer.readFloat();
        float hOffset = buffer.readFloat();
        DrawTextOnPath op = new DrawTextOnPath(textId, pathId, hOffset, vOffset);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 53;
    }

    public static void apply(@NonNull WireBuffer buffer, int textId, int pathId, float hOffset, float vOffset) {
        buffer.start(53);
        buffer.writeInt(textId);
        buffer.writeInt(pathId);
        buffer.writeFloat(vOffset);
        buffer.writeFloat(hOffset);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", 53, CLASS_NAME).description("Draw text along path object").field(0, "textId", "id of the text").field(0, "pathId", "id of the path").field(1, "xOffset", "x Shift of the text").field(1, "yOffset", "y Shift of the text");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawTextOnPath(this.mTextId, this.mPathId, this.mOutHOffset, this.mOutVOffset);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("pathId", this.mPathId).add("textId", this.mTextId).add("vOffset", this.mVOffset, this.mOutVOffset).add("hOffset", this.mHOffset, this.mOutHOffset);
    }
}

