/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase4;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawLine
extends DrawBase4
implements SerializableToString {
    private static final int OP_CODE = 47;
    private static final String CLASS_NAME = "DrawLine";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase4.Maker m = DrawLine::new;
        DrawLine.read(m, buffer, operations);
    }

    public static int id() {
        return 47;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 47, CLASS_NAME).description("Draw a line segment").field(1, "startX", "The x-coordinate of the start point of the line").field(1, "startY", "The y-coordinate of the start point of the line").field(1, "endX", "The x-coordinate of the end point of the line").field(1, "endY", "The y-coordinate of the end point of the line");
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3, float v4) {
        DrawLine.apply(buffer, v1, v2, v3, v4);
    }

    public DrawLine(float left, float top, float right, float bottom) {
        super(left, top, right, bottom);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawLine(this.mX1, this.mY1, this.mX2, this.mY2);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1, float x2, float y2) {
        DrawLine.write(buffer, 47, x1, y1, x2, y2);
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        String x1 = "" + this.mX1;
        if (Float.isNaN(this.mX1Value)) {
            x1 = "[" + Utils.idFromNan(this.mX1Value) + " = " + this.mX1 + "]";
        }
        String y1 = "" + this.mY1;
        if (Float.isNaN(this.mY1Value)) {
            y1 = "[" + Utils.idFromNan(this.mY1Value) + " = " + this.mY1 + "]";
        }
        String x2 = "" + this.mX2;
        if (Float.isNaN(this.mX2Value)) {
            x2 = "[" + Utils.idFromNan(this.mX2Value) + " = " + this.mX2 + "]";
        }
        String y2 = "" + this.mY2;
        if (Float.isNaN(this.mY2Value)) {
            y2 = "[" + Utils.idFromNan(this.mY2Value) + " = " + this.mY2 + "]";
        }
        serializer.append(indent, "DrawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ")");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "startX", "startY", "endX", "endY").addType(CLASS_NAME);
    }
}

