/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.ImageScaling;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawBitmapScaled
extends PaintOperation
implements VariableSupport,
AccessibleComponent {
    private static final int OP_CODE = 149;
    private static final String CLASS_NAME = "DrawBitmapScaled";
    int mImageId;
    float mSrcLeft;
    float mOutSrcLeft;
    float mSrcTop;
    float mOutSrcTop;
    float mSrcRight;
    float mOutSrcRight;
    float mSrcBottom;
    float mOutSrcBottom;
    float mDstLeft;
    float mOutDstLeft;
    float mDstTop;
    float mOutDstTop;
    float mDstRight;
    float mOutDstRight;
    float mDstBottom;
    float mOutDstBottom;
    int mContentDescId;
    float mScaleFactor;
    float mOutScaleFactor;
    int mScaleType;
    int mMode;
    @NonNull
    ImageScaling mScaling = new ImageScaling();
    public static final int SCALE_NONE = 0;
    public static final int SCALE_INSIDE = 1;
    public static final int SCALE_FILL_WIDTH = 2;
    public static final int SCALE_FILL_HEIGHT = 3;
    public static final int SCALE_FIT = 4;
    public static final int SCALE_CROP = 5;
    public static final int SCALE_FILL_BOUNDS = 6;
    public static final int SCALE_FIXED_SCALE = 7;

    public DrawBitmapScaled(int imageId, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, int type, float scale, int cdId) {
        this.mImageId = imageId;
        this.mOutSrcLeft = this.mSrcLeft = srcLeft;
        this.mOutSrcTop = this.mSrcTop = srcTop;
        this.mOutSrcRight = this.mSrcRight = srcRight;
        this.mOutSrcBottom = this.mSrcBottom = srcBottom;
        this.mOutDstLeft = this.mDstLeft = dstLeft;
        this.mOutDstTop = this.mDstTop = dstTop;
        this.mOutDstRight = this.mDstRight = dstRight;
        this.mOutDstBottom = this.mDstBottom = dstBottom;
        this.mScaleType = type & 0xFF;
        this.mMode = type >> 8;
        this.mOutScaleFactor = this.mScaleFactor = scale;
        this.mContentDescId = cdId;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mOutSrcLeft = Float.isNaN(this.mSrcLeft) ? context.getFloat(Utils.idFromNan(this.mSrcLeft)) : this.mSrcLeft;
        this.mOutSrcTop = Float.isNaN(this.mSrcTop) ? context.getFloat(Utils.idFromNan(this.mSrcTop)) : this.mSrcTop;
        this.mOutSrcRight = Float.isNaN(this.mSrcRight) ? context.getFloat(Utils.idFromNan(this.mSrcRight)) : this.mSrcRight;
        this.mOutSrcBottom = Float.isNaN(this.mSrcBottom) ? context.getFloat(Utils.idFromNan(this.mSrcBottom)) : this.mSrcBottom;
        this.mOutDstLeft = Float.isNaN(this.mDstLeft) ? context.getFloat(Utils.idFromNan(this.mDstLeft)) : this.mDstLeft;
        this.mOutDstTop = Float.isNaN(this.mDstTop) ? context.getFloat(Utils.idFromNan(this.mDstTop)) : this.mDstTop;
        this.mOutDstRight = Float.isNaN(this.mDstRight) ? context.getFloat(Utils.idFromNan(this.mDstRight)) : this.mDstRight;
        this.mOutDstBottom = Float.isNaN(this.mDstBottom) ? context.getFloat(Utils.idFromNan(this.mDstBottom)) : this.mDstBottom;
        this.mOutScaleFactor = Float.isNaN(this.mScaleFactor) ? context.getFloat(Utils.idFromNan(this.mScaleFactor)) : this.mScaleFactor;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        this.register(context, this.mSrcLeft);
        this.register(context, this.mSrcTop);
        this.register(context, this.mSrcRight);
        this.register(context, this.mSrcBottom);
        this.register(context, this.mDstLeft);
        this.register(context, this.mDstTop);
        this.register(context, this.mDstRight);
        this.register(context, this.mDstBottom);
        this.register(context, this.mScaleFactor);
    }

    private void register(@NonNull RemoteContext context, float value) {
        if (Float.isNaN(value)) {
            context.listensTo(Utils.idFromNan(value), this);
        }
    }

    @NonNull
    static String str(float v) {
        String s = "  " + (int)v;
        return s.substring(s.length() - 3);
    }

    void print(String str, float left, float top, float right, float bottom) {
        String s = str;
        s = s + DrawBitmapScaled.str(left) + ", " + DrawBitmapScaled.str(top) + ", " + DrawBitmapScaled.str(right) + ", " + DrawBitmapScaled.str(bottom) + ", ";
        s = s + " [" + DrawBitmapScaled.str(right - left) + " x " + DrawBitmapScaled.str(bottom - top) + "]";
        System.out.println(s);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawBitmapScaled.apply(buffer, this.mImageId, this.mSrcLeft, this.mSrcTop, this.mSrcRight, this.mSrcBottom, this.mDstLeft, this.mDstTop, this.mDstRight, this.mDstBottom, this.mScaleType, this.mScaleFactor, this.mContentDescId);
    }

    @NonNull
    public String toString() {
        return "DrawBitmapScaled " + this.mImageId + " [" + Utils.floatToString(this.mSrcLeft, this.mOutSrcLeft) + " " + Utils.floatToString(this.mSrcTop, this.mOutSrcTop) + " " + Utils.floatToString(this.mSrcRight, this.mOutSrcRight) + " " + Utils.floatToString(this.mSrcBottom, this.mOutSrcBottom) + "] - [" + Utils.floatToString(this.mDstLeft, this.mOutDstLeft) + " " + Utils.floatToString(this.mDstTop, this.mOutDstTop) + " " + Utils.floatToString(this.mDstRight, this.mOutDstRight) + " " + Utils.floatToString(this.mDstBottom, this.mOutDstBottom) + "]  " + this.mScaleType + " " + Utils.floatToString(this.mScaleFactor, this.mOutScaleFactor);
    }

    @Override
    public Integer getContentDescriptionId() {
        return this.mContentDescId;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 149;
    }

    public static void apply(@NonNull WireBuffer buffer, int imageId, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, int scaleType, float scaleFactor, int cdId) {
        buffer.start(149);
        buffer.writeInt(imageId);
        buffer.writeFloat(srcLeft);
        buffer.writeFloat(srcTop);
        buffer.writeFloat(srcRight);
        buffer.writeFloat(srcBottom);
        buffer.writeFloat(dstLeft);
        buffer.writeFloat(dstTop);
        buffer.writeFloat(dstRight);
        buffer.writeFloat(dstBottom);
        buffer.writeInt(scaleType);
        buffer.writeFloat(scaleFactor);
        buffer.writeInt(cdId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int imageId = buffer.readInt();
        float sLeft = buffer.readFloat();
        float srcTop = buffer.readFloat();
        float srcRight = buffer.readFloat();
        float srcBottom = buffer.readFloat();
        float dstLeft = buffer.readFloat();
        float dstTop = buffer.readFloat();
        float dstRight = buffer.readFloat();
        float dstBottom = buffer.readFloat();
        int scaleType = buffer.readInt();
        float scaleFactor = buffer.readFloat();
        int cdId = buffer.readInt();
        DrawBitmapScaled op = new DrawBitmapScaled(imageId, sLeft, srcTop, srcRight, srcBottom, dstLeft, dstTop, dstRight, dstBottom, scaleType, scaleFactor, cdId);
        operations.add(op);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", 149, CLASS_NAME).description("Draw a bitmap using integer coordinates").field(0, "id", "id of bitmap").field(1, "srcLeft", "The left side of the image").field(1, "srcTop", "The top of the image").field(1, "srcRight", "The right side of the image").field(1, "srcBottom", "The bottom of the output").field(1, "dstLeft", "The left side of the output").field(1, "dstTop", "The top of the output").field(1, "dstRight", "The right side of the output").field(0, "type", "type of auto scaling").field(0, "scaleFactor", "for allowed").field(0, "cdId", "id of string");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        this.mScaling.setup(this.mOutSrcLeft, this.mOutSrcTop, this.mOutSrcRight, this.mOutSrcBottom, this.mOutDstLeft, this.mOutDstTop, this.mOutDstRight, this.mOutDstBottom, this.mScaleType, this.mOutScaleFactor);
        context.save();
        context.clipRect(this.mOutDstLeft, this.mOutDstTop, this.mOutDstRight, this.mOutDstBottom);
        int imageId = this.mImageId;
        if ((this.mMode & 1) != 0) {
            imageId = context.getContext().getInteger(imageId);
        }
        context.drawBitmap(imageId, (int)this.mOutSrcLeft, (int)this.mOutSrcTop, (int)this.mOutSrcRight, (int)this.mOutSrcBottom, (int)this.mScaling.mFinalDstLeft, (int)this.mScaling.mFinalDstTop, (int)this.mScaling.mFinalDstRight, (int)this.mScaling.mFinalDstBottom, this.mContentDescId);
        context.restore();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("imageId", this.mImageId).add("contentDescriptionId", this.mContentDescId).add("scaleType", this.getScaleTypeString()).add("mode", this.mMode).add("scaleFactor", this.mScaleFactor, this.mOutScaleFactor).add("srcLeft", this.mSrcLeft, this.mOutSrcLeft).add("srcTop", this.mSrcTop, this.mOutSrcTop).add("srcRight", this.mSrcRight, this.mOutSrcRight).add("srcBottom", this.mSrcBottom, this.mOutSrcBottom).add("dstLeft", this.mDstLeft, this.mOutDstLeft).add("dstTop", this.mDstTop, this.mOutDstTop).add("dstRight", this.mDstRight, this.mOutDstRight).add("dstBottom", this.mDstBottom, this.mOutDstBottom);
    }

    private String getScaleTypeString() {
        switch (this.mScaleType) {
            case 0: {
                return "SCALE_NONE";
            }
            case 1: {
                return "SCALE_INSIDE";
            }
            case 2: {
                return "SCALE_FILL_WIDTH";
            }
            case 3: {
                return "SCALE_FILL_HEIGHT";
            }
            case 4: {
                return "SCALE_FIT";
            }
            case 5: {
                return "SCALE_CROP";
            }
            case 6: {
                return "SCALE_FILL_BOUNDS";
            }
            case 7: {
                return "SCALE_FIXED_SCALE";
            }
        }
        return "INVALID_SCALE_TYPE";
    }
}

