/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.operations.utilities.ArrayAccess;
import com.android.internal.widget.remotecompose.core.operations.utilities.CollectionsAccess;
import com.android.internal.widget.remotecompose.core.operations.utilities.DataMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntFloatMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntIntMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class RemoteComposeState
implements CollectionsAccess {
    public static final int START_ID = 42;
    private static int sMaxColors = 200;
    private static final int MAX_DATA = 1000;
    private final IntMap<Object> mIntDataMap = new IntMap();
    private final IntMap<Boolean> mIntWrittenMap = new IntMap();
    private final HashMap<Object, Integer> mDataIntMap = new HashMap();
    private final IntFloatMap mFloatMap = new IntFloatMap();
    private final IntIntMap mIntegerMap = new IntIntMap();
    private final IntIntMap mColorMap = new IntIntMap();
    private final IntMap<DataMap> mDataMapMap = new IntMap();
    private final IntMap<Object> mObjectMap = new IntMap();
    private final IntMap<Object> mPathMap = new IntMap();
    private final IntMap<float[]> mPathData = new IntMap();
    private boolean[] mColorOverride = new boolean[sMaxColors];
    @NonNull
    private final IntMap<ArrayAccess> mCollectionMap = new IntMap();
    private final boolean[] mDataOverride = new boolean[1000];
    private final boolean[] mIntegerOverride = new boolean[1000];
    private final boolean[] mFloatOverride = new boolean[1000];
    private int mNextId = 42;
    @NonNull
    private int[] mIdMaps = new int[]{42, 1048618, 0x20002A};
    @Nullable
    private RemoteContext mRemoteContext = null;
    @NonNull
    IntMap<ArrayList<VariableSupport>> mVarListeners = new IntMap();
    @NonNull
    ArrayList<VariableSupport> mAllVarListeners = new ArrayList();

    @Nullable
    public Object getFromId(int id2) {
        return this.mIntDataMap.get(id2);
    }

    public boolean containsId(int id2) {
        return this.mIntDataMap.get(id2) != null;
    }

    public int dataGetId(@NonNull Object data) {
        Integer res = this.mDataIntMap.get(data);
        if (res == null) {
            return -1;
        }
        return res;
    }

    public int cacheData(@NonNull Object item) {
        int id2 = this.nextId();
        this.mDataIntMap.put(item, id2);
        this.mIntDataMap.put(id2, item);
        return id2;
    }

    public int cacheData(@NonNull Object item, int type) {
        int id2 = this.nextId(type);
        this.mDataIntMap.put(item, id2);
        this.mIntDataMap.put(id2, item);
        return id2;
    }

    public void cacheData(int id2, @NonNull Object item) {
        this.mDataIntMap.put(item, id2);
        this.mIntDataMap.put(id2, item);
    }

    public void updateData(int id2, @NonNull Object item) {
        Object previous;
        if (!this.mDataOverride[id2] && (previous = this.mIntDataMap.get(id2)) != item) {
            this.mDataIntMap.remove(previous);
            this.mDataIntMap.put(item, id2);
            this.mIntDataMap.put(id2, item);
            this.updateListeners(id2);
        }
    }

    public Object getPath(int id2) {
        return this.mPathMap.get(id2);
    }

    public void putPath(int id2, Object path) {
        this.mPathMap.put(id2, path);
    }

    public void putPathData(int id2, float[] data) {
        this.mPathData.put(id2, data);
        this.mPathMap.remove(id2);
    }

    public float[] getPathData(int id2) {
        return this.mPathData.get(id2);
    }

    public void overrideData(int id2, @NonNull Object item) {
        Object previous = this.mIntDataMap.get(id2);
        if (previous != item) {
            this.mDataIntMap.remove(previous);
            this.mDataIntMap.put(item, id2);
            this.mIntDataMap.put(id2, item);
            this.mDataOverride[id2] = true;
            this.updateListeners(id2);
        }
    }

    public int cacheFloat(float item) {
        int id2 = this.nextId();
        this.mFloatMap.put(id2, item);
        this.mIntegerMap.put(id2, (int)item);
        return id2;
    }

    public void cacheFloat(int id2, float item) {
        this.mFloatMap.put(id2, item);
    }

    public void updateFloat(int id2, float value) {
        float previous;
        if (!this.mFloatOverride[id2] && (previous = this.mFloatMap.get(id2)) != value) {
            this.mFloatMap.put(id2, value);
            this.mIntegerMap.put(id2, (int)value);
            this.updateListeners(id2);
        }
    }

    public void overrideFloat(int id2, float value) {
        float previous = this.mFloatMap.get(id2);
        if (previous != value) {
            this.mFloatMap.put(id2, value);
            this.mIntegerMap.put(id2, (int)value);
            this.mFloatOverride[id2] = true;
            this.updateListeners(id2);
        }
    }

    public int cacheInteger(int item) {
        int id2 = this.nextId();
        this.mIntegerMap.put(id2, item);
        this.mFloatMap.put(id2, item);
        return id2;
    }

    public void updateInteger(int id2, int value) {
        int previous;
        if (!this.mIntegerOverride[id2] && (previous = this.mIntegerMap.get(id2)) != value) {
            this.mFloatMap.put(id2, value);
            this.mIntegerMap.put(id2, value);
            this.updateListeners(id2);
        }
    }

    public void overrideInteger(int id2, int value) {
        int previous = this.mIntegerMap.get(id2);
        if (previous != value) {
            this.mIntegerMap.put(id2, value);
            this.mFloatMap.put(id2, value);
            this.mIntegerOverride[id2] = true;
            this.updateListeners(id2);
        }
    }

    public float getFloat(int id2) {
        return this.mFloatMap.get(id2);
    }

    public int getInteger(int id2) {
        return this.mIntegerMap.get(id2);
    }

    public int getColor(int id2) {
        return this.mColorMap.get(id2);
    }

    public void updateColor(int id2, int color2) {
        if (id2 < sMaxColors && this.mColorOverride[id2]) {
            return;
        }
        this.mColorMap.put(id2, color2);
        this.updateListeners(id2);
    }

    private void updateListeners(int id2) {
        ArrayList<VariableSupport> v = this.mVarListeners.get(id2);
        if (v != null && this.mRemoteContext != null) {
            for (int i = 0; i < v.size(); ++i) {
                VariableSupport c = v.get(i);
                c.markDirty();
            }
        }
    }

    public void overrideColor(int id2, int color2) {
        if (id2 >= sMaxColors) {
            this.mColorOverride = Arrays.copyOf(this.mColorOverride, sMaxColors *= 2);
        }
        this.mColorOverride[id2] = true;
        this.mColorMap.put(id2, color2);
        this.updateListeners(id2);
    }

    public void clearColorOverride() {
        for (int i = 0; i < this.mColorOverride.length; ++i) {
            this.mColorOverride[i] = false;
        }
    }

    public void clearDataOverride(int id2) {
        this.mDataOverride[id2] = false;
        this.updateListeners(id2);
    }

    public void clearIntegerOverride(int id2) {
        this.mIntegerOverride[id2] = false;
        this.updateListeners(id2);
    }

    public void clearFloatOverride(int id2) {
        this.mFloatOverride[id2] = false;
        this.updateListeners(id2);
    }

    public boolean wasNotWritten(int id2) {
        return this.mIntWrittenMap.get(id2) == false;
    }

    public void markWritten(int id2) {
        this.mIntWrittenMap.put(id2, true);
    }

    public void reset() {
        this.mIntWrittenMap.clear();
        this.mDataIntMap.clear();
    }

    public int nextId() {
        return this.mNextId++;
    }

    public int nextId(int type) {
        if (0 == type) {
            return this.mNextId++;
        }
        int n = type;
        int n2 = this.mIdMaps[n];
        this.mIdMaps[n] = n2 + 1;
        return n2;
    }

    public void setNextId(int id2) {
        this.mNextId = id2;
    }

    private void add(int id2, @NonNull VariableSupport variableSupport) {
        ArrayList<VariableSupport> v = this.mVarListeners.get(id2);
        if (v == null) {
            v = new ArrayList();
            this.mVarListeners.put(id2, v);
        }
        v.add(variableSupport);
        this.mAllVarListeners.add(variableSupport);
    }

    public void listenToVar(int id2, @NonNull VariableSupport variableSupport) {
        this.add(id2, variableSupport);
    }

    public boolean hasListener(int id2) {
        return this.mVarListeners.get(id2) != null;
    }

    public int getOpsToUpdate(@NonNull RemoteContext context) {
        if (this.mVarListeners.get(1) != null) {
            return 1;
        }
        if (this.mVarListeners.get(2) != null) {
            return 1000;
        }
        if (this.mVarListeners.get(3) != null) {
            return 60000;
        }
        return -1;
    }

    public void setWindowWidth(float width) {
        this.updateFloat(5, width);
    }

    public void setWindowHeight(float height) {
        this.updateFloat(6, height);
    }

    public void addCollection(int id2, @NonNull ArrayAccess collection) {
        this.mCollectionMap.put(id2 & 0xFFFFF, collection);
    }

    @Override
    public float getFloatValue(int id2, int index) {
        return this.mCollectionMap.get(id2 & 0xFFFFF).getFloatValue(index);
    }

    @Override
    @Nullable
    public float[] getFloats(int id2) {
        return this.mCollectionMap.get(id2 & 0xFFFFF).getFloats();
    }

    @Override
    public int getId(int id2, int index) {
        return this.mCollectionMap.get(id2 & 0xFFFFF).getId(index);
    }

    public void putDataMap(int id2, @NonNull DataMap map) {
        this.mDataMapMap.put(id2, map);
    }

    @Nullable
    public DataMap getDataMap(int id2) {
        return this.mDataMapMap.get(id2);
    }

    @Override
    public int getListLength(int id2) {
        return this.mCollectionMap.get(id2 & 0xFFFFF).getLength();
    }

    public void setContext(@NonNull RemoteContext context) {
        this.mRemoteContext = context;
        this.mRemoteContext.clearLastOpCount();
    }

    public void updateObject(int id2, @NonNull Object value) {
        this.mObjectMap.put(id2, value);
    }

    @Nullable
    public Object getObject(int id2) {
        return this.mObjectMap.get(id2);
    }
}

