/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.CompanionOperation;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.Operations;
import com.android.internal.widget.remotecompose.core.Platform;
import com.android.internal.widget.remotecompose.core.RemoteComposeState;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.BitmapData;
import com.android.internal.widget.remotecompose.core.operations.BitmapFontData;
import com.android.internal.widget.remotecompose.core.operations.ClickArea;
import com.android.internal.widget.remotecompose.core.operations.ClipPath;
import com.android.internal.widget.remotecompose.core.operations.ClipRect;
import com.android.internal.widget.remotecompose.core.operations.ColorAttribute;
import com.android.internal.widget.remotecompose.core.operations.ColorConstant;
import com.android.internal.widget.remotecompose.core.operations.ColorExpression;
import com.android.internal.widget.remotecompose.core.operations.ComponentValue;
import com.android.internal.widget.remotecompose.core.operations.ConditionalOperations;
import com.android.internal.widget.remotecompose.core.operations.DataListFloat;
import com.android.internal.widget.remotecompose.core.operations.DataListIds;
import com.android.internal.widget.remotecompose.core.operations.DataMapIds;
import com.android.internal.widget.remotecompose.core.operations.DataMapLookup;
import com.android.internal.widget.remotecompose.core.operations.DebugMessage;
import com.android.internal.widget.remotecompose.core.operations.DrawArc;
import com.android.internal.widget.remotecompose.core.operations.DrawBitmap;
import com.android.internal.widget.remotecompose.core.operations.DrawBitmapFontText;
import com.android.internal.widget.remotecompose.core.operations.DrawBitmapInt;
import com.android.internal.widget.remotecompose.core.operations.DrawBitmapScaled;
import com.android.internal.widget.remotecompose.core.operations.DrawCircle;
import com.android.internal.widget.remotecompose.core.operations.DrawContent;
import com.android.internal.widget.remotecompose.core.operations.DrawLine;
import com.android.internal.widget.remotecompose.core.operations.DrawOval;
import com.android.internal.widget.remotecompose.core.operations.DrawPath;
import com.android.internal.widget.remotecompose.core.operations.DrawRect;
import com.android.internal.widget.remotecompose.core.operations.DrawRoundRect;
import com.android.internal.widget.remotecompose.core.operations.DrawSector;
import com.android.internal.widget.remotecompose.core.operations.DrawText;
import com.android.internal.widget.remotecompose.core.operations.DrawTextAnchored;
import com.android.internal.widget.remotecompose.core.operations.DrawTextOnPath;
import com.android.internal.widget.remotecompose.core.operations.DrawTweenPath;
import com.android.internal.widget.remotecompose.core.operations.FloatConstant;
import com.android.internal.widget.remotecompose.core.operations.FloatExpression;
import com.android.internal.widget.remotecompose.core.operations.FloatFunctionCall;
import com.android.internal.widget.remotecompose.core.operations.FloatFunctionDefine;
import com.android.internal.widget.remotecompose.core.operations.HapticFeedback;
import com.android.internal.widget.remotecompose.core.operations.Header;
import com.android.internal.widget.remotecompose.core.operations.ImageAttribute;
import com.android.internal.widget.remotecompose.core.operations.IntegerExpression;
import com.android.internal.widget.remotecompose.core.operations.MatrixRestore;
import com.android.internal.widget.remotecompose.core.operations.MatrixRotate;
import com.android.internal.widget.remotecompose.core.operations.MatrixSave;
import com.android.internal.widget.remotecompose.core.operations.MatrixScale;
import com.android.internal.widget.remotecompose.core.operations.MatrixSkew;
import com.android.internal.widget.remotecompose.core.operations.MatrixTranslate;
import com.android.internal.widget.remotecompose.core.operations.NamedVariable;
import com.android.internal.widget.remotecompose.core.operations.PaintData;
import com.android.internal.widget.remotecompose.core.operations.ParticlesCreate;
import com.android.internal.widget.remotecompose.core.operations.ParticlesLoop;
import com.android.internal.widget.remotecompose.core.operations.PathAppend;
import com.android.internal.widget.remotecompose.core.operations.PathCombine;
import com.android.internal.widget.remotecompose.core.operations.PathCreate;
import com.android.internal.widget.remotecompose.core.operations.PathData;
import com.android.internal.widget.remotecompose.core.operations.PathTween;
import com.android.internal.widget.remotecompose.core.operations.RootContentBehavior;
import com.android.internal.widget.remotecompose.core.operations.RootContentDescription;
import com.android.internal.widget.remotecompose.core.operations.TextAttribute;
import com.android.internal.widget.remotecompose.core.operations.TextData;
import com.android.internal.widget.remotecompose.core.operations.TextFromFloat;
import com.android.internal.widget.remotecompose.core.operations.TextLength;
import com.android.internal.widget.remotecompose.core.operations.TextLookup;
import com.android.internal.widget.remotecompose.core.operations.TextLookupInt;
import com.android.internal.widget.remotecompose.core.operations.TextMeasure;
import com.android.internal.widget.remotecompose.core.operations.TextMerge;
import com.android.internal.widget.remotecompose.core.operations.Theme;
import com.android.internal.widget.remotecompose.core.operations.TimeAttribute;
import com.android.internal.widget.remotecompose.core.operations.TouchExpression;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.CanvasContent;
import com.android.internal.widget.remotecompose.core.operations.layout.CanvasOperations;
import com.android.internal.widget.remotecompose.core.operations.layout.ComponentStart;
import com.android.internal.widget.remotecompose.core.operations.layout.ContainerEnd;
import com.android.internal.widget.remotecompose.core.operations.layout.ImpulseOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.ImpulseProcess;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponentContent;
import com.android.internal.widget.remotecompose.core.operations.layout.LoopOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.RootLayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.BoxLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.CanvasLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.CollapsibleColumnLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.CollapsibleRowLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.ColumnLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.FitBoxLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.ImageLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.RowLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.StateLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.TextLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.BackgroundModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.BorderModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ClipRectModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.GraphicsLayerModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.MarqueeModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.OffsetModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.PaddingModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.RippleModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.RoundedClipRectModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.RunActionOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ScrollModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ZIndexModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.operations.utilities.AnimatedFloatExpression;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.FloatAnimation;
import com.android.internal.widget.remotecompose.core.types.BooleanConstant;
import com.android.internal.widget.remotecompose.core.types.IntegerConstant;
import com.android.internal.widget.remotecompose.core.types.LongConstant;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class RemoteComposeBuffer {
    public static final int EASING_CUBIC_STANDARD = 1;
    public static final int EASING_CUBIC_ACCELERATE = 2;
    public static final int EASING_CUBIC_DECELERATE = 3;
    public static final int EASING_CUBIC_LINEAR = 4;
    public static final int EASING_CUBIC_ANTICIPATE = 5;
    public static final int EASING_CUBIC_OVERSHOOT = 6;
    public static final int EASING_CUBIC_CUSTOM = 11;
    public static final int EASING_SPLINE_CUSTOM = 12;
    public static final int EASING_EASE_OUT_BOUNCE = 13;
    public static final int EASING_EASE_OUT_ELASTIC = 14;
    @NonNull
    private WireBuffer mBuffer = new WireBuffer();
    @Nullable
    private Platform mPlatform = null;
    @NonNull
    private final RemoteComposeState mRemoteComposeState;
    private static final boolean DEBUG = false;
    private int mLastComponentId = 0;
    private int mGeneratedComponentId = -1;
    public static final int PAD_AFTER_SPACE = 0;
    public static final int PAD_AFTER_NONE = 1;
    public static final int PAD_AFTER_ZERO = 3;
    public static final int PAD_PRE_SPACE = 0;
    public static final int PAD_PRE_NONE = 4;
    public static final int PAD_PRE_ZERO = 12;

    public RemoteComposeBuffer(@NonNull RemoteComposeState remoteComposeState) {
        this.mRemoteComposeState = remoteComposeState;
    }

    public void reset(int expectedSize) {
        this.mBuffer.reset(expectedSize);
        this.mRemoteComposeState.reset();
        this.mLastComponentId = 0;
        this.mGeneratedComponentId = -1;
    }

    public int getLastComponentId() {
        return this.mLastComponentId;
    }

    @Nullable
    public Platform getPlatform() {
        return this.mPlatform;
    }

    public void setPlatform(@NonNull Platform platform) {
        this.mPlatform = platform;
    }

    @NonNull
    public WireBuffer getBuffer() {
        return this.mBuffer;
    }

    public void setBuffer(@NonNull WireBuffer buffer) {
        this.mBuffer = buffer;
    }

    public void addHeader(short[] tags, Object[] values) {
        Header.apply(this.mBuffer, tags, values);
    }

    public void header(int width, int height, @Nullable String contentDescription, float density, long capabilities) {
        Header.apply(this.mBuffer, width, height, density, capabilities);
        int contentDescriptionId = 0;
        if (contentDescription != null) {
            contentDescriptionId = this.addText(contentDescription);
            RootContentDescription.apply(this.mBuffer, contentDescriptionId);
        }
    }

    public void addHeader(int width, int height, @Nullable String contentDescription, float density, long capabilities) {
        Header.apply(this.mBuffer, width, height, density, capabilities);
        int contentDescriptionId = 0;
        if (contentDescription != null) {
            contentDescriptionId = this.addText(contentDescription);
            RootContentDescription.apply(this.mBuffer, contentDescriptionId);
        }
    }

    public void header(int width, int height, @Nullable String contentDescription) {
        this.header(width, height, contentDescription, 1.0f, 0L);
    }

    public void drawBitmap(@NonNull Object image, int imageWidth, int imageHeight, int srcLeft, int srcTop, int srcRight, int srcBottom, int dstLeft, int dstTop, int dstRight, int dstBottom, @Nullable String contentDescription) {
        int imageId = this.storeBitmap(image);
        int contentDescriptionId = 0;
        if (contentDescription != null) {
            contentDescriptionId = this.addText(contentDescription);
        }
        DrawBitmapInt.apply(this.mBuffer, imageId, srcLeft, srcTop, srcRight, srcBottom, dstLeft, dstTop, dstRight, dstBottom, contentDescriptionId);
    }

    public int mapLookup(int mapId, int strId) {
        int hash = mapId + strId * 33;
        int id2 = this.mRemoteComposeState.dataGetId(hash);
        if (id2 == -1) {
            id2 = this.mRemoteComposeState.cacheData(hash);
            DataMapLookup.apply(this.mBuffer, id2, mapId, strId);
        }
        return id2;
    }

    public int addText(@NonNull String text) {
        int id2 = this.mRemoteComposeState.dataGetId(text);
        if (id2 == -1) {
            id2 = this.mRemoteComposeState.cacheData(text);
            TextData.apply(this.mBuffer, id2, text);
        }
        return id2;
    }

    public void addClickArea(int id2, @Nullable String contentDescription, float left, float top, float right, float bottom, @Nullable String metadata) {
        int contentDescriptionId = 0;
        if (contentDescription != null) {
            contentDescriptionId = this.addText(contentDescription);
        }
        int metadataId = 0;
        if (metadata != null) {
            metadataId = this.addText(metadata);
        }
        ClickArea.apply(this.mBuffer, id2, contentDescriptionId, left, top, right, bottom, metadataId);
    }

    public void setRootContentBehavior(int scroll, int alignment, int sizing, int mode) {
        RootContentBehavior.apply(this.mBuffer, scroll, alignment, sizing, mode);
    }

    public void addDrawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        DrawArc.apply(this.mBuffer, left, top, right, bottom, startAngle, sweepAngle);
    }

    public void addDrawSector(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        DrawSector.apply(this.mBuffer, left, top, right, bottom, startAngle, sweepAngle);
    }

    public void addDrawBitmap(@NonNull Object image, float left, float top, float right, float bottom, @Nullable String contentDescription) {
        int imageId = this.storeBitmap(image);
        this.addDrawBitmap(imageId, left, top, right, bottom, contentDescription);
    }

    public void addDrawBitmap(int imageId, float left, float top, float right, float bottom, @Nullable String contentDescription) {
        int contentDescriptionId = 0;
        if (contentDescription != null) {
            contentDescriptionId = this.addText(contentDescription);
        }
        DrawBitmap.apply(this.mBuffer, imageId, left, top, right, bottom, contentDescriptionId);
    }

    public void addDrawBitmap(int imageId, float left, float top, @Nullable String contentDescription) {
        int imageWidth = this.mPlatform.getImageWidth(imageId);
        int imageHeight = this.mPlatform.getImageHeight(imageId);
        int contentDescriptionId = 0;
        if (contentDescription != null) {
            contentDescriptionId = this.addText(contentDescription);
        }
        DrawBitmap.apply(this.mBuffer, imageId, left, top, imageWidth, imageHeight, contentDescriptionId);
    }

    public void drawScaledBitmap(@NonNull Object image, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, int scaleType, float scaleFactor, @Nullable String contentDescription) {
        int imageId = this.storeBitmap(image);
        int contentDescriptionId = 0;
        if (contentDescription != null) {
            contentDescriptionId = this.addText(contentDescription);
        }
        DrawBitmapScaled.apply(this.mBuffer, imageId, srcLeft, srcTop, srcRight, srcBottom, dstLeft, dstTop, dstRight, dstBottom, scaleType, scaleFactor, contentDescriptionId);
    }

    public int addBitmap(@NonNull Object image) {
        return this.storeBitmap(image);
    }

    public int addBitmap(@NonNull Object image, @NonNull String name) {
        return this.storeBitmap(image);
    }

    public int addBitmapFont(BitmapFontData.Glyph[] glyphs) {
        int id2 = this.mRemoteComposeState.nextId();
        BitmapFontData.apply(this.mBuffer, id2, glyphs);
        return id2;
    }

    public void setBitmapName(int id2, @NonNull String name) {
        NamedVariable.apply(this.mBuffer, id2, 3, name);
    }

    public void drawScaledBitmap(int imageId, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, int scaleType, float scaleFactor, @Nullable String contentDescription) {
        int contentDescriptionId = 0;
        if (contentDescription != null) {
            contentDescriptionId = this.addText(contentDescription);
        }
        DrawBitmapScaled.apply(this.mBuffer, imageId, srcLeft, srcTop, srcRight, srcBottom, dstLeft, dstTop, dstRight, dstBottom, scaleType, scaleFactor, contentDescriptionId);
    }

    public void addDrawCircle(float centerX, float centerY, float radius) {
        DrawCircle.apply(this.mBuffer, centerX, centerY, radius);
    }

    public void addDrawLine(float x1, float y1, float x2, float y2) {
        DrawLine.apply(this.mBuffer, x1, y1, x2, y2);
    }

    public void addDrawOval(float left, float top, float right, float bottom) {
        DrawOval.apply(this.mBuffer, left, top, right, bottom);
    }

    public void addDrawPath(@NonNull Object path) {
        int id2 = this.mRemoteComposeState.dataGetId(path);
        if (id2 == -1) {
            id2 = this.addPathData(path);
        }
        this.addDrawPath(id2);
    }

    public int pathTween(int pid1, int pid2, float tween) {
        int out = this.mRemoteComposeState.nextId();
        PathTween.apply(this.mBuffer, out, pid1, pid2, tween);
        return out;
    }

    public int pathCreate(float x, float y) {
        int out = this.mRemoteComposeState.nextId();
        PathCreate.apply(this.mBuffer, out, x, y);
        return out;
    }

    public void pathAppend(int id2, float ... path) {
        PathAppend.apply(this.mBuffer, id2, path);
    }

    public void addDrawPath(int pathId) {
        DrawPath.apply(this.mBuffer, pathId);
    }

    public void addDrawRect(float left, float top, float right, float bottom) {
        DrawRect.apply(this.mBuffer, left, top, right, bottom);
    }

    public void addDrawRoundRect(float left, float top, float right, float bottom, float radiusX, float radiusY) {
        DrawRoundRect.apply(this.mBuffer, left, top, right, bottom, radiusX, radiusY);
    }

    public void addDrawTextOnPath(@NonNull String text, @NonNull Object path, float hOffset, float vOffset) {
        int pathId = this.mRemoteComposeState.dataGetId(path);
        if (pathId == -1) {
            pathId = this.addPathData(path);
        }
        int textId = this.addText(text);
        DrawTextOnPath.apply(this.mBuffer, textId, pathId, hOffset, vOffset);
    }

    public void addDrawTextOnPath(int textId, Object path, float hOffset, float vOffset) {
        int pathId = this.mRemoteComposeState.dataGetId(path);
        if (pathId == -1) {
            pathId = this.addPathData(path);
        }
        DrawTextOnPath.apply(this.mBuffer, textId, pathId, hOffset, vOffset);
    }

    public void addDrawTextRun(@NonNull String text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean rtl) {
        int textId = this.addText(text);
        DrawText.apply(this.mBuffer, textId, start, end, contextStart, contextEnd, x, y, rtl);
    }

    public void addDrawTextRun(int textId, int start, int end, int contextStart, int contextEnd, float x, float y, boolean rtl) {
        DrawText.apply(this.mBuffer, textId, start, end, contextStart, contextEnd, x, y, rtl);
    }

    public void addDrawBitmapFontTextRun(int textId, int bitmapFontId, int start, int end, float x, float y) {
        DrawBitmapFontText.apply(this.mBuffer, textId, bitmapFontId, start, end, x, y);
    }

    public void drawTextAnchored(@NonNull String text, float x, float y, float panX, float panY, int flags) {
        int textId = this.addText(text);
        DrawTextAnchored.apply(this.mBuffer, textId, x, y, panX, panY, flags);
    }

    public int createTextId(@NonNull String text) {
        return this.addText(text);
    }

    public int textMerge(int id1, int id2) {
        int textId = this.nextId();
        TextMerge.apply(this.mBuffer, textId, id1, id2);
        return textId;
    }

    public int createTextFromFloat(float value, short digitsBefore, short digitsAfter, int flags) {
        String placeHolder = Utils.floatToString(value) + "(" + digitsBefore + "," + digitsAfter + "," + flags + ")";
        int id2 = this.mRemoteComposeState.dataGetId(placeHolder);
        if (id2 == -1) {
            id2 = this.mRemoteComposeState.cacheData(placeHolder);
        }
        TextFromFloat.apply(this.mBuffer, id2, value, digitsBefore, digitsAfter, flags);
        return id2;
    }

    public void drawTextAnchored(int textId, float x, float y, float panX, float panY, int flags) {
        DrawTextAnchored.apply(this.mBuffer, textId, x, y, panX, panY, flags);
    }

    public void addDrawTweenPath(@NonNull Object path1, @NonNull Object path2, float tween, float start, float stop) {
        int path2Id;
        int path1Id = this.mRemoteComposeState.dataGetId(path1);
        if (path1Id == -1) {
            path1Id = this.addPathData(path1);
        }
        if ((path2Id = this.mRemoteComposeState.dataGetId(path2)) == -1) {
            path2Id = this.addPathData(path2);
        }
        this.addDrawTweenPath(path1Id, path2Id, tween, start, stop);
    }

    public void addDrawTweenPath(int path1Id, int path2Id, float tween, float start, float stop) {
        DrawTweenPath.apply(this.mBuffer, path1Id, path2Id, tween, start, stop);
    }

    public int addPathData(@NonNull Object path) {
        float[] pathData = this.mPlatform.pathToFloatArray(path);
        int id2 = this.mRemoteComposeState.cacheData(path);
        PathData.apply(this.mBuffer, id2, pathData);
        return id2;
    }

    public void addPaint(@NonNull PaintBundle paint) {
        PaintData.apply(this.mBuffer, paint);
    }

    public void inflateFromBuffer(@NonNull ArrayList<Operation> operations) {
        this.mBuffer.setIndex(0);
        while (this.mBuffer.available()) {
            int opId = this.mBuffer.readByte();
            CompanionOperation operation = (CompanionOperation)Operations.map.get(opId);
            if (operation == null) {
                throw new RuntimeException("Unknown operation encountered " + opId);
            }
            operation.read(this.mBuffer, operations);
        }
    }

    public static void readNextOperation(@NonNull WireBuffer buffer, @NonNull ArrayList<Operation> operations) {
        int opId = buffer.readByte();
        CompanionOperation operation = (CompanionOperation)Operations.map.get(opId);
        if (operation == null) {
            throw new RuntimeException("Unknown operation encountered " + opId);
        }
        operation.read(buffer, operations);
    }

    @NonNull
    RemoteComposeBuffer copy() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        this.inflateFromBuffer(operations);
        RemoteComposeBuffer buffer = new RemoteComposeBuffer(this.mRemoteComposeState);
        return this.copyFromOperations(operations, buffer);
    }

    public void setTheme(int theme) {
        Theme.apply(this.mBuffer, theme);
    }

    @NonNull
    static String version() {
        return "v1.0";
    }

    @NonNull
    public static RemoteComposeBuffer fromFile(@NonNull String path, @NonNull RemoteComposeState remoteComposeState) throws IOException {
        RemoteComposeBuffer buffer = new RemoteComposeBuffer(remoteComposeState);
        RemoteComposeBuffer.read(new File(path), buffer);
        return buffer;
    }

    @NonNull
    public RemoteComposeBuffer fromFile(@NonNull File file, @NonNull RemoteComposeState remoteComposeState) throws IOException {
        RemoteComposeBuffer buffer = new RemoteComposeBuffer(remoteComposeState);
        RemoteComposeBuffer.read(file, buffer);
        return buffer;
    }

    @NonNull
    public static RemoteComposeBuffer fromInputStream(@NonNull InputStream inputStream, @NonNull RemoteComposeState remoteComposeState) {
        RemoteComposeBuffer buffer = new RemoteComposeBuffer(remoteComposeState);
        RemoteComposeBuffer.read(inputStream, buffer);
        return buffer;
    }

    @NonNull
    RemoteComposeBuffer copyFromOperations(@NonNull ArrayList<Operation> operations, @NonNull RemoteComposeBuffer buffer) {
        for (Operation operation : operations) {
            operation.write(buffer.mBuffer);
        }
        return buffer;
    }

    public void write(@NonNull RemoteComposeBuffer buffer, @NonNull File file) {
        try {
            FileOutputStream fd = new FileOutputStream(file);
            fd.write(buffer.mBuffer.getBuffer(), 0, buffer.mBuffer.getSize());
            fd.flush();
            fd.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static void read(@NonNull File file, @NonNull RemoteComposeBuffer buffer) throws IOException {
        FileInputStream fd = new FileInputStream(file);
        RemoteComposeBuffer.read(fd, buffer);
    }

    public static void read(@NonNull InputStream fd, @NonNull RemoteComposeBuffer buffer) {
        try {
            byte[] bytes = RemoteComposeBuffer.readAllBytes(fd);
            buffer.reset(bytes.length);
            System.arraycopy(bytes, 0, buffer.mBuffer.mBuffer, 0, bytes.length);
            buffer.mBuffer.mSize = bytes.length;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] readAllBytes(@NonNull InputStream is) throws IOException {
        byte[] buff = new byte[32768];
        int red = 0;
        while (true) {
            int ret;
            if ((ret = is.read(buff, red, buff.length - red)) == -1) {
                is.close();
                return Arrays.copyOf(buff, red);
            }
            if ((red += ret) != buff.length) continue;
            buff = Arrays.copyOf(buff, buff.length * 2);
        }
    }

    public void addMatrixSkew(float skewX, float skewY) {
        MatrixSkew.apply(this.mBuffer, skewX, skewY);
    }

    public void addMatrixRestore() {
        MatrixRestore.apply(this.mBuffer);
    }

    public void addMatrixSave() {
        MatrixSave.apply(this.mBuffer);
    }

    public void addMatrixRotate(float angle, float centerX, float centerY) {
        MatrixRotate.apply(this.mBuffer, angle, centerX, centerY);
    }

    public void addMatrixTranslate(float dx, float dy) {
        MatrixTranslate.apply(this.mBuffer, dx, dy);
    }

    public void addMatrixScale(float scaleX, float scaleY) {
        MatrixScale.apply(this.mBuffer, scaleX, scaleY, Float.NaN, Float.NaN);
    }

    public void addMatrixScale(float scaleX, float scaleY, float centerX, float centerY) {
        MatrixScale.apply(this.mBuffer, scaleX, scaleY, centerX, centerY);
    }

    public void addClipPath(int pathId) {
        ClipPath.apply(this.mBuffer, pathId);
    }

    public void addClipRect(float left, float top, float right, float bottom) {
        ClipRect.apply(this.mBuffer, left, top, right, bottom);
    }

    public float addFloat(float value) {
        int id2 = this.mRemoteComposeState.cacheFloat(value);
        FloatConstant.apply(this.mBuffer, id2, value);
        return Utils.asNan(id2);
    }

    public float reserveFloatVariable() {
        int id2 = this.mRemoteComposeState.nextId();
        return Utils.asNan(id2);
    }

    public int addInteger(int value) {
        int id2 = this.mRemoteComposeState.cacheInteger(value);
        IntegerConstant.apply(this.mBuffer, id2, value);
        return id2;
    }

    public int addLong(long value) {
        int id2 = this.mRemoteComposeState.nextId();
        LongConstant.apply(this.mBuffer, id2, value);
        return id2;
    }

    public int addBoolean(boolean value) {
        int id2 = this.mRemoteComposeState.nextId();
        BooleanConstant.apply(this.mBuffer, id2, value);
        return id2;
    }

    public float asFloatId(int id2) {
        return Utils.asNan(id2);
    }

    public float addAnimatedFloat(float ... value) {
        int id2 = this.mRemoteComposeState.cacheData(value);
        FloatExpression.apply(this.mBuffer, id2, value, null);
        return Utils.asNan(id2);
    }

    public void addTouchExpression(float id2, float value, float min, float max, float velocityId, int touchEffects, float[] exp, int touchMode, float[] touchSpec, float[] easingSpec) {
        TouchExpression.apply(this.mBuffer, Utils.idFromNan(id2), value, min, max, velocityId, touchEffects, exp, touchMode, touchSpec, easingSpec);
    }

    public float addTouchExpression(float value, float min, float max, float velocityId, int touchEffects, float[] exp, int touchMode, float[] touchSpec, float[] easingSpec) {
        float id2 = Utils.asNan(this.mRemoteComposeState.nextId());
        this.addTouchExpression(id2, value, min, max, velocityId, touchEffects, exp, touchMode, touchSpec, easingSpec);
        return id2;
    }

    public float addAnimatedFloat(@NonNull float[] value, @Nullable float[] animation) {
        int id2 = this.mRemoteComposeState.cacheData(value);
        FloatExpression.apply(this.mBuffer, id2, value, animation);
        return Utils.asNan(id2);
    }

    public float textMeasure(int textId, int mode) {
        int id2 = this.mRemoteComposeState.cacheData(textId + mode * 31);
        TextMeasure.apply(this.mBuffer, id2, textId, mode);
        return Utils.asNan(id2);
    }

    public float textLength(int textId) {
        int id2 = this.mRemoteComposeState.cacheData(textId + (TextLength.id() << 16));
        TextLength.apply(this.mBuffer, id2, textId);
        return Utils.asNan(id2);
    }

    public float addFloatArray(@NonNull float[] values) {
        int id2 = this.mRemoteComposeState.cacheData(values, 2);
        DataListFloat.apply(this.mBuffer, id2, values);
        return Utils.asNan(id2);
    }

    public float addFloatList(@NonNull float[] values) {
        int[] listId = new int[values.length];
        for (int i = 0; i < listId.length; ++i) {
            listId[i] = this.mRemoteComposeState.cacheFloat(values[i]);
            FloatConstant.apply(this.mBuffer, listId[i], values[i]);
        }
        return this.addList(listId);
    }

    public float addList(@NonNull int[] listId) {
        int id2 = this.mRemoteComposeState.cacheData(listId, 2);
        DataListIds.apply(this.mBuffer, id2, listId);
        return Utils.asNan(id2);
    }

    public float addFloatMap(@NonNull String[] keys, @NonNull float[] values) {
        int[] listId = new int[values.length];
        byte[] type = new byte[values.length];
        for (int i = 0; i < listId.length; ++i) {
            listId[i] = this.mRemoteComposeState.cacheFloat(values[i]);
            FloatConstant.apply(this.mBuffer, listId[i], values[i]);
            type[i] = 2;
        }
        return this.addMap(keys, type, listId);
    }

    public int addMap(@NonNull String[] keys, @Nullable byte[] types, @NonNull int[] listId) {
        int id2 = this.mRemoteComposeState.cacheData(listId, 2);
        DataMapIds.apply(this.mBuffer, id2, keys, types, listId);
        return id2;
    }

    public int textLookup(float dataSet, float index) {
        long hash = ((long)Float.floatToRawIntBits(dataSet) << 32) + (long)Float.floatToRawIntBits(index);
        int id2 = this.mRemoteComposeState.cacheData(hash);
        TextLookup.apply(this.mBuffer, id2, Utils.idFromNan(dataSet), index);
        return id2;
    }

    public int textLookup(float dataSet, int index) {
        long hash = ((long)Float.floatToRawIntBits(dataSet) << 32) + (long)Float.floatToRawIntBits(index);
        int id2 = this.mRemoteComposeState.cacheData(hash);
        TextLookupInt.apply(this.mBuffer, id2, Utils.idFromNan(dataSet), index);
        return id2;
    }

    public int addIntegerExpression(int mask, @NonNull int[] value) {
        int id2 = this.mRemoteComposeState.cacheData(value);
        IntegerExpression.apply(this.mBuffer, id2, mask, value);
        return id2;
    }

    public int addColor(int color2) {
        ColorConstant c = new ColorConstant(0, color2);
        short id2 = (short)this.mRemoteComposeState.cacheData(c);
        c.mColorId = id2;
        c.write(this.mBuffer);
        return id2;
    }

    public short addColorExpression(int color1, int color2, float tween) {
        ColorExpression c = new ColorExpression(0, 0, color1, color2, tween);
        short id2 = (short)this.mRemoteComposeState.cacheData(c);
        c.mId = id2;
        c.write(this.mBuffer);
        return id2;
    }

    public short addColorExpression(short color1, int color2, float tween) {
        ColorExpression c = new ColorExpression(0, 1, color1, color2, tween);
        short id2 = (short)this.mRemoteComposeState.cacheData(c);
        c.mId = id2;
        c.write(this.mBuffer);
        return id2;
    }

    public short addColorExpression(int color1, short color2, float tween) {
        ColorExpression c = new ColorExpression(0, 2, color1, color2, tween);
        short id2 = (short)this.mRemoteComposeState.cacheData(c);
        c.mId = id2;
        c.write(this.mBuffer);
        return id2;
    }

    public short addColorExpression(short color1, short color2, float tween) {
        ColorExpression c = new ColorExpression(0, 3, color1, color2, tween);
        short id2 = (short)this.mRemoteComposeState.cacheData(c);
        c.mId = id2;
        c.write(this.mBuffer);
        return id2;
    }

    public short addColorExpression(float hue, float sat, float value) {
        ColorExpression c = new ColorExpression(0, hue, sat, value);
        short id2 = (short)this.mRemoteComposeState.cacheData(c);
        c.mId = id2;
        c.write(this.mBuffer);
        return id2;
    }

    public short addColorExpression(int alpha, float hue, float sat, float value) {
        ColorExpression c = new ColorExpression(0, 4, alpha, hue, sat, value);
        short id2 = (short)this.mRemoteComposeState.cacheData(c);
        c.mId = id2;
        c.write(this.mBuffer);
        return id2;
    }

    public short addColorExpression(float alpha, float red, float green, float blue) {
        ColorExpression c = new ColorExpression(0, 5, alpha, red, green, blue);
        short id2 = (short)this.mRemoteComposeState.cacheData(c);
        c.mId = id2;
        c.write(this.mBuffer);
        return id2;
    }

    @NonNull
    public static float[] packAnimation(float duration, int type, @Nullable float[] spec, float initialValue, float wrap) {
        return FloatAnimation.packToFloatArray(duration, type, spec, initialValue, wrap);
    }

    public void setNamedVariable(int id2, @NonNull String name, int type) {
        NamedVariable.apply(this.mBuffer, id2, type, name);
    }

    private int getComponentId(int id2) {
        int resolvedId = 0;
        if (id2 != -1) {
            resolvedId = id2;
        } else {
            --this.mGeneratedComponentId;
            resolvedId = this.mGeneratedComponentId;
        }
        return resolvedId;
    }

    public void addComponentStart(int type, int id2) {
        this.mLastComponentId = this.getComponentId(id2);
        ComponentStart.apply(this.mBuffer, type, this.mLastComponentId, 0.0f, 0.0f);
    }

    public void addComponentStart(int type) {
        this.addComponentStart(type, -1);
    }

    public void addContainerEnd() {
        ContainerEnd.apply(this.mBuffer);
    }

    public void addModifierScroll(int direction, float positionId, int notches) {
        float max = this.reserveFloatVariable();
        float notchMax = this.reserveFloatVariable();
        float touchExpressionDirection = direction != 0 ? RemoteContext.FLOAT_TOUCH_POS_X : RemoteContext.FLOAT_TOUCH_POS_Y;
        ScrollModifierOperation.apply(this.mBuffer, direction, positionId, max, notchMax);
        this.addTouchExpression(positionId, 0.0f, 0.0f, max, 0.0f, 3, new float[]{touchExpressionDirection, -1.0f, AnimatedFloatExpression.MUL}, 3, new float[]{notches, notchMax}, null);
        ContainerEnd.apply(this.mBuffer);
    }

    public void addModifierScroll(int direction, float positionId) {
        float max = this.reserveFloatVariable();
        float notchMax = this.reserveFloatVariable();
        float touchExpressionDirection = direction != 0 ? RemoteContext.FLOAT_TOUCH_POS_X : RemoteContext.FLOAT_TOUCH_POS_Y;
        ScrollModifierOperation.apply(this.mBuffer, direction, positionId, max, notchMax);
        this.addTouchExpression(positionId, 0.0f, 0.0f, max, 0.0f, 3, new float[]{touchExpressionDirection, -1.0f, AnimatedFloatExpression.MUL}, 0, null, null);
        ContainerEnd.apply(this.mBuffer);
    }

    public void addModifierScroll(int direction) {
        float max = this.reserveFloatVariable();
        ScrollModifierOperation.apply(this.mBuffer, direction, 0.0f, max, 0.0f);
        ContainerEnd.apply(this.mBuffer);
    }

    public void addModifierBackground(int color2, int shape) {
        float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color2 & 0xFF) / 255.0f;
        float a = (float)(color2 >> 24 & 0xFF) / 255.0f;
        BackgroundModifierOperation.apply(this.mBuffer, 0.0f, 0.0f, 0.0f, 0.0f, r, g, b, a, shape);
    }

    public void addModifierBorder(float borderWidth, float borderRoundedCorner, int color2, int shape) {
        float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color2 & 0xFF) / 255.0f;
        float a = (float)(color2 >> 24 & 0xFF) / 255.0f;
        BorderModifierOperation.apply(this.mBuffer, 0.0f, 0.0f, 0.0f, 0.0f, borderWidth, borderRoundedCorner, r, g, b, a, shape);
    }

    public void addModifierPadding(float left, float top, float right, float bottom) {
        PaddingModifierOperation.apply(this.mBuffer, left, top, right, bottom);
    }

    public void addModifierOffset(float x, float y) {
        OffsetModifierOperation.apply(this.mBuffer, x, y);
    }

    public void addModifierZIndex(float value) {
        ZIndexModifierOperation.apply(this.mBuffer, value);
    }

    public void addModifierRipple() {
        RippleModifierOperation.apply(this.mBuffer);
    }

    public void addModifierMarquee(int iterations, int animationMode, float repeatDelayMillis, float initialDelayMillis, float spacing, float velocity) {
        MarqueeModifierOperation.apply(this.mBuffer, iterations, animationMode, repeatDelayMillis, initialDelayMillis, spacing, velocity);
    }

    public void addModifierGraphicsLayer(HashMap<Integer, Object> attributes) {
        GraphicsLayerModifierOperation.apply(this.mBuffer, attributes);
    }

    public void addRoundClipRectModifier(float topStart, float topEnd, float bottomStart, float bottomEnd) {
        RoundedClipRectModifierOperation.apply(this.mBuffer, topStart, topEnd, bottomStart, bottomEnd);
    }

    public void addClipRectModifier() {
        ClipRectModifierOperation.apply(this.mBuffer);
    }

    public void addLoopStart(int indexId, float from, float step, float until) {
        LoopOperation.apply(this.mBuffer, indexId, from, step, until);
    }

    public void addLoopEnd() {
        ContainerEnd.apply(this.mBuffer);
    }

    public void addStateLayout(int componentId, int animationId, int horizontal, int vertical, int indexId) {
        this.mLastComponentId = this.getComponentId(componentId);
        StateLayout.apply(this.mBuffer, this.mLastComponentId, animationId, horizontal, vertical, indexId);
    }

    public void addBoxStart(int componentId, int animationId, int horizontal, int vertical) {
        this.mLastComponentId = this.getComponentId(componentId);
        BoxLayout.apply(this.mBuffer, this.mLastComponentId, animationId, horizontal, vertical);
    }

    public void addFitBoxStart(int componentId, int animationId, int horizontal, int vertical) {
        this.mLastComponentId = this.getComponentId(componentId);
        FitBoxLayout.apply(this.mBuffer, this.mLastComponentId, animationId, horizontal, vertical);
    }

    public void addImage(int componentId, int animationId, int bitmapId, int scaleType, float alpha) {
        this.mLastComponentId = this.getComponentId(componentId);
        ImageLayout.apply(this.mBuffer, componentId, animationId, bitmapId, scaleType, alpha);
    }

    public void addRowStart(int componentId, int animationId, int horizontal, int vertical, float spacedBy) {
        this.mLastComponentId = this.getComponentId(componentId);
        RowLayout.apply(this.mBuffer, this.mLastComponentId, animationId, horizontal, vertical, spacedBy);
    }

    public void addCollapsibleRowStart(int componentId, int animationId, int horizontal, int vertical, float spacedBy) {
        this.mLastComponentId = this.getComponentId(componentId);
        CollapsibleRowLayout.apply(this.mBuffer, this.mLastComponentId, animationId, horizontal, vertical, spacedBy);
    }

    public void addColumnStart(int componentId, int animationId, int horizontal, int vertical, float spacedBy) {
        this.mLastComponentId = this.getComponentId(componentId);
        ColumnLayout.apply(this.mBuffer, this.mLastComponentId, animationId, horizontal, vertical, spacedBy);
    }

    public void addCollapsibleColumnStart(int componentId, int animationId, int horizontal, int vertical, float spacedBy) {
        this.mLastComponentId = this.getComponentId(componentId);
        CollapsibleColumnLayout.apply(this.mBuffer, this.mLastComponentId, animationId, horizontal, vertical, spacedBy);
    }

    public void addCanvasStart(int componentId, int animationId) {
        this.mLastComponentId = this.getComponentId(componentId);
        CanvasLayout.apply(this.mBuffer, this.mLastComponentId, animationId);
    }

    public void addCanvasContentStart(int componentId) {
        this.mLastComponentId = this.getComponentId(componentId);
        CanvasContent.apply(this.mBuffer, this.mLastComponentId);
    }

    public void addRootStart() {
        this.mLastComponentId = this.getComponentId(-1);
        RootLayoutComponent.apply(this.mBuffer, this.mLastComponentId);
    }

    public void addContentStart() {
        this.mLastComponentId = this.getComponentId(-1);
        LayoutComponentContent.apply(this.mBuffer, this.mLastComponentId);
    }

    public void addCanvasOperationsStart() {
        CanvasOperations.apply(this.mBuffer);
    }

    public void addRunActionsStart() {
        RunActionOperation.apply(this.mBuffer);
    }

    public void addComponentWidthValue(int id2) {
        ComponentValue.apply(this.mBuffer, 0, this.mLastComponentId, id2);
    }

    public void addComponentHeightValue(int id2) {
        ComponentValue.apply(this.mBuffer, 1, this.mLastComponentId, id2);
    }

    public void addTextComponentStart(int componentId, int animationId, int textId, int color2, float fontSize, int fontStyle, float fontWeight, @Nullable String fontFamily, int textAlign, int overflow, int maxLines) {
        this.mLastComponentId = this.getComponentId(componentId);
        int fontFamilyId = -1;
        if (fontFamily != null) {
            fontFamilyId = this.addText(fontFamily);
        }
        TextLayout.apply(this.mBuffer, this.mLastComponentId, animationId, textId, color2, fontSize, fontStyle, fontWeight, fontFamilyId, textAlign, overflow, maxLines);
    }

    public int createID(int type) {
        return this.mRemoteComposeState.nextId(type);
    }

    public int nextId() {
        return this.mRemoteComposeState.nextId();
    }

    public void addImpulse(float duration, float start) {
        ImpulseOperation.apply(this.mBuffer, duration, start);
    }

    public void addImpulseProcess() {
        ImpulseProcess.apply(this.mBuffer);
    }

    public void addImpulseEnd() {
        ContainerEnd.apply(this.mBuffer);
    }

    public void addParticles(int id2, int[] varIds, float[][] initialExpressions, int particleCount) {
        ParticlesCreate.apply(this.mBuffer, id2, varIds, initialExpressions, particleCount);
    }

    public void addParticlesLoop(int id2, float[] restart, float[][] expressions) {
        ParticlesLoop.apply(this.mBuffer, id2, restart, expressions);
    }

    public void addParticleLoopEnd() {
        ContainerEnd.apply(this.mBuffer);
    }

    public void defineFloatFunction(int fid, int[] args) {
        FloatFunctionDefine.apply(this.mBuffer, fid, args);
    }

    public void addEndFloatFunctionDef() {
        ContainerEnd.apply(this.mBuffer);
    }

    public void callFloatFunction(int id2, float[] args) {
        FloatFunctionCall.apply(this.mBuffer, id2, args);
    }

    public float bitmapAttribute(int bitmapId, short attribute) {
        int id2 = this.mRemoteComposeState.nextId();
        ImageAttribute.apply(this.mBuffer, id2, bitmapId, attribute, null);
        return Utils.asNan(id2);
    }

    public float textAttribute(int textId, short attribute) {
        int id2 = this.mRemoteComposeState.nextId();
        TextAttribute.apply(this.mBuffer, id2, textId, attribute);
        return Utils.asNan(id2);
    }

    public float timeAttribute(int timeId, short attribute, int ... args) {
        int id2 = this.mRemoteComposeState.nextId();
        TimeAttribute.apply(this.mBuffer, id2, timeId, attribute, args);
        return Utils.asNan(id2);
    }

    public void drawComponentContent() {
        DrawContent.apply(this.mBuffer);
    }

    private int storeBitmap(Object image) {
        int imageId = this.mRemoteComposeState.dataGetId(image);
        if (imageId == -1) {
            imageId = this.mRemoteComposeState.cacheData(image);
            byte[] data = this.mPlatform.imageToByteArray(image);
            short imageWidth = (short)this.mPlatform.getImageWidth(image);
            short imageHeight = (short)this.mPlatform.getImageHeight(image);
            if (this.mPlatform.isAlpha8Image(image)) {
                BitmapData.apply(this.mBuffer, imageId, (short)4, imageWidth, (short)0, imageHeight, data);
            } else {
                BitmapData.apply(this.mBuffer, imageId, imageWidth, imageHeight, data);
            }
        }
        return imageId;
    }

    public void pathCombine(int id2, int path1, int path2, byte op) {
        PathCombine.apply(this.mBuffer, id2, path1, path2, op);
    }

    public void performHaptic(int feedbackConstant) {
        HapticFeedback.apply(this.mBuffer, feedbackConstant);
    }

    public void addConditionalOperations(byte type, float a, float b) {
        ConditionalOperations.apply(this.mBuffer, type, a, b);
    }

    public void addDebugMessage(int textId, float value, int flags) {
        DebugMessage.apply(this.mBuffer, textId, value, flags);
    }

    public float getColorAttribute(int baseColor, short type) {
        int id2 = this.mRemoteComposeState.nextId();
        ColorAttribute.apply(this.mBuffer, id2, baseColor, type);
        return Utils.asNan(id2);
    }
}

