/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.Nullable;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.RemoteViews;
import com.android.internal.hidden_from_bootclasspath.android.app.Flags;
import com.android.internal.widget.CachingIconView;

@RemoteViews.RemoteView
public class NotificationRowIconView
extends CachingIconView {
    private NotificationIconProvider mIconProvider;
    private Drawable mAppIcon = null;
    private Rect mOriginalPadding = null;
    private Drawable mOriginalBackground = null;
    private int mOriginalBackgroundColor = 1;
    private int mOriginalIconColor = 1;

    public NotificationRowIconView(Context context) {
        super(context);
    }

    public NotificationRowIconView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public NotificationRowIconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public NotificationRowIconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setIconProvider(NotificationIconProvider iconProvider) {
        this.mIconProvider = iconProvider;
    }

    private Drawable loadAppIcon() {
        if (this.mIconProvider != null && this.mIconProvider.shouldShowAppIcon()) {
            return this.mIconProvider.getAppIcon();
        }
        return null;
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(Icon icon) {
        if (Flags.notificationsRedesignAppIcons()) {
            if (this.mAppIcon != null) {
                return;
            }
            this.mAppIcon = this.loadAppIcon();
            if (this.mAppIcon != null) {
                this.setImageDrawable(this.mAppIcon);
                this.adjustViewForAppIcon();
            } else {
                super.setImageIcon(icon);
                this.restoreViewForSmallIcon();
            }
            return;
        }
        super.setImageIcon(icon);
    }

    @Override
    @RemotableViewMethod
    public Runnable setImageIconAsync(Icon icon) {
        if (Flags.notificationsRedesignAppIcons()) {
            if (this.mAppIcon != null) {
                return () -> {};
            }
            this.mAppIcon = this.loadAppIcon();
            if (this.mAppIcon != null) {
                return () -> {
                    this.setImageDrawable(this.mAppIcon);
                    this.adjustViewForAppIcon();
                };
            }
            return () -> {
                super.setImageIcon(icon);
                this.restoreViewForSmallIcon();
            };
        }
        return super.setImageIconAsync(icon);
    }

    private void adjustViewForAppIcon() {
        this.removePadding();
        this.removeBackground();
    }

    private void restoreViewForSmallIcon() {
        this.restorePadding();
        this.restoreBackground();
        this.restoreColors();
    }

    private void removePadding() {
        if (this.mOriginalPadding == null) {
            this.mOriginalPadding = new Rect(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
        this.setPadding(0, 0, 0, 0);
    }

    private void restorePadding() {
        if (this.mOriginalPadding != null) {
            this.setPadding(this.mOriginalPadding.left, this.mOriginalPadding.top, this.mOriginalPadding.right, this.mOriginalPadding.bottom);
            this.mOriginalPadding = null;
        }
    }

    private void removeBackground() {
        if (this.mOriginalBackground == null) {
            this.mOriginalBackground = this.getBackground();
        }
        this.setBackground(null);
    }

    private void restoreBackground() {
        if (this.mOriginalBackground != null) {
            this.setBackground(this.mOriginalBackground);
            this.mOriginalBackground = null;
        }
    }

    private void restoreColors() {
        if (this.mOriginalBackgroundColor != 1) {
            super.setBackgroundColor(this.mOriginalBackgroundColor);
            this.mOriginalBackgroundColor = 1;
        }
        if (this.mOriginalIconColor != 1) {
            super.setOriginalIconColor(this.mOriginalIconColor);
            this.mOriginalIconColor = 1;
        }
    }

    @Override
    @RemotableViewMethod
    public void setBackgroundColor(int color2) {
        if (this.mAppIcon == null) {
            super.setBackgroundColor(color2);
        } else {
            this.mOriginalBackgroundColor = color2;
        }
    }

    @Override
    @RemotableViewMethod
    public void setOriginalIconColor(int color2) {
        if (this.mAppIcon == null) {
            super.setOriginalIconColor(color2);
        } else {
            this.mOriginalIconColor = color2;
        }
    }

    public static interface NotificationIconProvider {
        public boolean shouldShowAppIcon();

        @Nullable
        public Drawable getAppIcon();
    }
}

