/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.Notification;
import android.os.Bundle;
import com.android.internal.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@FlaggedApi(value="android.app.api_rich_ongoing")
public class NotificationProgressModel {
    public static final int INVALID_COLOR = 0;
    private static final String KEY_SEGMENTS = "segments";
    private static final String KEY_POINTS = "points";
    private static final String KEY_PROGRESS = "progress";
    private static final String KEY_IS_STYLED_BY_PROGRESS = "isStyledByProgress";
    private static final String KEY_SEGMENTS_FALLBACK_COLOR = "segmentsFallColor";
    private static final String KEY_INDETERMINATE_COLOR = "indeterminateColor";
    private final List<Notification.ProgressStyle.Segment> mSegments;
    private final List<Notification.ProgressStyle.Point> mPoints;
    private final int mProgress;
    private final boolean mIsStyledByProgress;
    private final int mSegmentsFallbackColor;
    private final int mIndeterminateColor;

    public NotificationProgressModel(@NonNull List<Notification.ProgressStyle.Segment> segments, @NonNull List<Notification.ProgressStyle.Point> points, int progress, boolean isStyledByProgress, int segmentsFallbackColor) {
        Preconditions.checkArgument(progress >= 0);
        Preconditions.checkArgument(!segments.isEmpty());
        this.mSegments = segments;
        this.mPoints = points;
        this.mProgress = progress;
        this.mIsStyledByProgress = isStyledByProgress;
        this.mSegmentsFallbackColor = segmentsFallbackColor;
        this.mIndeterminateColor = 0;
    }

    public NotificationProgressModel(int indeterminateColor) {
        Preconditions.checkArgument(indeterminateColor != 0);
        this.mSegments = Collections.emptyList();
        this.mPoints = Collections.emptyList();
        this.mProgress = 0;
        this.mIsStyledByProgress = false;
        this.mSegmentsFallbackColor = 0;
        this.mIndeterminateColor = indeterminateColor;
    }

    public List<Notification.ProgressStyle.Segment> getSegments() {
        return this.mSegments;
    }

    public List<Notification.ProgressStyle.Point> getPoints() {
        return this.mPoints;
    }

    public int getProgress() {
        return this.mProgress;
    }

    public int getProgressMax() {
        return this.mSegments.stream().mapToInt(Notification.ProgressStyle.Segment::getLength).sum();
    }

    public boolean isStyledByProgress() {
        return this.mIsStyledByProgress;
    }

    public int getSegmentsFallbackColor() {
        return this.mSegmentsFallbackColor;
    }

    public int getIndeterminateColor() {
        return this.mIndeterminateColor;
    }

    public boolean isIndeterminate() {
        return this.mIndeterminateColor != 0;
    }

    @NonNull
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        if (this.mIndeterminateColor != 0) {
            bundle.putInt(KEY_INDETERMINATE_COLOR, this.mIndeterminateColor);
        } else {
            bundle.putParcelableList(KEY_SEGMENTS, Notification.ProgressStyle.getProgressSegmentsAsBundleList(this.mSegments));
            bundle.putParcelableList(KEY_POINTS, Notification.ProgressStyle.getProgressPointsAsBundleList(this.mPoints));
            bundle.putInt(KEY_PROGRESS, this.mProgress);
            bundle.putBoolean(KEY_IS_STYLED_BY_PROGRESS, this.mIsStyledByProgress);
            if (this.mSegmentsFallbackColor != 0) {
                bundle.putInt(KEY_SEGMENTS_FALLBACK_COLOR, this.mSegmentsFallbackColor);
            }
        }
        return bundle;
    }

    @NonNull
    public static NotificationProgressModel fromBundle(@NonNull Bundle bundle) {
        int indeterminateColor = bundle.getInt(KEY_INDETERMINATE_COLOR, 0);
        if (indeterminateColor != 0) {
            return new NotificationProgressModel(indeterminateColor);
        }
        List<Notification.ProgressStyle.Segment> segments = Notification.ProgressStyle.getProgressSegmentsFromBundleList(bundle.getParcelableArrayList(KEY_SEGMENTS, Bundle.class));
        List<Notification.ProgressStyle.Point> points = Notification.ProgressStyle.getProgressPointsFromBundleList(bundle.getParcelableArrayList(KEY_POINTS, Bundle.class));
        int progress = bundle.getInt(KEY_PROGRESS);
        boolean isStyledByProgress = bundle.getBoolean(KEY_IS_STYLED_BY_PROGRESS);
        int segmentsFallbackColor = bundle.getInt(KEY_SEGMENTS_FALLBACK_COLOR, 0);
        return new NotificationProgressModel(segments, points, progress, isStyledByProgress, segmentsFallbackColor);
    }

    public String toString() {
        return "NotificationProgressModel{mSegments=" + this.mSegments + ", mPoints=" + this.mPoints + ", mProgress=" + this.mProgress + ", mIsStyledByProgress=" + this.mIsStyledByProgress + ", mSegmentsFallbackColor=" + this.mSegmentsFallbackColor + ", mIndeterminateColor=" + this.mIndeterminateColor + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationProgressModel that = (NotificationProgressModel)o;
        return this.mProgress == that.mProgress && this.mIsStyledByProgress == that.mIsStyledByProgress && this.mSegmentsFallbackColor == that.mSegmentsFallbackColor && this.mIndeterminateColor == that.mIndeterminateColor && Objects.equals(this.mSegments, that.mSegments) && Objects.equals(this.mPoints, that.mPoints);
    }

    public int hashCode() {
        return Objects.hash(this.mSegments, this.mPoints, this.mProgress, this.mIsStyledByProgress, this.mSegmentsFallbackColor, this.mIndeterminateColor);
    }
}

