/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.util.EventLog;
import android.view.SurfaceHolder;

public class SurfaceCallbackHelper {
    private static final int LOGTAG_SURFACEVIEW_CALLBACK = 60006;
    private final String mTag;
    private boolean mSurfaceRedrawImplemented;
    Runnable mRunnable;
    int mFinishDrawingCollected = 0;
    int mFinishDrawingExpected = 0;
    private Runnable mFinishDrawingRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SurfaceCallbackHelper surfaceCallbackHelper = SurfaceCallbackHelper.this;
            synchronized (surfaceCallbackHelper) {
                ++SurfaceCallbackHelper.this.mFinishDrawingCollected;
                if (SurfaceCallbackHelper.this.mFinishDrawingCollected < SurfaceCallbackHelper.this.mFinishDrawingExpected) {
                    return;
                }
                SurfaceCallbackHelper.this.mRunnable.run();
                if (SurfaceCallbackHelper.this.mSurfaceRedrawImplemented && SurfaceCallbackHelper.this.mTag != null) {
                    EventLog.writeEvent(60006, SurfaceCallbackHelper.this.mTag, "surfaceRedrawNeeded implemented");
                }
            }
        }
    };

    public SurfaceCallbackHelper(Runnable callbacksCollected) {
        this(callbacksCollected, null);
    }

    public SurfaceCallbackHelper(Runnable callbacksCollected, String tag) {
        this.mRunnable = callbacksCollected;
        this.mTag = tag;
        this.mSurfaceRedrawImplemented = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchSurfaceRedrawNeededAsync(SurfaceHolder holder, SurfaceHolder.Callback[] callbacks) {
        if (callbacks == null || callbacks.length == 0) {
            this.mRunnable.run();
            return;
        }
        SurfaceHolder.Callback[] callbackArray = this;
        synchronized (this) {
            this.mFinishDrawingExpected = callbacks.length;
            this.mFinishDrawingCollected = 0;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (SurfaceHolder.Callback c : callbacks) {
                if (c instanceof SurfaceHolder.Callback2) {
                    ((SurfaceHolder.Callback2)c).surfaceRedrawNeededAsync(holder, this.mFinishDrawingRunnable);
                    this.mSurfaceRedrawImplemented = true;
                    continue;
                }
                this.mFinishDrawingRunnable.run();
            }
            return;
        }
    }
}

