/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.os.VibrationEffect;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class SerializedBasicEnvelopeEffect
implements SerializedComposedEffect.SerializedSegment {
    private final BasicControlPoint[] mControlPoints;
    private final float mInitialSharpness;

    SerializedBasicEnvelopeEffect(BasicControlPoint[] controlPoints, float initialSharpness) {
        this.mControlPoints = controlPoints;
        this.mInitialSharpness = initialSharpness;
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "basic-envelope-effect");
        if (!Float.isNaN(this.mInitialSharpness)) {
            serializer.attributeFloat(XmlConstants.NAMESPACE, "initialSharpness", this.mInitialSharpness);
        }
        for (BasicControlPoint point : this.mControlPoints) {
            serializer.startTag(XmlConstants.NAMESPACE, "control-point");
            serializer.attributeFloat(XmlConstants.NAMESPACE, "intensity", point.mIntensity);
            serializer.attributeFloat(XmlConstants.NAMESPACE, "sharpness", point.mSharpness);
            serializer.attributeLong(XmlConstants.NAMESPACE, "durationMs", point.mDurationMs);
            serializer.endTag(XmlConstants.NAMESPACE, "control-point");
        }
        serializer.endTag(XmlConstants.NAMESPACE, "basic-envelope-effect");
    }

    @Override
    public void deserializeIntoComposition(@NonNull VibrationEffect.Composition composition) {
        VibrationEffect.BasicEnvelopeBuilder builder = new VibrationEffect.BasicEnvelopeBuilder();
        if (!Float.isNaN(this.mInitialSharpness)) {
            builder.setInitialSharpness(this.mInitialSharpness);
        }
        for (BasicControlPoint point : this.mControlPoints) {
            builder.addControlPoint(point.mIntensity, point.mSharpness, point.mDurationMs);
        }
        composition.addEffect(builder.build());
    }

    public String toString() {
        return "SerializedBasicEnvelopeEffect{initialSharpness=" + (Float.isNaN(this.mInitialSharpness) ? "" : Float.valueOf(this.mInitialSharpness)) + ", controlPoints=" + Arrays.toString(this.mControlPoints) + '}';
    }

    private static class BasicControlPoint {
        private final float mIntensity;
        private final float mSharpness;
        private final long mDurationMs;

        BasicControlPoint(float intensity, float sharpness, long durationMs) {
            this.mIntensity = intensity;
            this.mSharpness = sharpness;
            this.mDurationMs = durationMs;
        }

        public String toString() {
            return String.format(Locale.ROOT, "(%.2f, %.2f, %dms)", Float.valueOf(this.mIntensity), Float.valueOf(this.mSharpness), this.mDurationMs);
        }
    }

    static class Parser {
        Parser() {
        }

        @NonNull
        static SerializedBasicEnvelopeEffect parseNext(@NonNull TypedXmlPullParser parser, int flags) throws XmlParserException, IOException {
            XmlValidator.checkStartTag(parser, "basic-envelope-effect");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "initialSharpness");
            Builder builder = new Builder();
            builder.setInitialSharpness(XmlReader.readAttributeFloatInRange(parser, "initialSharpness", 0.0f, 1.0f, Float.NaN));
            int outerDepth = parser.getDepth();
            while (XmlReader.readNextTagWithin(parser, outerDepth)) {
                Parser.parseControlPoint(parser, builder);
                XmlReader.readEndTag(parser);
            }
            XmlValidator.checkParserCondition(!builder.mControlPoints.isEmpty(), "Expected tag %s to have at least one control point", "basic-envelope-effect");
            XmlValidator.checkParserCondition(builder.mControlPoints.getLast().mIntensity == 0.0f, "Basic envelope effects must end at a zero intensity control point", new Object[0]);
            return builder.build();
        }

        private static void parseControlPoint(TypedXmlPullParser parser, Builder builder) throws XmlParserException {
            XmlValidator.checkStartTag(parser, "control-point");
            XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "durationMs", "intensity", "sharpness");
            float intensity = XmlReader.readAttributeFloatInRange(parser, "intensity", 0.0f, 1.0f);
            float sharpness = XmlReader.readAttributeFloatInRange(parser, "sharpness", 0.0f, 1.0f);
            long durationMs = XmlReader.readAttributePositiveLong(parser, "durationMs");
            builder.addControlPoint(intensity, sharpness, durationMs);
        }
    }

    static class Builder {
        private final List<BasicControlPoint> mControlPoints;
        private float mInitialSharpness = Float.NaN;

        Builder() {
            this.mControlPoints = new ArrayList<BasicControlPoint>();
        }

        void setInitialSharpness(float sharpness) {
            this.mInitialSharpness = sharpness;
        }

        void addControlPoint(float intensity, float sharpness, long durationMs) {
            this.mControlPoints.add(new BasicControlPoint(intensity, sharpness, durationMs));
        }

        SerializedBasicEnvelopeEffect build() {
            return new SerializedBasicEnvelopeEffect(this.mControlPoints.toArray(new BasicControlPoint[0]), this.mInitialSharpness);
        }
    }
}

