/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Xml;
import com.android.internal.util.HexDump;
import com.android.internal.util.XmlPullParserWrapper;
import com.android.internal.util.XmlSerializerWrapper;
import com.android.internal.util.XmlUtils_Delegate;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libcore.util.HexEncoding;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@RavenwoodKeepWholeClass
public class XmlUtils {
    private static final String STRING_ARRAY_SEPARATOR = ":";

    @NonNull
    public static TypedXmlSerializer makeTyped(@NonNull XmlSerializer xml2) {
        if (xml2 instanceof TypedXmlSerializer) {
            return (TypedXmlSerializer)xml2;
        }
        return new ForcedTypedXmlSerializer(xml2);
    }

    @NonNull
    public static TypedXmlPullParser makeTyped(@NonNull XmlPullParser xml2) {
        if (xml2 instanceof TypedXmlPullParser) {
            return (TypedXmlPullParser)xml2;
        }
        return new ForcedTypedXmlPullParser(xml2);
    }

    @UnsupportedAppUsage
    public static void skipCurrentTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
        }
    }

    public static int convertValueToList(CharSequence value, String[] options, int defaultValue) {
        if (!TextUtils.isEmpty(value)) {
            for (int i = 0; i < options.length; ++i) {
                if (!value.equals(options[i])) continue;
                return i;
            }
        }
        return defaultValue;
    }

    @UnsupportedAppUsage
    public static boolean convertValueToBoolean(CharSequence value, boolean defaultValue) {
        boolean result = false;
        if (TextUtils.isEmpty(value)) {
            return defaultValue;
        }
        if (value.equals("1") || value.equals("true") || value.equals("TRUE")) {
            result = true;
        }
        return result;
    }

    @UnsupportedAppUsage
    public static int convertValueToInt_Original(CharSequence charSeq, int defaultValue) {
        if (TextUtils.isEmpty(charSeq)) {
            return defaultValue;
        }
        String nm = charSeq.toString();
        int sign = 1;
        int index = 0;
        int len = nm.length();
        int base = 10;
        if ('-' == nm.charAt(0)) {
            sign = -1;
            ++index;
        }
        if ('0' == nm.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = nm.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == nm.charAt(index)) {
            ++index;
            base = 16;
        }
        return Integer.parseInt(nm.substring(index), base) * sign;
    }

    @LayoutlibDelegate
    public static int convertValueToInt(CharSequence charSequence, int n) {
        return XmlUtils_Delegate.convertValueToInt(charSequence, n);
    }

    public static int convertValueToUnsignedInt(String value, int defaultValue) {
        if (TextUtils.isEmpty(value)) {
            return defaultValue;
        }
        return XmlUtils.parseUnsignedIntAttribute(value);
    }

    public static int parseUnsignedIntAttribute(CharSequence charSeq) {
        String value = charSeq.toString();
        int index = 0;
        int len = value.length();
        int base = 10;
        if ('0' == value.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = value.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == value.charAt(index)) {
            ++index;
            base = 16;
        }
        return (int)Long.parseLong(value.substring(index), base);
    }

    @UnsupportedAppUsage
    public static void writeMapXml(Map val, OutputStream out) throws XmlPullParserException, IOException {
        TypedXmlSerializer serializer = Xml.newFastSerializer();
        serializer.setOutput(out, StandardCharsets.UTF_8.name());
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeMapXml(val, null, serializer);
        serializer.endDocument();
    }

    public static void writeListXml(List val, OutputStream out) throws XmlPullParserException, IOException {
        TypedXmlSerializer serializer = Xml.newFastSerializer();
        serializer.setOutput(out, StandardCharsets.UTF_8.name());
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeListXml(val, null, serializer);
        serializer.endDocument();
    }

    public static void writeMapXml(Map val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        XmlUtils.writeMapXml(val, name, out, null);
    }

    public static void writeMapXml(Map val, String name, TypedXmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "map");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        XmlUtils.writeMapXml(val, out, callback);
        out.endTag(null, "map");
    }

    public static void writeMapXml(Map val, TypedXmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        if (val == null) {
            return;
        }
        Set s = val.entrySet();
        for (Map.Entry e : s) {
            XmlUtils.writeValueXml(e.getValue(), (String)e.getKey(), out, callback);
        }
    }

    public static void writeListXml(List val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "list");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N2 = val.size();
        for (int i = 0; i < N2; ++i) {
            XmlUtils.writeValueXml(val.get(i), null, out);
        }
        out.endTag(null, "list");
    }

    public static void writeSetXml(Set val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "set");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        for (Object v : val) {
            XmlUtils.writeValueXml(v, null, out);
        }
        out.endTag(null, "set");
    }

    public static void writeByteArrayXml(byte[] val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "byte-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N2 = val.length;
        out.attributeInt(null, "num", N2);
        out.text(HexEncoding.encodeToString(val).toLowerCase());
        out.endTag(null, "byte-array");
    }

    public static void writeIntArrayXml(int[] val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "int-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N2 = val.length;
        out.attributeInt(null, "num", N2);
        for (int i = 0; i < N2; ++i) {
            out.startTag(null, "item");
            out.attributeInt(null, "value", val[i]);
            out.endTag(null, "item");
        }
        out.endTag(null, "int-array");
    }

    public static void writeLongArrayXml(long[] val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "long-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N2 = val.length;
        out.attributeInt(null, "num", N2);
        for (int i = 0; i < N2; ++i) {
            out.startTag(null, "item");
            out.attributeLong(null, "value", val[i]);
            out.endTag(null, "item");
        }
        out.endTag(null, "long-array");
    }

    public static void writeDoubleArrayXml(double[] val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "double-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N2 = val.length;
        out.attributeInt(null, "num", N2);
        for (int i = 0; i < N2; ++i) {
            out.startTag(null, "item");
            out.attributeDouble(null, "value", val[i]);
            out.endTag(null, "item");
        }
        out.endTag(null, "double-array");
    }

    public static void writeStringArrayXml(String[] val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "string-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N2 = val.length;
        out.attributeInt(null, "num", N2);
        for (int i = 0; i < N2; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", val[i]);
            out.endTag(null, "item");
        }
        out.endTag(null, "string-array");
    }

    public static void writeBooleanArrayXml(boolean[] val, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "boolean-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N2 = val.length;
        out.attributeInt(null, "num", N2);
        for (int i = 0; i < N2; ++i) {
            out.startTag(null, "item");
            out.attributeBoolean(null, "value", val[i]);
            out.endTag(null, "item");
        }
        out.endTag(null, "boolean-array");
    }

    @Deprecated
    public static void writeValueXml(Object v, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        XmlUtils.writeValueXml(v, name, XmlUtils.makeTyped(out));
    }

    public static void writeValueXml(Object v, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        XmlUtils.writeValueXml(v, name, out, null);
    }

    private static void writeValueXml(Object v, String name, TypedXmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        if (v == null) {
            out.startTag(null, "null");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.endTag(null, "null");
            return;
        }
        if (v instanceof String) {
            out.startTag(null, "string");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.text(v.toString());
            out.endTag(null, "string");
            return;
        }
        if (v instanceof Integer) {
            out.startTag(null, "int");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.attributeInt(null, "value", (Integer)v);
            out.endTag(null, "int");
        } else if (v instanceof Long) {
            out.startTag(null, "long");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.attributeLong(null, "value", (Long)v);
            out.endTag(null, "long");
        } else if (v instanceof Float) {
            out.startTag(null, "float");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.attributeFloat(null, "value", ((Float)v).floatValue());
            out.endTag(null, "float");
        } else if (v instanceof Double) {
            out.startTag(null, "double");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.attributeDouble(null, "value", (Double)v);
            out.endTag(null, "double");
        } else if (v instanceof Boolean) {
            out.startTag(null, "boolean");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.attributeBoolean(null, "value", (Boolean)v);
            out.endTag(null, "boolean");
        } else {
            if (v instanceof byte[]) {
                XmlUtils.writeByteArrayXml((byte[])v, name, out);
                return;
            }
            if (v instanceof int[]) {
                XmlUtils.writeIntArrayXml((int[])v, name, out);
                return;
            }
            if (v instanceof long[]) {
                XmlUtils.writeLongArrayXml((long[])v, name, out);
                return;
            }
            if (v instanceof double[]) {
                XmlUtils.writeDoubleArrayXml((double[])v, name, out);
                return;
            }
            if (v instanceof String[]) {
                XmlUtils.writeStringArrayXml((String[])v, name, out);
                return;
            }
            if (v instanceof boolean[]) {
                XmlUtils.writeBooleanArrayXml((boolean[])v, name, out);
                return;
            }
            if (v instanceof Map) {
                XmlUtils.writeMapXml((Map)v, name, out);
                return;
            }
            if (v instanceof List) {
                XmlUtils.writeListXml((List)v, name, out);
                return;
            }
            if (v instanceof Set) {
                XmlUtils.writeSetXml((Set)v, name, out);
                return;
            }
            if (v instanceof CharSequence) {
                out.startTag(null, "string");
                if (name != null) {
                    out.attribute(null, "name", name);
                }
                out.text(v.toString());
                out.endTag(null, "string");
                return;
            }
            if (callback != null) {
                callback.writeUnknownObject(v, name, out);
                return;
            }
            throw new RuntimeException("writeValueXml: unable to write value " + v);
        }
    }

    @UnsupportedAppUsage
    public static HashMap<String, ?> readMapXml(InputStream in) throws XmlPullParserException, IOException {
        TypedXmlPullParser parser = Xml.newFastPullParser();
        parser.setInput(in, StandardCharsets.UTF_8.name());
        return (HashMap)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static ArrayList readListXml(InputStream in) throws XmlPullParserException, IOException {
        TypedXmlPullParser parser = Xml.newFastPullParser();
        parser.setInput(in, StandardCharsets.UTF_8.name());
        return (ArrayList)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static HashSet readSetXml(InputStream in) throws XmlPullParserException, IOException {
        TypedXmlPullParser parser = Xml.newFastPullParser();
        parser.setInput(in, StandardCharsets.UTF_8.name());
        return (HashSet)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static HashMap<String, ?> readThisMapXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisMapXml(parser, endTag, name, null);
    }

    public static HashMap<String, ?> readThisMapXml(TypedXmlPullParser parser, String endTag, String[] name, ReadMapCallback callback) throws XmlPullParserException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, false);
                map.put(name[0], val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return map;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static ArrayMap<String, ?> readThisArrayMapXml(TypedXmlPullParser parser, String endTag, String[] name, ReadMapCallback callback) throws XmlPullParserException, IOException {
        ArrayMap<String, Object> map = new ArrayMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, true);
                map.put(name[0], val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return map;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static ArrayList readThisListXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisListXml(parser, endTag, name, null, false);
    }

    private static ArrayList readThisListXml(TypedXmlPullParser parser, String endTag, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, arrayMap);
                list.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return list;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static HashSet readThisSetXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisSetXml(parser, endTag, name, null, false);
    }

    private static HashSet readThisSetXml(TypedXmlPullParser parser, String endTag, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        HashSet<Object> set = new HashSet<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, arrayMap);
                set.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return set;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static byte[] readThisByteArrayXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num = parser.getAttributeInt(null, "num");
        byte[] array2 = new byte[]{};
        int eventType = parser.getEventType();
        do {
            if (eventType == 4) {
                if (num > 0) {
                    String values = parser.getText();
                    if (values == null || values.length() != num * 2) {
                        throw new XmlPullParserException("Invalid value found in byte-array: " + values);
                    }
                    array2 = HexEncoding.decode(values);
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] readThisIntArrayXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num = parser.getAttributeInt(null, "num");
        parser.next();
        int[] array2 = new int[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                array2[i] = parser.getAttributeInt(null, "value");
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long[] readThisLongArrayXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num = parser.getAttributeInt(null, "num");
        parser.next();
        long[] array2 = new long[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                array2[i] = parser.getAttributeLong(null, "value");
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] readThisDoubleArrayXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num = parser.getAttributeInt(null, "num");
        parser.next();
        double[] array2 = new double[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                array2[i] = parser.getAttributeDouble(null, "value");
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] readThisStringArrayXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num = parser.getAttributeInt(null, "num");
        parser.next();
        String[] array2 = new String[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                array2[i] = parser.getAttributeValue(null, "value");
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean[] readThisBooleanArrayXml(TypedXmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num = parser.getAttributeInt(null, "num");
        parser.next();
        boolean[] array2 = new boolean[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                array2[i] = parser.getAttributeBoolean(null, "value");
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static Object readValueXml(TypedXmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                return XmlUtils.readThisValueXml(parser, name, null, false);
            }
            if (eventType == 3) {
                throw new XmlPullParserException("Unexpected end tag at: " + parser.getName());
            }
            if (eventType == 4) {
                throw new XmlPullParserException("Unexpected text: " + parser.getText());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Unexpected end of document");
    }

    private static Object readThisValueXml(TypedXmlPullParser parser, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        String tagName;
        block23: {
            int eventType;
            Object res;
            String valueName = parser.getAttributeValue(null, "name");
            tagName = parser.getName();
            if (tagName.equals("null")) {
                res = null;
            } else {
                if (tagName.equals("string")) {
                    block22: {
                        StringBuilder value = new StringBuilder();
                        while (true) {
                            int eventType2 = parser.next();
                            if (eventType2 == 1) break block22;
                            if (eventType2 == 3) {
                                if (parser.getName().equals("string")) {
                                    name[0] = valueName;
                                    return value.toString();
                                }
                                throw new XmlPullParserException("Unexpected end tag in <string>: " + parser.getName());
                            }
                            if (eventType2 == 4) {
                                value.append(parser.getText());
                                continue;
                            }
                            if (eventType2 == 2) break;
                        }
                        throw new XmlPullParserException("Unexpected start tag in <string>: " + parser.getName());
                    }
                    throw new XmlPullParserException("Unexpected end of document in <string>");
                }
                res = XmlUtils.readThisPrimitiveValueXml(parser, tagName);
                if (res == null) {
                    if (tagName.equals("byte-array")) {
                        res = XmlUtils.readThisByteArrayXml(parser, "byte-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("int-array")) {
                        res = XmlUtils.readThisIntArrayXml(parser, "int-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("long-array")) {
                        res = XmlUtils.readThisLongArrayXml(parser, "long-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("double-array")) {
                        res = XmlUtils.readThisDoubleArrayXml(parser, "double-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("string-array")) {
                        res = XmlUtils.readThisStringArrayXml(parser, "string-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("boolean-array")) {
                        res = XmlUtils.readThisBooleanArrayXml(parser, "boolean-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("map")) {
                        parser.next();
                        res = arrayMap ? XmlUtils.readThisArrayMapXml(parser, "map", name, callback) : XmlUtils.readThisMapXml(parser, "map", name, callback);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("list")) {
                        parser.next();
                        res = XmlUtils.readThisListXml(parser, "list", name, callback, arrayMap);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("set")) {
                        parser.next();
                        res = XmlUtils.readThisSetXml(parser, "set", name, callback, arrayMap);
                        name[0] = valueName;
                        return res;
                    }
                    if (callback != null) {
                        res = callback.readThisUnknownObjectXml(parser, tagName);
                        name[0] = valueName;
                        return res;
                    }
                    throw new XmlPullParserException("Unknown tag: " + tagName);
                }
            }
            do {
                eventType = parser.next();
                if (eventType == 1) break block23;
                if (eventType == 3) {
                    if (parser.getName().equals(tagName)) {
                        name[0] = valueName;
                        return res;
                    }
                    throw new XmlPullParserException("Unexpected end tag in <" + tagName + ">: " + parser.getName());
                }
                if (eventType == 4) {
                    throw new XmlPullParserException("Unexpected text in <" + tagName + ">: " + parser.getName());
                }
            } while (eventType != 2);
            throw new XmlPullParserException("Unexpected start tag in <" + tagName + ">: " + parser.getName());
        }
        throw new XmlPullParserException("Unexpected end of document in <" + tagName + ">");
    }

    private static Object readThisPrimitiveValueXml(TypedXmlPullParser parser, String tagName) throws XmlPullParserException, IOException {
        if (tagName.equals("int")) {
            return parser.getAttributeInt(null, "value");
        }
        if (tagName.equals("long")) {
            return parser.getAttributeLong(null, "value");
        }
        if (tagName.equals("float")) {
            return Float.valueOf(parser.getAttributeFloat(null, "value"));
        }
        if (tagName.equals("double")) {
            return parser.getAttributeDouble(null, "value");
        }
        if (tagName.equals("boolean")) {
            return parser.getAttributeBoolean(null, "value");
        }
        return null;
    }

    @UnsupportedAppUsage
    public static void beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    @UnsupportedAppUsage
    public static void nextElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
    }

    public static boolean nextElementWithin(XmlPullParser parser, int outerDepth) throws IOException, XmlPullParserException {
        int type;
        do {
            if ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() != outerDepth)) continue;
            return false;
        } while (type != 2 || parser.getDepth() != outerDepth + 1);
        return true;
    }

    public static int readIntAttribute(XmlPullParser in, String name, int defaultValue) {
        if (in instanceof TypedXmlPullParser) {
            return ((TypedXmlPullParser)in).getAttributeInt(null, name, defaultValue);
        }
        String value = in.getAttributeValue(null, name);
        if (TextUtils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int readIntAttribute(XmlPullParser in, String name) throws IOException {
        if (in instanceof TypedXmlPullParser) {
            try {
                return ((TypedXmlPullParser)in).getAttributeInt(null, name);
            }
            catch (XmlPullParserException e) {
                throw new ProtocolException(e.getMessage());
            }
        }
        String value = in.getAttributeValue(null, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as int");
        }
    }

    public static void writeIntAttribute(XmlSerializer out, String name, int value) throws IOException {
        if (out instanceof TypedXmlSerializer) {
            ((TypedXmlSerializer)out).attributeInt(null, name, value);
            return;
        }
        out.attribute(null, name, Integer.toString(value));
    }

    public static long readLongAttribute(XmlPullParser in, String name, long defaultValue) {
        if (in instanceof TypedXmlPullParser) {
            return ((TypedXmlPullParser)in).getAttributeLong(null, name, defaultValue);
        }
        String value = in.getAttributeValue(null, name);
        if (TextUtils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long readLongAttribute(XmlPullParser in, String name) throws IOException {
        if (in instanceof TypedXmlPullParser) {
            try {
                return ((TypedXmlPullParser)in).getAttributeLong(null, name);
            }
            catch (XmlPullParserException e) {
                throw new ProtocolException(e.getMessage());
            }
        }
        String value = in.getAttributeValue(null, name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as long");
        }
    }

    public static void writeLongAttribute(XmlSerializer out, String name, long value) throws IOException {
        if (out instanceof TypedXmlSerializer) {
            ((TypedXmlSerializer)out).attributeLong(null, name, value);
            return;
        }
        out.attribute(null, name, Long.toString(value));
    }

    public static float readFloatAttribute(XmlPullParser in, String name) throws IOException {
        if (in instanceof TypedXmlPullParser) {
            try {
                return ((TypedXmlPullParser)in).getAttributeFloat(null, name);
            }
            catch (XmlPullParserException e) {
                throw new ProtocolException(e.getMessage());
            }
        }
        String value = in.getAttributeValue(null, name);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as long");
        }
    }

    public static void writeFloatAttribute(XmlSerializer out, String name, float value) throws IOException {
        if (out instanceof TypedXmlSerializer) {
            ((TypedXmlSerializer)out).attributeFloat(null, name, value);
            return;
        }
        out.attribute(null, name, Float.toString(value));
    }

    public static boolean readBooleanAttribute(XmlPullParser in, String name) {
        return XmlUtils.readBooleanAttribute(in, name, false);
    }

    public static boolean readBooleanAttribute(XmlPullParser in, String name, boolean defaultValue) {
        if (in instanceof TypedXmlPullParser) {
            return ((TypedXmlPullParser)in).getAttributeBoolean(null, name, defaultValue);
        }
        String value = in.getAttributeValue(null, name);
        if (TextUtils.isEmpty(value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static void writeBooleanAttribute(XmlSerializer out, String name, boolean value) throws IOException {
        if (out instanceof TypedXmlSerializer) {
            ((TypedXmlSerializer)out).attributeBoolean(null, name, value);
            return;
        }
        out.attribute(null, name, Boolean.toString(value));
    }

    public static Uri readUriAttribute(XmlPullParser in, String name) {
        String value = in.getAttributeValue(null, name);
        return value != null ? Uri.parse(value) : null;
    }

    public static void writeUriAttribute(XmlSerializer out, String name, Uri value) throws IOException {
        if (value != null) {
            out.attribute(null, name, value.toString());
        }
    }

    public static String readStringAttribute(XmlPullParser in, String name) {
        return in.getAttributeValue(null, name);
    }

    public static void writeStringAttribute(XmlSerializer out, String name, CharSequence value) throws IOException {
        if (value != null) {
            out.attribute(null, name, value.toString());
        }
    }

    public static byte[] readByteArrayAttribute(XmlPullParser in, String name) {
        if (in instanceof TypedXmlPullParser) {
            try {
                return ((TypedXmlPullParser)in).getAttributeBytesBase64(null, name);
            }
            catch (XmlPullParserException e) {
                return null;
            }
        }
        String value = in.getAttributeValue(null, name);
        if (!TextUtils.isEmpty(value)) {
            return Base64.decode(value, 0);
        }
        return null;
    }

    public static void writeByteArrayAttribute(XmlSerializer out, String name, byte[] value) throws IOException {
        if (value != null) {
            if (out instanceof TypedXmlSerializer) {
                ((TypedXmlSerializer)out).attributeBytesBase64(null, name, value);
                return;
            }
            out.attribute(null, name, Base64.encodeToString(value, 0));
        }
    }

    public static Bitmap readBitmapAttribute(XmlPullParser in, String name) {
        byte[] value = XmlUtils.readByteArrayAttribute(in, name);
        if (value != null) {
            return BitmapFactory.decodeByteArray(value, 0, value.length);
        }
        return null;
    }

    @Deprecated
    public static void writeBitmapAttribute(XmlSerializer out, String name, Bitmap value) throws IOException {
        if (value != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            value.compress(Bitmap.CompressFormat.PNG, 90, os);
            XmlUtils.writeByteArrayAttribute(out, name, os.toByteArray());
        }
    }

    private static class ForcedTypedXmlSerializer
    extends XmlSerializerWrapper
    implements TypedXmlSerializer {
        public ForcedTypedXmlSerializer(XmlSerializer wrapped) {
            super(wrapped);
        }

        @Override
        public XmlSerializer attributeInterned(String namespace, String name, String value) throws IOException {
            return this.attribute(namespace, name, value);
        }

        @Override
        public XmlSerializer attributeBytesHex(String namespace, String name, byte[] value) throws IOException {
            return this.attribute(namespace, name, HexDump.toHexString(value));
        }

        @Override
        public XmlSerializer attributeBytesBase64(String namespace, String name, byte[] value) throws IOException {
            return this.attribute(namespace, name, Base64.encodeToString(value, 2));
        }

        @Override
        public XmlSerializer attributeInt(String namespace, String name, int value) throws IOException {
            return this.attribute(namespace, name, Integer.toString(value));
        }

        @Override
        public XmlSerializer attributeIntHex(String namespace, String name, int value) throws IOException {
            return this.attribute(namespace, name, Integer.toString(value, 16));
        }

        @Override
        public XmlSerializer attributeLong(String namespace, String name, long value) throws IOException {
            return this.attribute(namespace, name, Long.toString(value));
        }

        @Override
        public XmlSerializer attributeLongHex(String namespace, String name, long value) throws IOException {
            return this.attribute(namespace, name, Long.toString(value, 16));
        }

        @Override
        public XmlSerializer attributeFloat(String namespace, String name, float value) throws IOException {
            return this.attribute(namespace, name, Float.toString(value));
        }

        @Override
        public XmlSerializer attributeDouble(String namespace, String name, double value) throws IOException {
            return this.attribute(namespace, name, Double.toString(value));
        }

        @Override
        public XmlSerializer attributeBoolean(String namespace, String name, boolean value) throws IOException {
            return this.attribute(namespace, name, Boolean.toString(value));
        }
    }

    private static class ForcedTypedXmlPullParser
    extends XmlPullParserWrapper
    implements TypedXmlPullParser {
        public ForcedTypedXmlPullParser(XmlPullParser wrapped) {
            super(wrapped);
        }

        @Override
        public byte[] getAttributeBytesHex(int index) throws XmlPullParserException {
            try {
                return HexDump.hexStringToByteArray(this.getAttributeValue(index));
            }
            catch (Exception e) {
                throw this.invalidAttributeException(index, e);
            }
        }

        @Override
        public byte[] getAttributeBytesBase64(int index) throws XmlPullParserException {
            try {
                return Base64.decode(this.getAttributeValue(index), 2);
            }
            catch (Exception e) {
                throw this.invalidAttributeException(index, e);
            }
        }

        @Override
        public int getAttributeInt(int index) throws XmlPullParserException {
            try {
                return Integer.parseInt(this.getAttributeValue(index));
            }
            catch (Exception e) {
                throw this.invalidAttributeException(index, e);
            }
        }

        @Override
        public int getAttributeIntHex(int index) throws XmlPullParserException {
            try {
                return Integer.parseInt(this.getAttributeValue(index), 16);
            }
            catch (Exception e) {
                throw this.invalidAttributeException(index, e);
            }
        }

        @Override
        public long getAttributeLong(int index) throws XmlPullParserException {
            try {
                return Long.parseLong(this.getAttributeValue(index));
            }
            catch (Exception e) {
                throw this.invalidAttributeException(index, e);
            }
        }

        @Override
        public long getAttributeLongHex(int index) throws XmlPullParserException {
            try {
                return Long.parseLong(this.getAttributeValue(index), 16);
            }
            catch (Exception e) {
                throw this.invalidAttributeException(index, e);
            }
        }

        @Override
        public float getAttributeFloat(int index) throws XmlPullParserException {
            try {
                return Float.parseFloat(this.getAttributeValue(index));
            }
            catch (Exception e) {
                throw this.invalidAttributeException(index, e);
            }
        }

        @Override
        public double getAttributeDouble(int index) throws XmlPullParserException {
            try {
                return Double.parseDouble(this.getAttributeValue(index));
            }
            catch (Exception e) {
                throw this.invalidAttributeException(index, e);
            }
        }

        @Override
        public boolean getAttributeBoolean(int index) throws XmlPullParserException {
            String value = this.getAttributeValue(index);
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
            throw new XmlPullParserException("Invalid attribute " + this.getAttributeName(index) + ": " + value);
        }

        private XmlPullParserException invalidAttributeException(int index, Exception e) {
            return new XmlPullParserException("Invalid attribute " + this.getAttributeName(index), (XmlPullParser)this, (Throwable)e);
        }
    }

    public static interface WriteMapCallback {
        public void writeUnknownObject(Object var1, String var2, TypedXmlSerializer var3) throws XmlPullParserException, IOException;
    }

    public static interface ReadMapCallback {
        public Object readThisUnknownObjectXml(TypedXmlPullParser var1, String var2) throws XmlPullParserException, IOException;
    }
}

