/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.function.Consumer;

public class TraceBuffer<P, S extends P, T extends P> {
    private final ProtoProvider<P, S, T> mProtoProvider;
    @GuardedBy(value={"this"})
    private final Queue<T> mBuffer = new ArrayDeque<T>();
    private final Consumer mProtoDequeuedCallback;
    @GuardedBy(value={"this"})
    private int mBufferUsedSize;
    @GuardedBy(value={"this"})
    private int mBufferCapacity;

    public TraceBuffer(int bufferCapacity) {
        this(bufferCapacity, new ProtoOutputStreamProvider(), null);
    }

    public TraceBuffer(int bufferCapacity, Consumer<T> protoDequeuedCallback) {
        this(bufferCapacity, new ProtoOutputStreamProvider(), protoDequeuedCallback);
    }

    public TraceBuffer(int bufferCapacity, ProtoProvider protoProvider, Consumer<T> protoDequeuedCallback) {
        this.mBufferCapacity = bufferCapacity;
        this.mProtoProvider = protoProvider;
        this.mProtoDequeuedCallback = protoDequeuedCallback;
        this.resetBuffer();
    }

    public synchronized int getAvailableSpace() {
        return this.mBufferCapacity - this.mBufferUsedSize;
    }

    public synchronized int size() {
        return this.mBuffer.size();
    }

    public synchronized void setCapacity(int capacity) {
        this.mBufferCapacity = capacity;
    }

    public synchronized void add(T proto) {
        int protoLength = this.mProtoProvider.getItemSize(proto);
        if (protoLength > this.mBufferCapacity) {
            throw new IllegalStateException("Trace object too large for the buffer. Buffer size:" + this.mBufferCapacity + " Object size: " + protoLength);
        }
        this.discardOldest(protoLength);
        this.mBuffer.add(proto);
        this.mBufferUsedSize += protoLength;
    }

    @VisibleForTesting
    public synchronized boolean contains(byte[] other) {
        return this.mBuffer.stream().anyMatch(p -> Arrays.equals(this.mProtoProvider.getBytes(p), other));
    }

    public synchronized void writeTraceToFile(File traceFile, S encapsulatingProto) throws IOException {
        traceFile.delete();
        try (FileOutputStream os = new FileOutputStream(traceFile);){
            traceFile.setReadable(true, false);
            this.mProtoProvider.write(encapsulatingProto, this.mBuffer, os);
            os.flush();
        }
    }

    private void discardOldest(int protoLength) {
        long availableSpace = this.getAvailableSpace();
        while (availableSpace < (long)protoLength) {
            T item = this.mBuffer.poll();
            if (item == null) {
                throw new IllegalStateException("No element to discard from buffer");
            }
            this.mBufferUsedSize -= this.mProtoProvider.getItemSize(item);
            availableSpace = this.getAvailableSpace();
            if (this.mProtoDequeuedCallback == null) continue;
            this.mProtoDequeuedCallback.accept(item);
        }
    }

    public synchronized void resetBuffer() {
        if (this.mProtoDequeuedCallback != null) {
            for (Object item : this.mBuffer) {
                this.mProtoDequeuedCallback.accept(item);
            }
        }
        this.mBuffer.clear();
        this.mBufferUsedSize = 0;
    }

    @VisibleForTesting
    public synchronized int getBufferSize() {
        return this.mBufferUsedSize;
    }

    public synchronized String getStatus() {
        return "Buffer size: " + this.mBufferCapacity + " bytes\nBuffer usage: " + this.mBufferUsedSize + " bytes\nElements in the buffer: " + this.mBuffer.size();
    }

    private static class ProtoOutputStreamProvider
    implements ProtoProvider<ProtoOutputStream, ProtoOutputStream, ProtoOutputStream> {
        private ProtoOutputStreamProvider() {
        }

        @Override
        public int getItemSize(ProtoOutputStream proto) {
            return proto.getRawSize();
        }

        @Override
        public byte[] getBytes(ProtoOutputStream proto) {
            return proto.getBytes();
        }

        @Override
        public void write(ProtoOutputStream encapsulatingProto, Queue<ProtoOutputStream> buffer, OutputStream os) throws IOException {
            os.write(encapsulatingProto.getBytes());
            for (ProtoOutputStream protoOutputStream : buffer) {
                byte[] protoBytes = protoOutputStream.getBytes();
                os.write(protoBytes);
            }
        }
    }

    public static interface ProtoProvider<P, S extends P, T extends P> {
        public int getItemSize(P var1);

        public byte[] getBytes(P var1);

        public void write(S var1, Queue<T> var2, OutputStream var3) throws IOException;
    }
}

