/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.SystemClock;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.util.Preconditions;

@RavenwoodKeepWholeClass
public class TokenBucket {
    private final int mFillDelta;
    private final int mCapacity;
    private long mLastFill;
    private int mAvailable;

    public TokenBucket(int deltaMs, int capacity, int tokens) {
        this.mFillDelta = Preconditions.checkArgumentPositive(deltaMs, "deltaMs must be strictly positive");
        this.mCapacity = Preconditions.checkArgumentPositive(capacity, "capacity must be strictly positive");
        this.mAvailable = Math.min(Preconditions.checkArgumentNonnegative(tokens), this.mCapacity);
        this.mLastFill = this.scaledTime();
    }

    public TokenBucket(int deltaMs, int capacity) {
        this(deltaMs, capacity, capacity);
    }

    public void reset(int tokens) {
        Preconditions.checkArgumentNonnegative(tokens);
        this.mAvailable = Math.min(tokens, this.mCapacity);
        this.mLastFill = this.scaledTime();
    }

    public int capacity() {
        return this.mCapacity;
    }

    public int available() {
        this.fill();
        return this.mAvailable;
    }

    public boolean has() {
        this.fill();
        return this.mAvailable > 0;
    }

    public boolean get() {
        return this.get(1) == 1;
    }

    public int get(int n) {
        this.fill();
        if (n <= 0) {
            return 0;
        }
        if (n > this.mAvailable) {
            int got = this.mAvailable;
            this.mAvailable = 0;
            return got;
        }
        this.mAvailable -= n;
        return n;
    }

    private void fill() {
        long now = this.scaledTime();
        int diff = (int)(now - this.mLastFill);
        this.mAvailable = Math.min(this.mCapacity, this.mAvailable + diff);
        this.mLastFill = now;
    }

    private long scaledTime() {
        return SystemClock.elapsedRealtime() / (long)this.mFillDelta;
    }
}

