/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.Nullable;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

@RavenwoodKeepWholeClass
public interface Parcelling<T> {
    public void parcel(T var1, Parcel var2, int var3);

    public T unparcel(Parcel var1);

    public static interface BuiltIn {

        public static class ForInstant
        implements Parcelling<Instant> {
            @Override
            public void parcel(Instant item, Parcel dest, int parcelFlags) {
                dest.writeLong(item == null ? Long.MIN_VALUE : item.getEpochSecond());
                dest.writeInt(item == null ? Integer.MIN_VALUE : item.getNano());
            }

            @Override
            public Instant unparcel(Parcel source) {
                long epochSecond = source.readLong();
                int afterNano = source.readInt();
                if (epochSecond == Long.MIN_VALUE) {
                    return null;
                }
                return Instant.ofEpochSecond(epochSecond, afterNano);
            }
        }

        public static class ForUUID
        implements Parcelling<UUID> {
            @Override
            public void parcel(UUID item, Parcel dest, int parcelFlags) {
                dest.writeString(item == null ? null : ((Object)item).toString());
            }

            @Override
            public UUID unparcel(Parcel source) {
                String string2 = source.readString();
                return string2 == null ? null : UUID.fromString(string2);
            }
        }

        public static class ForPattern
        implements Parcelling<Pattern> {
            @Override
            public void parcel(Pattern item, Parcel dest, int parcelFlags) {
                dest.writeString(item == null ? null : item.pattern());
            }

            @Override
            public Pattern unparcel(Parcel source) {
                String s = source.readString();
                return s == null ? null : Pattern.compile(s);
            }
        }

        public static class ForBoolean
        implements Parcelling<Boolean> {
            @Override
            public void parcel(@Nullable Boolean item, Parcel dest, int parcelFlags) {
                if (item == null) {
                    dest.writeInt(1);
                } else if (!item.booleanValue()) {
                    dest.writeInt(0);
                } else {
                    dest.writeInt(-1);
                }
            }

            @Override
            @Nullable
            public Boolean unparcel(Parcel source) {
                switch (source.readInt()) {
                    default: {
                        throw new IllegalStateException("Malformed Parcel reading Boolean: " + source);
                    }
                    case 1: {
                        return null;
                    }
                    case 0: {
                        return Boolean.FALSE;
                    }
                    case -1: 
                }
                return Boolean.TRUE;
            }
        }

        public static class ForInternedStringArraySet
        implements Parcelling<ArraySet<String>> {
            @Override
            public void parcel(ArraySet<String> item, Parcel dest, int parcelFlags) {
                if (item == null) {
                    dest.writeInt(-1);
                } else {
                    dest.writeInt(item.size());
                    for (String string2 : item) {
                        dest.writeString(string2);
                    }
                }
            }

            @Override
            public ArraySet<String> unparcel(Parcel source) {
                int size = source.readInt();
                if (size < 0) {
                    return null;
                }
                ArraySet<String> set = new ArraySet<String>();
                for (int count = 0; count < size; ++count) {
                    set.add(TextUtils.safeIntern(source.readString()));
                }
                return set;
            }
        }

        public static class ForInternedStringSet
        implements Parcelling<Set<String>> {
            @Override
            public void parcel(Set<String> item, Parcel dest, int parcelFlags) {
                if (item == null) {
                    dest.writeInt(-1);
                } else {
                    dest.writeInt(item.size());
                    for (String string2 : item) {
                        dest.writeString(string2);
                    }
                }
            }

            @Override
            public Set<String> unparcel(Parcel source) {
                int size = source.readInt();
                if (size < 0) {
                    return Collections.emptySet();
                }
                ArraySet<String> set = new ArraySet<String>();
                for (int count = 0; count < size; ++count) {
                    set.add(TextUtils.safeIntern(source.readString()));
                }
                return set;
            }
        }

        public static class ForStringSet
        implements Parcelling<Set<String>> {
            @Override
            public void parcel(Set<String> item, Parcel dest, int parcelFlags) {
                if (item == null) {
                    dest.writeInt(-1);
                } else {
                    dest.writeInt(item.size());
                    for (String string2 : item) {
                        dest.writeString(string2);
                    }
                }
            }

            @Override
            public Set<String> unparcel(Parcel source) {
                int size = source.readInt();
                if (size < 0) {
                    return Collections.emptySet();
                }
                ArraySet<String> set = new ArraySet<String>();
                for (int count = 0; count < size; ++count) {
                    set.add(source.readString());
                }
                return set;
            }
        }

        public static class ForInternedStringValueMap
        implements Parcelling<Map<String, String>> {
            @Override
            public void parcel(Map<String, String> item, Parcel dest, int parcelFlags) {
                dest.writeMap(item);
            }

            @Override
            public Map<String, String> unparcel(Parcel source) {
                ArrayMap<String, String> map = new ArrayMap<String, String>();
                source.readMap(map, String.class.getClassLoader());
                for (int index = 0; index < map.size(); ++index) {
                    map.setValueAt(index, TextUtils.safeIntern(map.valueAt(index)));
                }
                return map;
            }
        }

        public static class ForInternedStringList
        implements Parcelling<List<String>> {
            @Override
            public void parcel(List<String> item, Parcel dest, int parcelFlags) {
                dest.writeStringList(item);
            }

            @Override
            public List<String> unparcel(Parcel source) {
                ArrayList<String> list = source.createStringArrayList();
                if (list != null) {
                    int size = list.size();
                    for (int index = 0; index < size; ++index) {
                        list.set(index, list.get(index).intern());
                    }
                }
                return CollectionUtils.emptyIfNull(list);
            }
        }

        public static class ForInternedStringArray
        implements Parcelling<String[]> {
            @Override
            public void parcel(String[] item, Parcel dest, int parcelFlags) {
                dest.writeStringArray(item);
            }

            @Override
            @Nullable
            public String[] unparcel(Parcel source) {
                Object[] array2 = source.readStringArray();
                if (array2 != null) {
                    int size = ArrayUtils.size(array2);
                    for (int index = 0; index < size; ++index) {
                        array2[index] = TextUtils.safeIntern((String)array2[index]);
                    }
                }
                return array2;
            }
        }

        public static class ForInternedString
        implements Parcelling<String> {
            @Override
            public void parcel(@Nullable String item, Parcel dest, int parcelFlags) {
                dest.writeString(item);
            }

            @Override
            @Nullable
            public String unparcel(Parcel source) {
                return TextUtils.safeIntern(source.readString());
            }
        }
    }

    public static class Cache {
        private static ArrayMap<Class, Parcelling> sCache = new ArrayMap();

        private Cache() {
        }

        @Nullable
        public static <P extends Parcelling<?>> P get(Class<P> clazz) {
            return (P)sCache.get(clazz);
        }

        public static <P extends Parcelling<?>> P put(P parcelling) {
            sCache.put(parcelling.getClass(), parcelling);
            return parcelling;
        }

        public static <P extends Parcelling<?>> P getOrCreate(Class<P> clazz) {
            P cached = Cache.get(clazz);
            if (cached != null) {
                return cached;
            }
            try {
                return (P)Cache.put((Parcelling)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

