/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.SparseArray;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RavenwoodKeepWholeClass
public interface HeavyHitterSketch<T> {
    @NonNull
    public static <V> HeavyHitterSketch<V> newDefault() {
        return new HeavyHitterSketchImpl();
    }

    public void setConfig(int var1, int var2);

    public void add(@Nullable T var1);

    @Nullable
    public List<T> getTopHeavyHitters(int var1, @Nullable List<T> var2, @Nullable List<Float> var3);

    @Nullable
    public List<T> getCandidates(@Nullable List<T> var1);

    public void reset();

    public float getRequiredValidationInputRatio();

    public static class HeavyHitterSketchImpl<T>
    implements HeavyHitterSketch<T> {
        private final SparseArray<T> mObjects = new SparseArray();
        private final SparseIntArray mFrequencies = new SparseIntArray();
        private int mPassSize;
        private int mTotalSize;
        private int mCapacity;
        private int mNumInputs;
        private boolean mConfigured;

        @Override
        public void setConfig(int inputSize, int capacity) {
            if (inputSize < capacity || inputSize <= 1) {
                this.mConfigured = false;
                throw new IllegalArgumentException();
            }
            this.reset();
            this.mTotalSize = inputSize;
            this.mPassSize = inputSize >> 1;
            this.mCapacity = capacity;
            this.mConfigured = true;
        }

        @Override
        public void add(@Nullable T newInstance) {
            if (!this.mConfigured) {
                throw new IllegalStateException();
            }
            if (this.mNumInputs < this.mPassSize) {
                this.addToMGSummary(newInstance);
            } else if (this.mNumInputs < this.mTotalSize) {
                this.validate(newInstance);
            }
        }

        private void addToMGSummary(@Nullable T newInstance) {
            int i;
            int hashCode = newInstance != null ? newInstance.hashCode() : 0;
            int index = this.mObjects.indexOfKey(hashCode);
            if (index >= 0) {
                this.mFrequencies.setValueAt(index, this.mFrequencies.valueAt(index) + 1);
            } else if (this.mObjects.size() < this.mCapacity - 1) {
                this.mObjects.put(hashCode, newInstance);
                this.mFrequencies.put(hashCode, 1);
            } else {
                for (i = this.mFrequencies.size() - 1; i >= 0; --i) {
                    int val = this.mFrequencies.valueAt(i) - 1;
                    if (val == 0) {
                        this.mObjects.removeAt(i);
                        this.mFrequencies.removeAt(i);
                        continue;
                    }
                    this.mFrequencies.setValueAt(i, val);
                }
            }
            if (++this.mNumInputs == this.mPassSize) {
                for (i = this.mFrequencies.size() - 1; i >= 0; --i) {
                    this.mFrequencies.setValueAt(i, 0);
                }
            }
        }

        private void validate(@Nullable T newInstance) {
            int hashCode = newInstance != null ? newInstance.hashCode() : 0;
            int index = this.mObjects.indexOfKey(hashCode);
            if (index >= 0) {
                this.mFrequencies.setValueAt(index, this.mFrequencies.valueAt(index) + 1);
            }
            if (++this.mNumInputs == this.mTotalSize) {
                int lower = this.mPassSize / this.mCapacity;
                for (int i = this.mFrequencies.size() - 1; i >= 0; --i) {
                    int val = this.mFrequencies.valueAt(i);
                    if (val >= lower) continue;
                    this.mFrequencies.removeAt(i);
                    this.mObjects.removeAt(i);
                }
            }
        }

        @Override
        @Nullable
        public List<T> getTopHeavyHitters(int k, @Nullable List<T> holder, @Nullable List<Float> freqs) {
            if (!this.mConfigured) {
                throw new IllegalStateException();
            }
            if (k >= this.mCapacity) {
                throw new IllegalArgumentException();
            }
            if (this.mNumInputs < this.mTotalSize) {
                throw new IllegalStateException();
            }
            ArrayList<Integer> indexes = null;
            for (int i = this.mFrequencies.size() - 1; i >= 0; --i) {
                int val = this.mFrequencies.valueAt(i);
                if (val <= 0) continue;
                if (indexes == null) {
                    indexes = new ArrayList<Integer>();
                }
                indexes.add(i);
            }
            if (indexes == null) {
                return null;
            }
            Collections.sort(indexes, (a, b) -> this.mFrequencies.valueAt((int)b) - this.mFrequencies.valueAt((int)a));
            ArrayList<T> result = holder != null ? holder : new ArrayList<T>();
            int max = Math.min(k == 0 ? this.mCapacity - 1 : k, indexes.size());
            for (int i = 0; i < max; ++i) {
                int index = (Integer)indexes.get(i);
                T obj = this.mObjects.valueAt(index);
                if (obj == null) continue;
                result.add(obj);
                if (freqs == null) continue;
                freqs.add(Float.valueOf((float)this.mFrequencies.valueAt(index) / (float)this.mPassSize));
            }
            return result;
        }

        @Override
        @Nullable
        public List<T> getCandidates(@Nullable List<T> holder) {
            if (!this.mConfigured) {
                throw new IllegalStateException();
            }
            if (this.mNumInputs < this.mPassSize) {
                return null;
            }
            ArrayList<T> result = holder != null ? holder : new ArrayList<T>();
            for (int i = this.mObjects.size() - 1; i >= 0; --i) {
                T obj = this.mObjects.valueAt(i);
                if (obj == null) continue;
                result.add(obj);
            }
            return result;
        }

        @Override
        public void reset() {
            this.mNumInputs = 0;
            this.mObjects.clear();
            this.mFrequencies.clear();
        }

        @Override
        public float getRequiredValidationInputRatio() {
            return 0.5f;
        }
    }
}

