/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public class ExponentiallyBucketedHistogram {
    @NonNull
    private final int[] mData;

    public ExponentiallyBucketedHistogram(int numBuckets) {
        numBuckets = Preconditions.checkArgumentInRange(numBuckets, 1, 31, "numBuckets");
        this.mData = new int[numBuckets];
    }

    public void add(int value) {
        if (value <= 0) {
            this.mData[0] = this.mData[0] + 1;
        } else {
            int n = Math.min(this.mData.length - 1, 32 - Integer.numberOfLeadingZeros(value));
            this.mData[n] = this.mData[n] + 1;
        }
    }

    public void reset() {
        Arrays.fill(this.mData, 0);
    }

    public void log(@NonNull String tag, @Nullable CharSequence prefix) {
        StringBuilder builder = new StringBuilder(prefix);
        builder.append('[');
        for (int i = 0; i < this.mData.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            if (i < this.mData.length - 1) {
                builder.append("<");
                builder.append(1 << i);
            } else {
                builder.append(">=");
                builder.append(1 << i - 1);
            }
            builder.append(": ");
            builder.append(this.mData[i]);
        }
        builder.append("]");
        Log.d(tag, builder.toString());
    }
}

