/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.protolog;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.util.LongSparseArray;
import android.util.proto.ProtoInputStream;
import com.android.internal.protolog.AutoClosableProtoInputStream;
import com.android.internal.protolog.ViewerConfigInputStreamProvider;
import com.android.internal.protolog.common.ILogger;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class ProtoLogViewerConfigReader {
    @NonNull
    private final ViewerConfigInputStreamProvider mViewerConfigInputStreamProvider;
    @NonNull
    private final Map<String, Set<Long>> mGroupHashes = new TreeMap<String, Set<Long>>();
    @NonNull
    private final LongSparseArray<String> mLogMessageMap = new LongSparseArray();

    public ProtoLogViewerConfigReader(@NonNull ViewerConfigInputStreamProvider viewerConfigInputStreamProvider) {
        this.mViewerConfigInputStreamProvider = viewerConfigInputStreamProvider;
    }

    @Nullable
    public String getViewerString(long messageHash) {
        return this.mLogMessageMap.get(messageHash);
    }

    public synchronized void loadViewerConfig(@NonNull String[] groups) {
        this.loadViewerConfig(groups, message -> {});
    }

    public synchronized void loadViewerConfig(@NonNull String[] groups, @NonNull ILogger logger) {
        for (String group : groups) {
            if (this.mGroupHashes.containsKey(group)) continue;
            try {
                Map<Long, String> mappings = this.loadViewerConfigMappingForGroup(group);
                this.mGroupHashes.put(group, mappings.keySet());
                for (Long key : mappings.keySet()) {
                    this.mLogMessageMap.put(key, mappings.get(key));
                }
                logger.log("Loaded " + this.mLogMessageMap.size() + " log definitions");
            }
            catch (IOException e) {
                logger.log("Unable to load log definitions: IOException while processing viewer config" + e);
            }
        }
    }

    public synchronized void unloadViewerConfig(@NonNull String[] groups) {
        this.unloadViewerConfig(groups, message -> {});
    }

    public synchronized void unloadViewerConfig(@NonNull String[] groups, @NonNull ILogger logger) {
        for (String group : groups) {
            if (!this.mGroupHashes.containsKey(group)) continue;
            Set<Long> hashes = this.mGroupHashes.get(group);
            for (Long hash : hashes) {
                logger.log("Unloading viewer config hash " + hash);
                this.mLogMessageMap.remove(hash);
            }
            this.mGroupHashes.remove(group);
        }
    }

    public boolean messageHashIsAvailableInFile(long messageHash) throws IOException {
        try (AutoClosableProtoInputStream pisWrapper = this.mViewerConfigInputStreamProvider.getInputStream();){
            ProtoInputStream pis = pisWrapper.get();
            while (pis.nextField() != -1) {
                if (pis.getFieldNumber() != 1) continue;
                long inMessageToken = pis.start(2246267895809L);
                while (pis.nextField() != -1) {
                    if (pis.getFieldNumber() != 1 || pis.readLong(0x10600000001L) != messageHash) continue;
                    boolean bl = true;
                    return bl;
                }
                pis.end(inMessageToken);
            }
        }
        return false;
    }

    @NonNull
    private Map<Long, String> loadViewerConfigMappingForGroup(@NonNull String group) throws IOException {
        long targetGroupId = this.loadGroupId(group);
        TreeMap<Long, String> hashesForGroup = new TreeMap<Long, String>();
        try (AutoClosableProtoInputStream pisWrapper = this.mViewerConfigInputStreamProvider.getInputStream();){
            ProtoInputStream pis = pisWrapper.get();
            while (pis.nextField() != -1) {
                if (pis.getFieldNumber() != 1) continue;
                long inMessageToken = pis.start(2246267895809L);
                long messageId = 0L;
                String message = null;
                int groupId = 0;
                while (pis.nextField() != -1) {
                    switch (pis.getFieldNumber()) {
                        case 1: {
                            messageId = pis.readLong(0x10600000001L);
                            break;
                        }
                        case 2: {
                            message = pis.readString(1138166333442L);
                            break;
                        }
                        case 4: {
                            groupId = pis.readInt(1155346202628L);
                        }
                    }
                }
                if (groupId == 0) {
                    throw new IOException("Failed to get group id");
                }
                if (messageId == 0L) {
                    throw new IOException("Failed to get message id");
                }
                if (message == null) {
                    throw new IOException("Failed to get message string");
                }
                if ((long)groupId == targetGroupId) {
                    hashesForGroup.put(messageId, message);
                }
                pis.end(inMessageToken);
            }
        }
        return hashesForGroup;
    }

    private long loadGroupId(@NonNull String group) throws IOException {
        try (AutoClosableProtoInputStream pisWrapper = this.mViewerConfigInputStreamProvider.getInputStream();){
            ProtoInputStream pis = pisWrapper.get();
            while (pis.nextField() != -1) {
                if (pis.getFieldNumber() != 2) continue;
                long inMessageToken = pis.start(0x20B00000002L);
                long groupId = 0L;
                String groupName = null;
                while (pis.nextField() != -1) {
                    switch (pis.getFieldNumber()) {
                        case 1: {
                            groupId = pis.readInt(0x10D00000001L);
                            break;
                        }
                        case 2: {
                            groupName = pis.readString(1138166333442L);
                        }
                    }
                }
                if (Objects.equals(groupName, group)) {
                    long l = groupId;
                    return l;
                }
                pis.end(inMessageToken);
            }
        }
        throw new RuntimeException("Group " + group + " not found in viewer config");
    }
}

