/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.protolog;

import android.annotation.NonNull;
import android.tracing.perfetto.CreateIncrementalStateArgs;
import android.tracing.perfetto.CreateTlsStateArgs;
import android.tracing.perfetto.DataSource;
import android.tracing.perfetto.DataSourceInstance;
import android.tracing.perfetto.FlushCallbackArguments;
import android.tracing.perfetto.StartCallbackArguments;
import android.tracing.perfetto.StopCallbackArguments;
import android.util.proto.ProtoInputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.protolog.common.LogLevel;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ProtoLogDataSource
extends DataSource<Instance, TlsState, IncrementalState> {
    private static final String DATASOURCE_NAME = "android.protolog";
    private final Map<Integer, ProtoLogConfig> mRunningInstances = new TreeMap<Integer, ProtoLogConfig>();
    @NonNull
    private final Set<Instance.TracingInstanceStartCallback> mOnStartCallbacks = new HashSet<Instance.TracingInstanceStartCallback>();
    @NonNull
    private final Set<Instance.TracingFlushCallback> mOnFlushCallbacks = new HashSet<Instance.TracingFlushCallback>();
    @NonNull
    private final Set<Instance.TracingInstanceStopCallback> mOnStopCallbacks = new HashSet<Instance.TracingInstanceStopCallback>();

    public ProtoLogDataSource() {
        this(DATASOURCE_NAME);
    }

    @VisibleForTesting
    public ProtoLogDataSource(@NonNull String dataSourceName) {
        super(dataSourceName);
    }

    /*
     * Exception decompiling
     */
    @Override
    @NonNull
    public Instance createInstance(@NonNull ProtoInputStream configStream, int instanceIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @NonNull
    public TlsState createTlsState(@NonNull CreateTlsStateArgs<Instance> args) {
        try (Instance dsInstance = args.getDataSourceInstanceLocked();){
            if (dsInstance == null) {
                TlsState tlsState = new TlsState(ProtoLogConfig.DEFAULT);
                return tlsState;
            }
            TlsState tlsState = new TlsState(dsInstance.mConfig);
            return tlsState;
        }
    }

    @Override
    @NonNull
    public IncrementalState createIncrementalState(@NonNull CreateIncrementalStateArgs<Instance> args) {
        return new IncrementalState();
    }

    public synchronized void registerOnStartCallback(Instance.TracingInstanceStartCallback onStartCallback) {
        this.mOnStartCallbacks.add(onStartCallback);
        this.mRunningInstances.forEach((index, config) -> onStartCallback.onTracingInstanceStart((int)index, (ProtoLogConfig)config));
    }

    public void registerOnFlushCallback(Instance.TracingFlushCallback onFlushCallback) {
        this.mOnFlushCallbacks.add(onFlushCallback);
    }

    public void registerOnStopCallback(Instance.TracingInstanceStopCallback onStopCallback) {
        this.mOnStopCallbacks.add(onStopCallback);
    }

    public void unregisterOnStartCallback(Instance.TracingInstanceStartCallback onStartCallback) {
        this.mOnStartCallbacks.remove(onStartCallback);
    }

    public void unregisterOnFlushCallback(Instance.TracingFlushCallback onFlushCallback) {
        this.mOnFlushCallbacks.remove(onFlushCallback);
    }

    public void unregisterOnStopCallback(Instance.TracingInstanceStopCallback onStopCallback) {
        this.mOnStopCallbacks.remove(onStopCallback);
    }

    private synchronized void executeOnStartCallbacks(int instanceIdx, ProtoLogConfig config) {
        this.mRunningInstances.put(instanceIdx, config);
        for (Instance.TracingInstanceStartCallback onStart : this.mOnStartCallbacks) {
            onStart.onTracingInstanceStart(instanceIdx, config);
        }
    }

    private void executeOnFlushCallbacks() {
        for (Instance.TracingFlushCallback onFlush : this.mOnFlushCallbacks) {
            onFlush.onTracingFlush();
        }
    }

    private synchronized void executeOnStopCallbacks(int instanceIdx, ProtoLogConfig config) {
        this.mRunningInstances.remove(instanceIdx, config);
        for (Instance.TracingInstanceStopCallback onStop : this.mOnStopCallbacks) {
            onStop.onTracingInstanceStop(instanceIdx, config);
        }
    }

    private ProtoLogConfig readProtoLogConfig(ProtoInputStream configStream) throws IOException {
        long config_token = configStream.start(1146756268158L);
        LogLevel defaultLogFromLevel = LogLevel.WTF;
        HashMap<String, GroupConfig> groupConfigs = new HashMap<String, GroupConfig>();
        while (configStream.nextField() != -1) {
            block0 : switch (configStream.getFieldNumber()) {
                case 3: {
                    int defaultLogFromLevelInt = configStream.readInt(1159641169923L);
                    if (defaultLogFromLevelInt >= defaultLogFromLevel.ordinal()) break;
                    defaultLogFromLevel = this.logLevelFromInt(defaultLogFromLevelInt);
                    break;
                }
                case 2: {
                    int tracingMode = configStream.readInt(1159641169922L);
                    switch (tracingMode) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            defaultLogFromLevel = LogLevel.VERBOSE;
                            break block0;
                        }
                    }
                    throw new RuntimeException("Unhandled ProtoLog tracing mode type");
                }
                case 1: {
                    long group_overrides_token = configStream.start(2246267895809L);
                    String tag = null;
                    LogLevel logFromLevel = defaultLogFromLevel;
                    boolean collectStackTrace = false;
                    while (configStream.nextField() != -1) {
                        if (configStream.getFieldNumber() == 1) {
                            tag = configStream.readString(0x10900000001L);
                        }
                        if (configStream.getFieldNumber() == 2) {
                            int logFromInt = configStream.readInt(1159641169922L);
                            logFromLevel = this.logLevelFromInt(logFromInt);
                        }
                        if (configStream.getFieldNumber() != 3) continue;
                        collectStackTrace = configStream.readBoolean(1133871366147L);
                    }
                    if (tag == null) {
                        throw new RuntimeException("Failed to decode proto config. Got a group override without a group tag.");
                    }
                    groupConfigs.put(tag, new GroupConfig(logFromLevel, collectStackTrace));
                    configStream.end(group_overrides_token);
                }
            }
        }
        configStream.end(config_token);
        return new ProtoLogConfig(defaultLogFromLevel, groupConfigs);
    }

    private LogLevel logLevelFromInt(int logFromInt) {
        LogLevel logLevel;
        switch (logFromInt) {
            case 1: {
                logLevel = LogLevel.DEBUG;
                break;
            }
            case 2: {
                logLevel = LogLevel.VERBOSE;
                break;
            }
            case 3: {
                logLevel = LogLevel.INFO;
                break;
            }
            case 4: {
                logLevel = LogLevel.WARN;
                break;
            }
            case 5: {
                logLevel = LogLevel.ERROR;
                break;
            }
            case 6: {
                logLevel = LogLevel.WTF;
                break;
            }
            default: {
                throw new RuntimeException("Unhandled log level");
            }
        }
        return logLevel;
    }

    public static class ProtoLogConfig {
        private final LogLevel mDefaultLogFromLevel;
        private final Map<String, GroupConfig> mGroupConfigs;
        private static final ProtoLogConfig DEFAULT = new ProtoLogConfig(LogLevel.WTF, new HashMap<String, GroupConfig>());

        private ProtoLogConfig(LogLevel defaultLogFromLevel, Map<String, GroupConfig> groupConfigs) {
            this.mDefaultLogFromLevel = defaultLogFromLevel;
            this.mGroupConfigs = groupConfigs;
        }

        public GroupConfig getConfigFor(String groupTag) {
            return this.mGroupConfigs.getOrDefault(groupTag, this.getDefaultGroupConfig());
        }

        public GroupConfig getDefaultGroupConfig() {
            return new GroupConfig(this.mDefaultLogFromLevel, false);
        }

        public Set<String> getGroupTagsWithOverriddenConfigs() {
            return this.mGroupConfigs.keySet();
        }
    }

    public static class Instance
    extends DataSourceInstance {
        @NonNull
        private final TracingInstanceStartCallback mOnStart;
        @NonNull
        private final TracingFlushCallback mOnFlush;
        @NonNull
        private final TracingInstanceStopCallback mOnStop;
        @NonNull
        private final ProtoLogConfig mConfig;
        private final int mInstanceIndex;

        public Instance(@NonNull DataSource<Instance, TlsState, IncrementalState> dataSource, int instanceIdx, @NonNull ProtoLogConfig config, @NonNull TracingInstanceStartCallback onStart, @NonNull TracingFlushCallback onFlush, @NonNull TracingInstanceStopCallback onStop) {
            super(dataSource, instanceIdx);
            this.mInstanceIndex = instanceIdx;
            this.mOnStart = onStart;
            this.mOnFlush = onFlush;
            this.mOnStop = onStop;
            this.mConfig = config;
        }

        @Override
        public void onStart(StartCallbackArguments args) {
            this.mOnStart.onTracingInstanceStart(this.mInstanceIndex, this.mConfig);
        }

        @Override
        public void onFlush(FlushCallbackArguments args) {
            this.mOnFlush.onTracingFlush();
        }

        @Override
        public void onStop(StopCallbackArguments args) {
            this.mOnStop.onTracingInstanceStop(this.mInstanceIndex, this.mConfig);
        }

        @FunctionalInterface
        public static interface TracingInstanceStartCallback {
            public void onTracingInstanceStart(int var1, @NonNull ProtoLogConfig var2);
        }

        @FunctionalInterface
        public static interface TracingFlushCallback {
            public void onTracingFlush();
        }

        @FunctionalInterface
        public static interface TracingInstanceStopCallback {
            public void onTracingInstanceStop(int var1, @NonNull ProtoLogConfig var2);
        }
    }

    public static class TlsState {
        @NonNull
        private final ProtoLogConfig mConfig;

        private TlsState(@NonNull ProtoLogConfig config) {
            this.mConfig = config;
        }

        public LogLevel getLogFromLevel(String groupTag) {
            return this.getConfigFor((String)groupTag).logFrom;
        }

        public boolean getShouldCollectStacktrace(String groupTag) {
            return this.getConfigFor((String)groupTag).collectStackTrace;
        }

        private GroupConfig getConfigFor(String groupTag) {
            return this.mConfig.getConfigFor(groupTag);
        }
    }

    public static class IncrementalState {
        public final Set<Integer> protologGroupInterningSet = new HashSet<Integer>();
        public final Set<Long> protologMessageInterningSet = new HashSet<Long>();
        public final Map<String, Integer> argumentInterningMap = new HashMap<String, Integer>();
        public final Map<String, Integer> stacktraceInterningMap = new HashMap<String, Integer>();
        public boolean clearReported = false;
    }

    public static class GroupConfig {
        public final LogLevel logFrom;
        public final boolean collectStackTrace;

        public GroupConfig(LogLevel logFromLevel, boolean collectStackTrace) {
            this.logFrom = logFromLevel;
            this.collectStackTrace = collectStackTrace;
        }
    }
}

