/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.protolog;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.ServiceManager;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.protolog.LogcatOnlyProtoLogImpl;
import com.android.internal.protolog.PerfettoProtoLogImpl;
import com.android.internal.protolog.ProtoLog;
import com.android.internal.protolog.ProtoLogDataSource;
import com.android.internal.protolog.UnprocessedPerfettoProtoLogImpl;
import com.android.internal.protolog.common.IProtoLog;
import com.android.internal.protolog.common.IProtoLogGroup;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@RavenwoodKeepWholeClass
public class ProtoLogController {
    @Nullable
    IProtoLog mProtoLogInstance;
    @NonNull
    private final Object mInitLock = new Object();
    @GuardedBy(value={"mInitLock"})
    private final Set<IProtoLogGroup> mGroups = new HashSet<IProtoLogGroup>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLogGroupInProcess(IProtoLogGroup ... groups) {
        Object object = this.mInitLock;
        synchronized (object) {
            Set<IProtoLogGroup> newGroups = Arrays.stream(groups).filter(Objects::nonNull).filter(group -> !this.mGroups.contains(group)).collect(Collectors.toUnmodifiableSet());
            if (newGroups.isEmpty()) {
                return;
            }
            this.assertForCollisions(newGroups);
            this.mGroups.addAll(newGroups);
            if (this.mProtoLogInstance != null) {
                this.mProtoLogInstance.registerGroups(newGroups.toArray(new IProtoLogGroup[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(IProtoLogGroup ... groups) {
        this.registerLogGroupInProcess(groups);
        Object object = this.mInitLock;
        synchronized (object) {
            if (this.mProtoLogInstance != null) {
                return;
            }
            if (this.shouldLogOnlyToLogcat()) {
                this.mProtoLogInstance = this.createLogcatOnlyInstance();
            } else {
                ProtoLogDataSource datasource = ProtoLog.getSharedSingleInstanceDataSource();
                this.mProtoLogInstance = this.createAndEnableNewPerfettoProtoLogImpl(datasource, this.mGroups.toArray(new IProtoLogGroup[0]));
            }
        }
    }

    @Nullable
    @VisibleForTesting
    public IProtoLog getProtoLogInstance() {
        return this.mProtoLogInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void tearDown() {
        Object object = this.mInitLock;
        synchronized (object) {
            if (this.mProtoLogInstance == null) {
                return;
            }
            if (this.mProtoLogInstance instanceof PerfettoProtoLogImpl) {
                ((PerfettoProtoLogImpl)this.mProtoLogInstance).disable();
            }
        }
    }

    @VisibleForTesting
    @NonNull
    public Set<IProtoLogGroup> getRegisteredGroups() {
        return Set.copyOf(this.mGroups);
    }

    protected boolean shouldLogOnlyToLogcat() {
        return ProtoLog.logOnlyToLogcat();
    }

    @NonNull
    protected IProtoLog createLogcatOnlyInstance() {
        return new LogcatOnlyProtoLogImpl();
    }

    @NonNull
    protected PerfettoProtoLogImpl createAndEnableNewPerfettoProtoLogImpl(@NonNull ProtoLogDataSource datasource, @NonNull IProtoLogGroup[] groups) {
        try {
            UnprocessedPerfettoProtoLogImpl unprocessedPerfettoProtoLogImpl = new UnprocessedPerfettoProtoLogImpl(datasource, groups);
            unprocessedPerfettoProtoLogImpl.enable();
            return unprocessedPerfettoProtoLogImpl;
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            throw new RuntimeException("Failed to create PerfettoProtoLogImpl", e);
        }
    }

    private void assertForCollisions(Set<IProtoLogGroup> newGroups) {
        HashSet<Integer> newIds = new HashSet<Integer>();
        for (IProtoLogGroup group : newGroups) {
            if (group == null || newIds.add(group.getId())) continue;
            throw new RuntimeException("ProtoLog group ID collision for ID " + group.getId() + " within the same registration call.");
        }
        for (IProtoLogGroup group : newGroups) {
            for (IProtoLogGroup existingGroup : this.mGroups) {
                if (existingGroup.getId() != group.getId() || existingGroup.equals(group)) continue;
                throw new RuntimeException("ProtoLog group ID collision for ID " + group.getId() + ". Group " + group.name() + " conflicts with already registered group " + existingGroup.name());
            }
        }
    }
}

